/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.LibC;
import jnr.posix.MsgHdr;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.RLimit;
import jnr.posix.SignalHandler;
import jnr.posix.SpawnAttribute;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import jnr.posix.util.ProcessMaker;

final class LazyPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final boolean useNativePosix;
    private volatile POSIX posix;

    LazyPOSIX(POSIXHandler handler, boolean useNativePosix) {
        this.handler = handler;
        this.useNativePosix = useNativePosix;
    }

    private final POSIX posix() {
        return this.posix != null ? this.posix : this.loadPOSIX();
    }

    private final synchronized POSIX loadPOSIX() {
        return this.posix != null ? this.posix : (this.posix = POSIXFactory.loadPOSIX(this.handler, this.useNativePosix));
    }

    @Override
    public ProcessMaker newProcessMaker(String ... command) {
        return this.posix().newProcessMaker(command);
    }

    @Override
    public ProcessMaker newProcessMaker() {
        return this.posix().newProcessMaker();
    }

    @Override
    public FileStat allocateStat() {
        return this.posix().allocateStat();
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return this.posix().allocateMsgHdr();
    }

    @Override
    public int chdir(String path2) {
        return this.posix().chdir(path2);
    }

    @Override
    public int chmod(String filename2, int mode2) {
        return this.posix().chmod(filename2, mode2);
    }

    @Override
    public int fchmod(int fd, int mode2) {
        return this.posix().fchmod(fd, mode2);
    }

    @Override
    public int chown(String filename2, int user, int group2) {
        return this.posix().chown(filename2, user, group2);
    }

    @Override
    public CharSequence crypt(CharSequence key2, CharSequence salt) {
        return this.posix().crypt(key2, salt);
    }

    @Override
    public byte[] crypt(byte[] key2, byte[] salt) {
        return this.posix().crypt(key2, salt);
    }

    @Override
    public int fchown(int fd, int user, int group2) {
        return this.posix().fchown(fd, user, group2);
    }

    @Override
    public int endgrent() {
        return this.posix().endgrent();
    }

    @Override
    public int endpwent() {
        return this.posix().endpwent();
    }

    @Override
    public int errno() {
        return this.posix().errno();
    }

    @Override
    public void errno(int value2) {
        this.posix().errno(value2);
    }

    @Override
    public int exec(String path2, String ... args2) {
        return this.posix().exec(path2, args2);
    }

    @Override
    public int exec(String path2, String[] args2, String[] envp) {
        return this.posix().exec(path2, args2, envp);
    }

    @Override
    public int execv(String path2, String[] argv) {
        return this.posix().execv(path2, argv);
    }

    @Override
    public int execve(String path2, String[] argv, String[] envp) {
        return this.posix().execve(path2, argv, envp);
    }

    @Override
    public int fork() {
        return this.posix().fork();
    }

    @Override
    public FileStat fstat(int fd) {
        return this.posix().fstat(fd);
    }

    @Override
    public int fstat(int fd, FileStat stat2) {
        return this.posix().fstat(fd, stat2);
    }

    @Override
    public FileStat fstat(FileDescriptor descriptor) {
        return this.posix().fstat(descriptor);
    }

    @Override
    public int fstat(FileDescriptor descriptor, FileStat stat2) {
        return this.posix().fstat(descriptor, stat2);
    }

    @Override
    public int getegid() {
        return this.posix().getegid();
    }

    @Override
    public int geteuid() {
        return this.posix().geteuid();
    }

    @Override
    public int getgid() {
        return this.posix().getgid();
    }

    @Override
    public int getdtablesize() {
        return this.posix().getdtablesize();
    }

    @Override
    public Group getgrent() {
        return this.posix().getgrent();
    }

    @Override
    public Group getgrgid(int which) {
        return this.posix().getgrgid(which);
    }

    @Override
    public Group getgrnam(String which) {
        return this.posix().getgrnam(which);
    }

    @Override
    public String getlogin() {
        return this.posix().getlogin();
    }

    @Override
    public int getpgid() {
        return this.posix().getpgid();
    }

    @Override
    public int getpgid(int pid2) {
        return this.posix().getpgid(pid2);
    }

    @Override
    public int getpgrp() {
        return this.posix().getpgrp();
    }

    @Override
    public int getpid() {
        return this.posix().getpid();
    }

    @Override
    public int getppid() {
        return this.posix().getppid();
    }

    @Override
    public int getpriority(int which, int who) {
        return this.posix().getpriority(which, who);
    }

    @Override
    public Passwd getpwent() {
        return this.posix().getpwent();
    }

    @Override
    public Passwd getpwnam(String which) {
        return this.posix().getpwnam(which);
    }

    @Override
    public Passwd getpwuid(int which) {
        return this.posix().getpwuid(which);
    }

    @Override
    public int getuid() {
        return this.posix().getuid();
    }

    @Override
    public int getrlimit(int resource2, RLimit rlim) {
        return this.posix().getrlimit(resource2, rlim);
    }

    @Override
    public int getrlimit(int resource2, Pointer rlim) {
        return this.posix().getrlimit(resource2, rlim);
    }

    @Override
    public RLimit getrlimit(int resource2) {
        return this.posix().getrlimit(resource2);
    }

    @Override
    public int setrlimit(int resource2, RLimit rlim) {
        return this.posix().setrlimit(resource2, rlim);
    }

    @Override
    public int setrlimit(int resource2, Pointer rlim) {
        return this.posix().setrlimit(resource2, rlim);
    }

    @Override
    public int setrlimit(int resource2, long rlimCur, long rlimMax) {
        return this.posix().setrlimit(resource2, rlimCur, rlimMax);
    }

    @Override
    public boolean isatty(FileDescriptor descriptor) {
        return this.posix().isatty(descriptor);
    }

    @Override
    public int kill(int pid2, int signal2) {
        return this.kill((long)pid2, signal2);
    }

    @Override
    public int kill(long pid2, int signal2) {
        return this.posix().kill(pid2, signal2);
    }

    @Override
    public SignalHandler signal(Signal sig, SignalHandler handler) {
        return this.posix().signal(sig, handler);
    }

    @Override
    public int lchmod(String filename2, int mode2) {
        return this.posix().lchmod(filename2, mode2);
    }

    @Override
    public int lchown(String filename2, int user, int group2) {
        return this.posix().lchown(filename2, user, group2);
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.posix().link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path2) {
        return this.posix().lstat(path2);
    }

    @Override
    public int lstat(String path2, FileStat stat2) {
        return this.posix().lstat(path2, stat2);
    }

    @Override
    public int mkdir(String path2, int mode2) {
        return this.posix().mkdir(path2, mode2);
    }

    @Override
    public String readlink(String path2) throws IOException {
        return this.posix().readlink(path2);
    }

    @Override
    public int readlink(CharSequence path2, byte[] buf, int bufsize) {
        return this.posix().readlink(path2, buf, bufsize);
    }

    @Override
    public int readlink(CharSequence path2, ByteBuffer buf, int bufsize) {
        return this.posix().readlink(path2, buf, bufsize);
    }

    @Override
    public int readlink(CharSequence path2, Pointer bufPtr, int bufsize) {
        return this.posix().readlink(path2, bufPtr, bufsize);
    }

    @Override
    public int rmdir(String path2) {
        return this.posix().rmdir(path2);
    }

    @Override
    public int setegid(int egid2) {
        return this.posix().setegid(egid2);
    }

    @Override
    public int seteuid(int euid2) {
        return this.posix().seteuid(euid2);
    }

    @Override
    public int setgid(int gid2) {
        return this.posix().setgid(gid2);
    }

    @Override
    public int setgrent() {
        return this.posix().setgrent();
    }

    @Override
    public int setpgid(int pid2, int pgid) {
        return this.posix().setpgid(pid2, pgid);
    }

    @Override
    public int setpgrp(int pid2, int pgrp) {
        return this.posix().setpgrp(pid2, pgrp);
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.posix().setpriority(which, who, prio);
    }

    @Override
    public int setpwent() {
        return this.posix().setpwent();
    }

    @Override
    public int setsid() {
        return this.posix().setsid();
    }

    @Override
    public int setuid(int uid2) {
        return this.posix().setuid(uid2);
    }

    @Override
    public FileStat stat(String path2) {
        return this.posix().stat(path2);
    }

    @Override
    public int stat(String path2, FileStat stat2) {
        return this.posix().stat(path2, stat2);
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.posix().symlink(oldpath, newpath);
    }

    @Override
    public int umask(int mask) {
        return this.posix().umask(mask);
    }

    @Override
    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        return this.posix().utimes(path2, atimeval, mtimeval);
    }

    @Override
    public int utimes(String path2, Pointer times2) {
        return this.posix().utimes(path2, times2);
    }

    @Override
    public int futimes(int fd, long[] atimeval, long[] mtimeval) {
        return this.posix().futimes(fd, atimeval, mtimeval);
    }

    @Override
    public int wait(int[] status2) {
        return this.posix().wait(status2);
    }

    @Override
    public int waitpid(int pid2, int[] status2, int flags) {
        return this.waitpid((long)pid2, status2, flags);
    }

    @Override
    public int waitpid(long pid2, int[] status2, int flags) {
        return this.posix().waitpid(pid2, status2, flags);
    }

    @Override
    public boolean isNative() {
        return this.posix().isNative();
    }

    @Override
    public LibC libc() {
        return this.posix().libc();
    }

    @Override
    public Pointer environ() {
        return this.posix().environ();
    }

    @Override
    public String getenv(String envName) {
        return this.posix().getenv(envName);
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        return this.posix().setenv(envName, envValue, overwrite);
    }

    @Override
    public int unsetenv(String envName) {
        return this.posix().unsetenv(envName);
    }

    @Override
    public long posix_spawnp(String path2, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        return this.posix().posix_spawnp(path2, fileActions, argv, envp);
    }

    @Override
    public long posix_spawnp(String path2, Collection<? extends SpawnFileAction> fileActions, Collection<? extends SpawnAttribute> spawnAttributes, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        return this.posix().posix_spawnp(path2, fileActions, spawnAttributes, argv, envp);
    }

    @Override
    public long sysconf(Sysconf name2) {
        return this.posix().sysconf(name2);
    }

    @Override
    public Times times() {
        return this.posix().times();
    }

    @Override
    public int flock(int fd, int mode2) {
        return this.posix().flock(fd, mode2);
    }

    @Override
    public int dup(int fd) {
        return this.posix().dup(fd);
    }

    @Override
    public int dup2(int oldFd, int newFd) {
        return this.posix().dup2(oldFd, newFd);
    }

    @Override
    public int fcntlInt(int fd, Fcntl fcntlConst, int arg2) {
        return this.posix().fcntlInt(fd, fcntlConst, arg2);
    }

    @Override
    public int fcntl(int fd, Fcntl fcntlConst) {
        return this.posix().fcntl(fd, fcntlConst);
    }

    @Override
    public int fcntl(int fd, Fcntl fcntlConst, int ... arg2) {
        return this.posix().fcntl(fd, fcntlConst);
    }

    @Override
    public int access(CharSequence path2, int amode) {
        return this.posix().access(path2, amode);
    }

    @Override
    public int close(int fd) {
        return this.posix().close(fd);
    }

    @Override
    public int unlink(CharSequence path2) {
        return this.posix().unlink(path2);
    }

    @Override
    public int open(CharSequence path2, int flags, int perm) {
        return this.posix().open(path2, flags, perm);
    }

    @Override
    public int write(int fd, byte[] buf, int n) {
        return this.posix().write(fd, buf, n);
    }

    @Override
    public int read(int fd, byte[] buf, int n) {
        return this.posix().read(fd, buf, n);
    }

    @Override
    public int read(int fd, ByteBuffer buf, int n) {
        return this.posix().read(fd, buf, n);
    }

    @Override
    public int write(int fd, ByteBuffer buf, int n) {
        return this.posix().write(fd, buf, n);
    }

    @Override
    public int pread(int fd, byte[] buf, int n, int offset2) {
        return this.posix().pread(fd, buf, n, offset2);
    }

    @Override
    public int pwrite(int fd, byte[] buf, int n, int offset2) {
        return this.posix().pwrite(fd, buf, n, offset2);
    }

    @Override
    public int pread(int fd, ByteBuffer buf, int n, int offset2) {
        return this.posix().pread(fd, buf, n, offset2);
    }

    @Override
    public int pwrite(int fd, ByteBuffer buf, int n, int offset2) {
        return this.posix().pwrite(fd, buf, n, offset2);
    }

    @Override
    public int lseek(int fd, long offset2, int whence) {
        return this.posix().lseek(fd, offset2, whence);
    }

    @Override
    public int pipe(int[] fds) {
        return this.posix().pipe(fds);
    }

    @Override
    public int socketpair(int domain, int type2, int protocol2, int[] fds) {
        return this.posix().socketpair(domain, type2, protocol2, fds);
    }

    @Override
    public int sendmsg(int socket2, MsgHdr message2, int flags) {
        return this.posix().sendmsg(socket2, message2, flags);
    }

    @Override
    public int recvmsg(int socket2, MsgHdr message2, int flags) {
        return this.posix().recvmsg(socket2, message2, flags);
    }

    @Override
    public int truncate(CharSequence path2, long length2) {
        return this.posix().truncate(path2, length2);
    }

    @Override
    public int ftruncate(int fd, long offset2) {
        return this.posix().ftruncate(fd, offset2);
    }

    @Override
    public int rename(CharSequence oldName, CharSequence newName) {
        return this.posix().rename(oldName, newName);
    }

    @Override
    public String getcwd() {
        return this.posix().getcwd();
    }

    @Override
    public int fsync(int fd) {
        return this.posix().fsync(fd);
    }

    @Override
    public int fdatasync(int fd) {
        return this.posix().fdatasync(fd);
    }

    @Override
    public int mkfifo(String path2, int mode2) {
        return this.posix().mkfifo(path2, mode2);
    }
}

