/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.assigner;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.assigner.Assigner;
import org.jruby.runtime.builtin.IRubyObject;

public class PreManyRest0Post0BlockAssigner
extends Assigner {
    private final int preLength;
    private final ListNode pre;
    private final Node blockVar;

    public PreManyRest0Post0BlockAssigner(ListNode pre, int preCount, Node blockVar) {
        this.pre = pre;
        this.preLength = preCount;
        this.blockVar = blockVar;
    }

    @Override
    public void assign(Ruby runtime, ThreadContext context, IRubyObject self2, Block block) {
        this.assignNilTo(runtime, context, self2, block, 0);
        this.blockVar.assign(runtime, context, self2, Helpers.processBlockArgument(runtime, block), Block.NULL_BLOCK, false);
    }

    @Override
    public void assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value1, Block block) {
        this.pre.get(0).assign(runtime, context, self2, value1, block, false);
        this.assignNilTo(runtime, context, self2, block, 1);
        this.blockVar.assign(runtime, context, self2, Helpers.processBlockArgument(runtime, block), Block.NULL_BLOCK, false);
    }

    @Override
    public void assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value1, IRubyObject value2, Block block) {
        this.pre.get(0).assign(runtime, context, self2, value1, block, false);
        this.pre.get(1).assign(runtime, context, self2, value1, block, false);
        this.assignNilTo(runtime, context, self2, block, 2);
        this.blockVar.assign(runtime, context, self2, Helpers.processBlockArgument(runtime, block), Block.NULL_BLOCK, false);
    }

    @Override
    public void assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value1, IRubyObject value2, IRubyObject value3, Block block) {
        this.pre.get(0).assign(runtime, context, self2, value1, block, false);
        this.pre.get(1).assign(runtime, context, self2, value1, block, false);
        this.pre.get(2).assign(runtime, context, self2, value1, block, false);
        this.assignNilTo(runtime, context, self2, block, 3);
        this.blockVar.assign(runtime, context, self2, Helpers.processBlockArgument(runtime, block), Block.NULL_BLOCK, false);
    }

    @Override
    public void assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject[] values2, Block block) {
        int valueLength = values2 == null ? 0 : values2.length;
        switch (valueLength) {
            case 0: {
                this.assign(runtime, context, self2, block);
                return;
            }
            case 1: {
                this.assign(runtime, context, self2, values2[0], block);
                return;
            }
            case 2: {
                this.assign(runtime, context, self2, values2[0], values2[1], block);
                return;
            }
        }
        for (int i2 = 0; i2 < this.preLength && i2 < valueLength; ++i2) {
            this.pre.get(i2).assign(runtime, context, self2, values2[i2], block, false);
        }
        if (valueLength < this.preLength) {
            this.assignNilTo(runtime, context, self2, block, valueLength);
        }
        this.blockVar.assign(runtime, context, self2, Helpers.processBlockArgument(runtime, block), Block.NULL_BLOCK, false);
    }

    @Override
    public void assignArray(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        RubyArray values2 = (RubyArray)arg2;
        int valueLength = values2.getLength();
        switch (valueLength) {
            case 0: {
                this.assign(runtime, context, self2, block);
                break;
            }
            case 1: {
                this.assign(runtime, context, self2, values2.eltInternal(0), block);
                break;
            }
            case 2: {
                this.assign(runtime, context, self2, values2.eltInternal(0), values2.eltInternal(1), block);
                break;
            }
            case 3: {
                this.assign(runtime, context, self2, values2.eltInternal(0), values2.eltInternal(1), values2.eltInternal(2), block);
            }
        }
        for (int i2 = 0; i2 < this.preLength && i2 < valueLength; ++i2) {
            this.pre.get(i2).assign(runtime, context, self2, values2.eltInternal(i2), block, false);
        }
        this.blockVar.assign(runtime, context, self2, Helpers.processBlockArgument(runtime, block), Block.NULL_BLOCK, false);
    }

    private void assignNilTo(Ruby runtime, ThreadContext context, IRubyObject self2, Block block, int start2) {
        IRubyObject nil = runtime.getNil();
        for (int i2 = start2; i2 < this.preLength; ++i2) {
            this.pre.get(i2).assign(runtime, context, self2, nil, block, false);
        }
    }
}

