/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.java.dispatch.CallableSelector;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.collections.IntHashMap;

public abstract class RubyToJavaInvoker
extends org.jruby.internal.runtime.methods.JavaMethod {
    static final IntHashMap<JavaCallable> NULL_CACHE = IntHashMap.nullMap();
    protected final JavaCallable javaCallable;
    protected final JavaCallable[][] javaCallables;
    protected final JavaCallable[] javaVarargsCallables;
    protected final int minVarargsArity;
    final IntHashMap<JavaCallable> cache;
    private final Ruby runtime;
    private final Member[] members;

    RubyToJavaInvoker(RubyModule host, Member[] members2) {
        super(host, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone);
        JavaCallable[][] callables;
        JavaCallable callable;
        this.members = members2;
        this.runtime = host.getRuntime();
        this.setArity(Arity.OPTIONAL);
        JavaCallable[] varargsCallables = null;
        int varArgsArity = Integer.MAX_VALUE;
        int length2 = members2.length;
        if (length2 == 1) {
            callable = this.createCallable(this.runtime, members2[0]);
            if (callable.isVarArgs()) {
                varargsCallables = this.createCallableArray(callable);
            }
            callables = null;
            this.cache = NULL_CACHE;
        } else {
            callable = null;
            IntHashMap arityMap = new IntHashMap(length2, 1.0f);
            ArrayList<JavaCallable> varArgs = null;
            int maxArity = 0;
            for (int i2 = 0; i2 < length2; ++i2) {
                Member method2 = members2[i2];
                int currentArity = this.getMemberParameterTypes(method2).length;
                maxArity = Math.max(currentArity, maxArity);
                ArrayList<JavaCallable> methodsForArity = (ArrayList<JavaCallable>)arityMap.get(currentArity);
                if (methodsForArity == null) {
                    methodsForArity = new ArrayList<JavaCallable>(length2);
                    arityMap.put(currentArity, methodsForArity);
                }
                JavaCallable javaMethod = this.createCallable(this.runtime, method2);
                methodsForArity.add(javaMethod);
                if (!this.isMemberVarArgs(method2)) continue;
                varArgsArity = Math.min(currentArity - 1, varArgsArity);
                if (varArgs == null) {
                    varArgs = new ArrayList<JavaCallable>(length2);
                }
                varArgs.add(javaMethod);
            }
            callables = this.createCallableArrayArray(maxArity + 1);
            for (IntHashMap.Entry entry : arityMap.entrySet()) {
                ArrayList methodsForArity = (ArrayList)entry.getValue();
                JavaCallable[] methodsArray = methodsForArity.toArray(this.createCallableArray(methodsForArity.size()));
                callables[entry.getKey()] = methodsArray;
            }
            if (varArgs != null) {
                varargsCallables = varArgs.toArray(this.createCallableArray(varArgs.size()));
            }
            this.cache = CallableSelector.newCallableCache();
        }
        this.javaCallable = callable;
        this.javaCallables = callables;
        this.javaVarargsCallables = varargsCallables;
        this.minVarargsArity = varArgsArity;
        if (this.javaCallable != null) {
            if (this.javaCallable instanceof JavaMethod) {
                this.setNativeCallIfPublic(((JavaMethod)this.javaCallable).getValue());
            }
        } else {
            Method method3;
            JavaCallable[] callablesForArity;
            for (int i3 = 0; !(i3 >= this.javaCallables.length || (callablesForArity = this.javaCallables[i3]) != null && callablesForArity.length == 1 && callablesForArity[0] instanceof JavaMethod && this.setNativeCallIfPublic(method3 = ((JavaMethod)callablesForArity[0]).getValue())); ++i3) {
            }
        }
    }

    private boolean setNativeCallIfPublic(Method method2) {
        int mod = method2.getModifiers();
        if (Modifier.isPublic(mod) && Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
            this.setNativeCall(method2.getDeclaringClass(), method2.getName(), method2.getReturnType(), method2.getParameterTypes(), Modifier.isStatic(mod), true);
            return true;
        }
        return false;
    }

    protected final Member[] getMembers() {
        return this.members;
    }

    protected AccessibleObject[] getAccessibleObjects() {
        return (AccessibleObject[])this.getMembers();
    }

    protected abstract JavaCallable createCallable(Ruby var1, Member var2);

    protected abstract JavaCallable[] createCallableArray(JavaCallable var1);

    protected abstract JavaCallable[] createCallableArray(int var1);

    protected abstract JavaCallable[][] createCallableArrayArray(int var1);

    protected abstract Class[] getMemberParameterTypes(Member var1);

    protected abstract boolean isMemberVarArgs(Member var1);

    public static Object[] convertArguments(ParameterTypes method2, IRubyObject[] args2) {
        Object[] javaArgs;
        Class<?>[] paramTypes = method2.getParameterTypes();
        int len = args2.length;
        if (method2.isVarArgs()) {
            int last2 = paramTypes.length - 1;
            javaArgs = new Object[last2 + 1];
            for (int i2 = 0; i2 < last2; ++i2) {
                javaArgs[i2] = args2[i2].toJava(paramTypes[i2]);
            }
            javaArgs[last2] = RubyToJavaInvoker.convertVarArgumentsOnly(paramTypes[last2], last2, args2);
        } else {
            javaArgs = new Object[len];
            for (int i3 = 0; i3 < len; ++i3) {
                javaArgs[i3] = args2[i3].toJava(paramTypes[i3]);
            }
        }
        return javaArgs;
    }

    private static Object convertVarArgumentsOnly(Class<?> varArrayType, int varStart, IRubyObject[] args2) {
        int varCount = args2.length - varStart;
        if (args2.length == 0 || varCount <= 0) {
            return Array.newInstance(varArrayType.getComponentType(), 0);
        }
        if (varCount == 1 && args2[varStart] instanceof ArrayJavaProxy) {
            return args2[varStart].toJava(varArrayType);
        }
        Class<?> compType = varArrayType.getComponentType();
        Object varArgs = Array.newInstance(compType, varCount);
        for (int i2 = 0; i2 < varCount; ++i2) {
            Array.set(varArgs, i2, args2[varStart + i2].toJava(compType));
        }
        return varArgs;
    }

    static JavaProxy castJavaProxy(IRubyObject self2) {
        assert (self2 instanceof JavaProxy) : "Java methods can only be invoked on Java objects";
        return (JavaProxy)self2;
    }

    static void trySetAccessible(AccessibleObject ... accesibles) {
        if (!Ruby.isSecurityRestricted()) {
            try {
                AccessibleObject.setAccessible(accesibles, true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    protected JavaCallable findCallable(IRubyObject self2, String name2, IRubyObject[] args2, int arity2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            ParameterTypes[] callablesForArity;
            if (arity2 >= this.javaCallables.length || (callablesForArity = this.javaCallables[arity2]) == null) {
                callable = this.matchVarArgsCallableArityN(self2, args2);
                if (callable == null) {
                    throw this.runtime.newArgumentError(args2.length, this.javaCallables.length - 1);
                }
                return callable;
            }
            callable = (JavaCallable)CallableSelector.matchingCallableArityN((Ruby)this.runtime, this.cache, (ParameterTypes[])callablesForArity, (IRubyObject[])args2);
            if (callable == null && (callable = this.matchVarArgsCallableArityN(self2, args2)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, args2);
            }
        } else if (!callable.isVarArgs()) {
            this.checkCallableArity(callable, args2.length);
        }
        return callable;
    }

    private JavaCallable matchVarArgsCallableArityN(IRubyObject self2, IRubyObject[] args2) {
        ParameterTypes[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = (JavaCallable)CallableSelector.matchingCallableArityN((Ruby)this.runtime, this.cache, (ParameterTypes[])varArgsCallables, (IRubyObject[])args2);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, args2);
            }
            return callable;
        }
        return null;
    }

    protected final JavaCallable findCallableArityZero(IRubyObject self2, String name2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity;
            if (this.javaCallables.length == 0 || (callablesForArity = this.javaCallables[0]) == null) {
                throw this.newErrorDueNoMatchingCallable(self2, name2);
            }
            callable = callablesForArity[0];
        } else {
            this.checkCallableArity(callable, 0);
        }
        return callable;
    }

    protected final JavaCallable findCallableArityOne(IRubyObject self2, String name2, IRubyObject arg0) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            ParameterTypes[] callablesForArity;
            if (this.javaCallables.length <= 1 || (callablesForArity = this.javaCallables[1]) == null) {
                throw this.runtime.newArgumentError(1, this.javaCallables.length - 1);
            }
            callable = (JavaCallable)CallableSelector.matchingCallableArityOne((Ruby)this.runtime, this.cache, (ParameterTypes[])callablesForArity, (IRubyObject)arg0);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, arg0);
            }
        } else {
            this.checkCallableArity(callable, 1);
        }
        return callable;
    }

    protected final JavaCallable findCallableArityTwo(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            ParameterTypes[] callablesForArity;
            if (this.javaCallables.length <= 2 || (callablesForArity = this.javaCallables[2]) == null) {
                throw this.runtime.newArgumentError(2, this.javaCallables.length - 1);
            }
            callable = (JavaCallable)CallableSelector.matchingCallableArityTwo((Ruby)this.runtime, this.cache, (ParameterTypes[])callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, arg0, arg1);
            }
        } else {
            this.checkCallableArity(callable, 2);
        }
        return callable;
    }

    protected final JavaCallable findCallableArityThree(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            ParameterTypes[] callablesForArity;
            if (this.javaCallables.length <= 3 || (callablesForArity = this.javaCallables[3]) == null) {
                throw this.runtime.newArgumentError(3, this.javaCallables.length - 1);
            }
            callable = (JavaCallable)CallableSelector.matchingCallableArityThree((Ruby)this.runtime, this.cache, (ParameterTypes[])callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, arg0, arg1, arg2);
            }
        } else {
            this.checkCallableArity(callable, 3);
        }
        return callable;
    }

    protected final JavaCallable findCallableArityFour(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            ParameterTypes[] callablesForArity;
            if (this.javaCallables.length <= 4 || (callablesForArity = this.javaCallables[4]) == null) {
                throw this.runtime.newArgumentError(4, this.javaCallables.length - 1);
            }
            callable = (JavaCallable)CallableSelector.matchingCallableArityFour((Ruby)this.runtime, this.cache, (ParameterTypes[])callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2, (IRubyObject)arg3);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, arg0, arg1, arg2, arg3);
            }
        } else {
            this.checkCallableArity(callable, 4);
        }
        return callable;
    }

    private void checkCallableArity(JavaCallable callable, int expected) {
        int arity2 = callable.getArity();
        if (arity2 != expected) {
            throw this.runtime.newArgumentError(expected, arity2);
        }
    }

    private JavaCallable someCallable() {
        if (this.javaCallable == null) {
            for (int i2 = 0; i2 < this.javaCallables.length; ++i2) {
                JavaCallable[] callables = this.javaCallables[i2];
                if (callables == null || callables.length <= 0) continue;
                for (int j = 0; j < callables.length; ++j) {
                    if (callables[j] == null) continue;
                    return callables[j];
                }
            }
            return null;
        }
        return this.javaCallable;
    }

    private boolean isConstructor() {
        return this.someCallable() instanceof JavaConstructor;
    }

    RaiseException newErrorDueArgumentTypeMismatch(IRubyObject receiver2, JavaCallable[] methods2, IRubyObject ... args2) {
        Class[] argTypes = new Class[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            argTypes[i2] = RubyToJavaInvoker.getClass(args2[i2]);
        }
        StringBuilder error2 = new StringBuilder(64);
        error2.append("no ");
        if (this.isConstructor()) {
            error2.append("constructor");
        } else {
            JavaMethod method2 = (JavaMethod)methods2[0];
            error2.append("method '").append(method2.getValue().getName()).append("'");
        }
        error2.append(" for arguments ");
        CodegenUtils.prettyParams(error2, argTypes);
        error2.append(" on ").append(RubyToJavaInvoker.formatReceiver(receiver2));
        if (methods2.length > 1) {
            error2.append("\n  available overloads:");
            for (JavaCallable method3 : methods2) {
                Class[] paramTypes = method3.getParameterTypes();
                error2.append("\n    ");
                CodegenUtils.prettyParams(error2, paramTypes);
            }
        }
        return this.runtime.newNameError(error2.toString(), null);
    }

    private RaiseException newErrorDueNoMatchingCallable(IRubyObject receiver2, String name2) {
        StringBuilder error2 = new StringBuilder(48);
        error2.append("no ");
        if (this.isConstructor()) {
            error2.append("constructor");
        } else {
            error2.append("method '").append(name2).append("'");
        }
        error2.append(" (for zero arguments) on ").append(RubyToJavaInvoker.formatReceiver(receiver2));
        return this.runtime.newArgumentError(error2.toString());
    }

    private static Class<?> getClass(IRubyObject object) {
        if (object == null) {
            return Void.TYPE;
        }
        if (object instanceof ConcreteJavaProxy) {
            return ((ConcreteJavaProxy)object).getJavaClass();
        }
        return object.getClass();
    }

    private static String formatReceiver(IRubyObject object) {
        if (object instanceof RubyModule) {
            return ((RubyModule)object).getName();
        }
        return object.getMetaClass().getRealClass().getName();
    }
}

