/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import jnr.constants.platform.Errno;
import jnr.posix.FileStat;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;

class EmptyFileResource
implements FileResource {
    static final EmptyFileResource INSTANCE = new EmptyFileResource();

    EmptyFileResource() {
    }

    public static EmptyFileResource create(String pathname2) {
        return pathname2 == null || pathname2.isEmpty() ? INSTANCE : null;
    }

    @Override
    public String absolutePath() {
        return "";
    }

    @Override
    public String canonicalPath() {
        return "";
    }

    @Override
    public String path() {
        return "";
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileStat stat() {
        return null;
    }

    @Override
    public FileStat lstat() {
        return null;
    }

    @Override
    public int errno() {
        return Errno.ENOENT.intValue();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        throw new ResourceException.NotFound("");
    }

    @Override
    public Channel openChannel(int flags2, int perm) throws IOException {
        throw new ResourceException.NotFound(this.absolutePath());
    }

    @Override
    public <T> T unwrap(Class<T> type2) throws UnsupportedOperationException {
        if (type2 == File.class || type2 == JRubyFile.class) {
            return (T)JRubyFile.DUMMY;
        }
        throw new UnsupportedOperationException("unwrap: " + type2.getName());
    }

    public String toString() {
        return "";
    }
}

