/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockNoResultCallInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.CallType;

public class NoResultCallInstr
extends CallBase {
    public static NoResultCallInstr create(IRScope scope, CallType callType, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure, boolean isPotentiallyRefined) {
        if (closure == null && !NoResultCallInstr.containsArgSplat(args2) && args2.length == 1) {
            return new OneOperandArgNoBlockNoResultCallInstr(scope, callType, name2, receiver2, args2, null, isPotentiallyRefined);
        }
        return new NoResultCallInstr(scope, Operation.NORESULT_CALL, callType, name2, receiver2, args2, closure, isPotentiallyRefined);
    }

    public NoResultCallInstr(IRScope scope, Operation op, CallType callType, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure, boolean isPotentiallyRefined) {
        super(scope, op, callType, name2, receiver2, args2, closure, isPotentiallyRefined);
    }

    @Override
    public Variable getResult() {
        return null;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new NoResultCallInstr(ii.getScope(), this.getOperation(), this.getCallType(), this.getName(), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.getClosureArg() == null ? null : this.getClosureArg().cloneForInlining(ii), this.isPotentiallyRefined());
    }

    public static NoResultCallInstr decode(IRReaderDecoder d) {
        int argsLength;
        int callTypeOrdinal = d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, ordinal:  " + callTypeOrdinal);
        }
        RubySymbol name2 = d.decodeSymbol();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, methaddr:  " + name2);
        }
        Operand receiver2 = d.decodeOperand();
        int argsCount = d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = d.decodeOperand();
        }
        Operand closure = hasClosureArg ? d.decodeOperand() : null;
        return NoResultCallInstr.create(d.getCurrentScope(), CallType.fromOrdinal(callTypeOrdinal), name2, receiver2, args2, closure, d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.NoResultCallInstr(this);
    }
}

