/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import jnr.posix.FileStat;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Dir"}, include={"Enumerable"})
public class RubyDir
extends RubyObject
implements Closeable {
    private RubyString path;
    protected FileResource dir;
    private long lastModified = Long.MIN_VALUE;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private Encoding encoding;
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:]*:)?//?.*");
    private static final ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyDir(runtime2, klass);
        }
    };
    private static final String[] BASE = new String[]{"base"};
    private static final String[] BASE_FLAGS = new String[]{"base", "flags"};
    private static final String[] NO_FILES = StringSupport.EMPTY_STRING_ARRAY;
    static final ByteList HOME = new ByteList(new byte[]{72, 79, 77, 69}, false);
    private static final ByteList user_home = new ByteList(new byte[]{117, 115, 101, 114, 46, 104, 111, 109, 101}, false);

    public RubyDir(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static RubyClass createDirClass(Ruby runtime2) {
        RubyClass dirClass = runtime2.defineClass("Dir", runtime2.getObject(), DIR_ALLOCATOR);
        dirClass.setClassIndex(ClassIndex.DIR);
        dirClass.setReifiedClass(RubyDir.class);
        dirClass.includeModule(runtime2.getEnumerable());
        dirClass.defineAnnotatedMethods(RubyDir.class);
        return dirClass;
    }

    private final void checkDir() {
        this.checkDirIgnoreClosed();
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
    }

    private final void checkDirIgnoreClosed() {
        this.testFrozen("Dir");
        if (this.snapshot == null || this.dir.exists() && this.dir.lastModified() > this.lastModified) {
            this.lastModified = this.dir.lastModified();
            this.snapshot = RubyDir.list(this.dir);
        }
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        Ruby runtime2 = context.runtime;
        return this.initializeCommon(context, path2, runtime2.getDefaultFilesystemEncoding(), runtime2);
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject path2, IRubyObject encOpts) {
        RubyHash opts;
        IRubyObject encodingArg;
        Ruby runtime2 = context.runtime;
        Encoding encoding2 = null;
        if (!encOpts.isNil() && (encodingArg = ArgsUtil.extractKeywordArg(context, opts = encOpts.convertToHash(), "encoding")) != null && !encodingArg.isNil()) {
            encoding2 = runtime2.getEncodingService().getEncodingFromObject(encodingArg);
        }
        if (encoding2 == null) {
            encoding2 = runtime2.getDefaultFilesystemEncoding();
        }
        return this.initializeCommon(context, path2, encoding2, runtime2);
    }

    private RubyDir initializeCommon(ThreadContext context, IRubyObject pathArg, Encoding encoding2, Ruby runtime2) {
        RubyString newPath;
        this.path = newPath = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, pathArg));
        this.pos = 0;
        this.encoding = encoding2;
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime2, newPath.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(this.getRuntime(), adjustedPath);
        this.dir = JRubyFile.createResource(context, adjustedPath);
        this.snapshot = RubyDir.getEntries(context, this.dir, adjustedPath);
        return this;
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context, IRubyObject arg2) {
        return this.initialize(context, arg2);
    }

    private static ArrayList<ByteList> dirGlobs(ThreadContext context, String cwd, IRubyObject[] args2, int flags2) {
        ArrayList<ByteList> dirs = new ArrayList<ByteList>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            dirs.addAll(Dir.push_glob(context.runtime, cwd, RubyDir.globArgumentAsByteList(context, args2[i2]), flags2));
        }
        return dirs;
    }

    private static RubyArray asRubyStringList(Ruby runtime2, List<ByteList> dirs) {
        int size2 = dirs.size();
        if (size2 == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] dirStrings = new IRubyObject[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            dirStrings[i2] = RubyString.newStringNoCopy(runtime2, dirs.get(i2));
        }
        return RubyArray.newArrayMayCopy(runtime2, dirStrings);
    }

    private static String getCWD(Ruby runtime2) {
        String cwd = runtime2.getCurrentDirectory();
        if (cwd.startsWith("uri:") || cwd.startsWith("jar:") || cwd.startsWith("file:")) {
            return cwd;
        }
        try {
            return new JRubyFile(cwd).getCanonicalPath();
        }
        catch (IOException e) {
            return cwd;
        }
    }

    private static String globOptions(ThreadContext context, IRubyObject[] args2, int[] flags2) {
        Ruby runtime2 = context.runtime;
        if (args2.length > 1) {
            IRubyObject tmp = TypeConverter.checkHashType(runtime2, args2[args2.length - 1]);
            if (tmp == context.nil) {
                if (flags2 != null) {
                    flags2[0] = RubyNumeric.num2int(args2[1]);
                }
            } else {
                String[] keys2 = flags2 != null ? BASE_FLAGS : BASE;
                IRubyObject[] rets = ArgsUtil.extractKeywordArgs(context, (RubyHash)tmp, keys2);
                if (rets[0] == null || rets[0].isNil()) {
                    return "";
                }
                RubyString path2 = RubyFile.get_path(context, rets[0]);
                Encoding[] enc = new Encoding[]{path2.getEncoding()};
                String base = path2.getUnicodeValue();
                if (!base.isEmpty()) {
                    base = RubyFile.expandPath(context, base, enc, runtime2.getCurrentDirectory(), true, false);
                }
                if (flags2 != null) {
                    flags2[0] = rets[1] == null ? 0 : RubyNumeric.num2int(rets[1]);
                }
                return base;
            }
        }
        return null;
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        List<ByteList> dirs;
        Ruby runtime2 = context.runtime;
        String base = RubyDir.globOptions(context, args2, null);
        if (args2.length == 1) {
            String dir = base == null || base.isEmpty() ? runtime2.getCurrentDirectory() : base;
            dirs = Dir.push_glob(runtime2, dir, RubyDir.globArgumentAsByteList(context, args2[0]), 0);
        } else {
            IRubyObject[] arefArgs;
            if (base != null) {
                arefArgs = ArraySupport.newCopy(args2, args2.length - 1);
            } else {
                arefArgs = args2;
                base = "";
            }
            String dir = base.isEmpty() ? runtime2.getCurrentDirectory() : base;
            dirs = RubyDir.dirGlobs(context, dir, arefArgs, 0);
        }
        return RubyDir.asRubyStringList(runtime2, dirs);
    }

    private static ByteList globArgumentAsByteList(ThreadContext context, IRubyObject arg2) {
        return RubyFile.get_path(context, arg2).getByteList();
    }

    @JRubyMethod(required=1, optional=2, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        List<ByteList> dirs;
        Ruby runtime2 = context.runtime;
        int[] flags2 = new int[]{0};
        String base = RubyDir.globOptions(context, args2, flags2);
        if (base != null && !base.isEmpty() && !JRubyFile.createResource(context, base).exists()) {
            dirs = new ArrayList<ByteList>();
        } else {
            IRubyObject tmp = args2[0].checkArrayType();
            String dir = base == null || base.isEmpty() ? runtime2.getCurrentDirectory() : base;
            dirs = tmp.isNil() ? Dir.push_glob(runtime2, dir, RubyDir.globArgumentAsByteList(context, args2[0]), flags2[0]) : RubyDir.dirGlobs(context, dir, ((RubyArray)tmp).toJavaArray(), flags2[0]);
        }
        if (block.isGiven()) {
            for (int i2 = 0; i2 < dirs.size(); ++i2) {
                block.yield(context, RubyString.newString(runtime2, (ByteList)dirs.get(i2)));
            }
            return runtime2.getNil();
        }
        return RubyDir.asRubyStringList(runtime2, dirs);
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries() {
        JavaUtil.StringConverter converter = new JavaUtil.StringConverter(this.encoding);
        return RubyArray.newArrayMayCopy(this.getRuntime(), JavaUtil.convertStringArrayToRuby(this.getRuntime(), this.snapshot, converter));
    }

    @JRubyMethod(name={"entries"}, meta=true)
    public static RubyArray entries(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, arg2));
        return RubyDir.entriesCommon(context, path2.asJavaString(), runtime2.getDefaultEncoding(), false);
    }

    @JRubyMethod(name={"entries"}, meta=true)
    public static RubyArray entries(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        Ruby runtime2 = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, arg2));
        Encoding encoding2 = RubyDir.getEncodingFromOpts(context, opts);
        return RubyDir.entriesCommon(context, path2.asJavaString(), encoding2, false);
    }

    private static RubyArray entriesCommon(ThreadContext context, String path2, Encoding encoding2, boolean childrenOnly) {
        Ruby runtime2 = context.runtime;
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime2, path2, null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime2, adjustedPath);
        FileResource directory = JRubyFile.createResource(context, path2);
        String[] files = RubyDir.getEntries(context, directory, adjustedPath);
        RubyArray result2 = RubyArray.newArray(runtime2, files.length);
        for (String file2 : files) {
            int len;
            if (childrenOnly && ((len = file2.length()) == 1 && file2.charAt(0) == '.' || len == 2 && file2.charAt(0) == '.' && file2.charAt(1) == '.')) continue;
            result2.append(RubyString.newString(runtime2, file2, encoding2));
        }
        return result2;
    }

    private static String[] getEntries(ThreadContext context, FileResource dir, String path2) {
        if (!dir.isDirectory()) {
            if (dir.exists()) {
                throw context.runtime.newErrnoENOTDIRError(path2);
            }
            throw context.runtime.newErrnoENOENTError(path2);
        }
        if (!dir.canRead()) {
            throw context.runtime.newErrnoEACCESError(path2);
        }
        String[] list2 = dir.list();
        return list2 == null ? NO_FILES : list2;
    }

    private static void checkDirIsTwoSlashesOnWindows(Ruby runtime2, String path2) {
        if (Platform.IS_WINDOWS && ("//".equals(path2) || "\\\\".equals(path2))) {
            throw runtime2.newErrnoEINVALError("Invalid argument - " + path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=1, meta=true)
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject result2;
        Ruby runtime2 = context.runtime;
        RubyString path2 = args2.length == 1 ? StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[0])) : RubyDir.getHomeDirectoryPath(context);
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime2, path2.asJavaString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime2, adjustedPath);
        adjustedPath = RubyDir.getExistingDir(runtime2, adjustedPath).canonicalPath();
        if (block.isGiven()) {
            String oldCwd = runtime2.getCurrentDirectory();
            runtime2.setCurrentDirectory(adjustedPath);
            try {
                result2 = block.yield(context, path2);
            }
            finally {
                RubyDir.getExistingDir(runtime2, oldCwd);
                runtime2.setCurrentDirectory(oldCwd);
            }
        } else {
            runtime2.setCurrentDirectory(adjustedPath);
            result2 = runtime2.newFixnum(0);
        }
        return result2;
    }

    @JRubyMethod(name={"chroot"}, required=1, meta=true)
    public static IRubyObject chroot(IRubyObject recv2, IRubyObject path2) {
        throw recv2.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    @JRubyMethod(name={"children"}, meta=true)
    public static RubyArray children(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyDir.children(context, recv2, arg2, context.nil);
    }

    @JRubyMethod(name={"children"}, meta=true)
    public static RubyArray children(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        Ruby runtime2 = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, arg2));
        Encoding encoding2 = RubyDir.getEncodingFromOpts(context, opts);
        return RubyDir.entriesCommon(context, path2.asJavaString(), encoding2, true);
    }

    public static IRubyObject rmdir(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.rmdir19(recv2.getRuntime().getCurrentContext(), recv2, path2);
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true)
    public static IRubyObject rmdir19(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        Ruby runtime2 = context.runtime;
        RubyString cleanPath = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, path2));
        return RubyDir.rmdirCommon(runtime2, cleanPath.asJavaString());
    }

    private static RubyFixnum rmdirCommon(Ruby runtime2, String path2) {
        JRubyFile directory = RubyDir.getDirForRmdir(runtime2, path2);
        if (runtime2.getPosix().rmdir(directory.toString()) < 0) {
            throw runtime2.newErrnoENOTEMPTYError(path2);
        }
        return runtime2.newFixnum(0);
    }

    @JRubyMethod(name={"each_child"}, meta=true)
    public static IRubyObject each_child(ThreadContext context, IRubyObject recv2, IRubyObject arg2, Block block) {
        return RubyDir.eachChildCommon(context, recv2, RubyFile.get_path(context, arg2), null, block);
    }

    @JRubyMethod(name={"each_child"}, meta=true)
    public static IRubyObject each_child(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject encOpts, Block block) {
        Encoding encoding2 = RubyDir.getEncodingFromOpts(context, encOpts);
        return RubyDir.eachChildCommon(context, recv2, RubyFile.get_path(context, arg2), encOpts, block);
    }

    @JRubyMethod(name={"foreach"}, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        return RubyDir.foreachCommon(context, recv2, RubyFile.get_path(context, path2), null, block);
    }

    @JRubyMethod(name={"foreach"}, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject encOpts, Block block) {
        return RubyDir.foreachCommon(context, recv2, RubyFile.get_path(context, path2), encOpts, block);
    }

    private static Encoding getEncodingFromOpts(ThreadContext context, IRubyObject encOpts) {
        Ruby runtime2 = context.runtime;
        Encoding encoding2 = null;
        if (!encOpts.isNil()) {
            IRubyObject opts = ArgsUtil.getOptionsArg(runtime2, encOpts);
            if (opts.isNil()) {
                throw runtime2.newArgumentError(2, 1, 1);
            }
            IRubyObject encodingArg = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "encoding");
            if (encodingArg != null && !encodingArg.isNil()) {
                encoding2 = runtime2.getEncodingService().getEncodingFromObject(encodingArg);
            }
        }
        if (encoding2 == null) {
            encoding2 = runtime2.getDefaultEncoding();
        }
        return encoding2;
    }

    private static IRubyObject eachChildCommon(ThreadContext context, IRubyObject recv2, RubyString path2, IRubyObject encOpts, Block block) {
        Ruby runtime2 = context.runtime;
        if (block.isGiven()) {
            Encoding encoding2 = encOpts == null ? runtime2.getDefaultEncoding() : RubyDir.getEncodingFromOpts(context, encOpts);
            RubyDir dir = (RubyDir)runtime2.getDir().newInstance(context, path2, Block.NULL_BLOCK);
            dir.each_child(context, encoding2, block);
            return context.nil;
        }
        if (encOpts == null) {
            return RubyEnumerator.enumeratorize(runtime2, recv2, "each_child", (IRubyObject)path2);
        }
        return RubyEnumerator.enumeratorize(runtime2, recv2, "each_child", path2, encOpts);
    }

    private static IRubyObject foreachCommon(ThreadContext context, IRubyObject recv2, RubyString path2, IRubyObject encOpts, Block block) {
        Ruby runtime2 = context.runtime;
        if (block.isGiven()) {
            Encoding encoding2 = encOpts == null ? runtime2.getDefaultEncoding() : RubyDir.getEncodingFromOpts(context, encOpts);
            RubyDir dir = (RubyDir)runtime2.getDir().newInstance(context, path2, Block.NULL_BLOCK);
            dir.each(context, encoding2, block);
            return context.nil;
        }
        if (encOpts == null) {
            return RubyEnumerator.enumeratorize(runtime2, recv2, "foreach", (IRubyObject)path2);
        }
        return RubyEnumerator.enumeratorize(runtime2, recv2, "foreach", path2, encOpts);
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        RubyString pwd = RubyString.newUnicodeString(runtime2, RubyDir.getCWD(runtime2));
        pwd.setTaint(true);
        return pwd;
    }

    @JRubyMethod(name={"home"}, optional=1, meta=true)
    public static IRubyObject home(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length > 0 && args2[0] != context.nil) {
            return RubyDir.getHomeDirectoryPath(context, args2[0].toString());
        }
        return RubyDir.getHomeDirectoryPath(context);
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true)
    public static IRubyObject mkdir(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        Ruby runtime2 = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[0]));
        return RubyDir.mkdirCommon(runtime2, path2.asJavaString(), args2);
    }

    @Deprecated
    public static IRubyObject mkdir(IRubyObject recv2, IRubyObject[] args2) {
        return RubyDir.mkdir(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @Deprecated
    public static IRubyObject mkdir19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyDir.mkdir(context, recv2, args2);
    }

    private static IRubyObject mkdirCommon(Ruby runtime2, String path2, IRubyObject[] args2) {
        int mode2;
        if (path2.startsWith("uri:")) {
            throw runtime2.newErrnoEACCESError(path2);
        }
        FileResource res = JRubyFile.createResource(runtime2, path2 = RubyDir.dirFromPath(path2, runtime2));
        if (res.isDirectory()) {
            throw runtime2.newErrnoEEXISTError(path2);
        }
        String name2 = path2.replace('\\', '/');
        boolean startsWithDriveLetterOnWindows = RubyFile.startsWithDriveLetterOnWindows(name2);
        if (startsWithDriveLetterOnWindows) {
            if (path2.length() == 2) {
                return RubyFixnum.zero(runtime2);
            }
            if (path2.length() == 3 && (path2.charAt(0) == '/' || path2.charAt(2) == '/')) {
                return RubyFixnum.zero(runtime2);
            }
            if (path2.length() == 4 && path2.charAt(0) == '/' && path2.charAt(3) == '/') {
                return RubyFixnum.zero(runtime2);
            }
        }
        File newDir = res.unwrap(File.class);
        if (File.separatorChar == '\\') {
            newDir = new File(newDir.getPath());
        }
        int n = mode2 = args2.length == 2 ? (int)args2[1].convertToInteger().getLongValue() : 511;
        if (runtime2.getPosix().mkdir(newDir.getAbsolutePath(), mode2) < 0) {
            throw runtime2.newSystemCallError("mkdir failed");
        }
        return RubyFixnum.zero(runtime2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        RubyDir directory = (RubyDir)context.runtime.getDir().newInstance(context, path2, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, directory);
            return iRubyObject;
        }
        finally {
            directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject encOpts, Block block) {
        RubyDir directory = (RubyDir)context.runtime.getDir().newInstance(context, path2, encOpts, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, directory);
            return iRubyObject;
        }
        finally {
            directory.close();
        }
    }

    @Deprecated
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        return RubyDir.open(context, recv2, path2, block);
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close(ThreadContext context) {
        this.close();
        return context.nil;
    }

    @Override
    public final void close() {
        this.checkDirIgnoreClosed();
        this.isOpen = false;
    }

    public IRubyObject each(ThreadContext context, Encoding enc, Block block) {
        this.checkDir();
        String[] contents = this.snapshot;
        this.pos = 0;
        while (this.pos < contents.length) {
            block.yield(context, RubyString.newString(context.runtime, contents[this.pos], enc));
            ++this.pos;
        }
        return this;
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.each(context, this.encoding, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each");
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, IRubyObject encOpts, Block block) {
        Encoding encoding2 = RubyDir.getEncodingFromOpts(context, encOpts);
        return block.isGiven() ? this.each(context, encoding2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", encOpts);
    }

    @Deprecated
    public IRubyObject each19(ThreadContext context, Block block) {
        return this.each(context, block);
    }

    @Deprecated
    public IRubyObject each19(ThreadContext context, IRubyObject encoding2, Block block) {
        return this.each(context, encoding2, block);
    }

    public IRubyObject each_child(ThreadContext context, Encoding enc, Block block) {
        this.checkDir();
        String[] contents = this.snapshot;
        this.pos = 0;
        while (this.pos < contents.length) {
            if (!StringSupport.contentEquals(contents[this.pos], 46) && !StringSupport.contentEquals(contents[this.pos], 46, 46)) {
                block.yield(context, RubyString.newString(context.runtime, contents[this.pos], enc));
            }
            ++this.pos;
        }
        return this;
    }

    public IRubyObject each_child(ThreadContext context, Block block) {
        return this.each_child(context, this.encoding, block);
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(':');
        if (this.path != null) {
            part.append(this.path.asJavaString());
        }
        part.append('>');
        return runtime2.newString(part.toString());
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell() {
        this.checkDir();
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"seek"}, required=1)
    public IRubyObject seek(IRubyObject newPos) {
        this.checkDir();
        this.set_pos(newPos);
        return this;
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject newPos) {
        int pos2 = RubyNumeric.fix2int(newPos);
        if (pos2 >= 0) {
            this.pos = pos2;
        }
        return newPos;
    }

    @JRubyMethod(name={"path", "to_path"})
    public IRubyObject path(ThreadContext context) {
        return this.path == null ? context.nil : this.path.strDup(context.runtime);
    }

    @JRubyMethod
    public IRubyObject to_path(ThreadContext context) {
        return this.path(context);
    }

    public String getPath() {
        if (this.path == null) {
            return null;
        }
        return this.path.asJavaString();
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read() {
        this.checkDir();
        String[] snapshot = this.snapshot;
        if (this.pos >= snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result2 = RubyString.newString(this.getRuntime(), snapshot[this.pos], this.encoding);
        ++this.pos;
        return result2;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.checkDir();
        this.pos = 0;
        return this;
    }

    @JRubyMethod(name={"empty?"}, meta=true)
    public static IRubyObject empty_p(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, arg2));
        RubyFileStat fileStat = (runtime2 = context.runtime).newFileStat(path2.asJavaString(), false);
        boolean isDirectory = fileStat.directory_p().isTrue();
        return runtime2.newBoolean(isDirectory && RubyDir.entries(context, recv2, arg2).getLength() <= 2);
    }

    @JRubyMethod(name={"exist?"}, meta=true)
    public static IRubyObject exist(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        IRubyObject exception2 = runtime2.getGlobalVariables().get("$!");
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, arg2));
        try {
            return runtime2.newFileStat(path2.asJavaString(), false).directory_p();
        }
        catch (Exception e) {
            runtime2.getGlobalVariables().set("$!", exception2);
            return runtime2.newBoolean(false);
        }
    }

    @JRubyMethod(name={"exists?"}, meta=true)
    public static IRubyObject exists_p(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (context.runtime.warningsEnabled()) {
            context.runtime.getWarnings().warn("Dir.exists? is a deprecated name, use Dir.exist? instead");
        }
        return RubyDir.exist(context, recv2, arg2);
    }

    @JRubyMethod(name={"fileno"}, notImplemented=true)
    public IRubyObject fileno(ThreadContext context) {
        throw context.runtime.newNotImplementedError("Dir#fileno");
    }

    protected static FileResource getDir(Ruby runtime2, String path2, boolean mustExist) {
        String dir = RubyDir.dirFromPath(path2, runtime2);
        FileResource result2 = JRubyFile.createResource(runtime2, dir);
        if (mustExist && (result2 == null || !result2.exists())) {
            throw runtime2.newErrnoENOENTError(dir);
        }
        boolean isDirectory = result2.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime2.newErrnoENOTDIRError(path2);
        }
        if (!mustExist && isDirectory) {
            throw runtime2.newErrnoEEXISTError(dir);
        }
        return result2;
    }

    private static FileResource getExistingDir(Ruby runtime2, String path2) {
        FileResource result2 = JRubyFile.createResource(runtime2, path2);
        if (result2 == null || !result2.exists()) {
            throw runtime2.newErrnoENOENTError(path2);
        }
        if (!result2.isDirectory()) {
            throw runtime2.newErrnoENOTDIRError(path2);
        }
        return result2;
    }

    protected static JRubyFile getDirForRmdir(Ruby runtime2, String path2) {
        String dir = RubyDir.dirFromPath(path2, runtime2);
        JRubyFile directory = JRubyFile.create(runtime2.getCurrentDirectory(), dir);
        File parentFile = directory.getParentFile();
        if (parentFile.exists() && !parentFile.canWrite()) {
            throw runtime2.newErrnoEACCESError(path2);
        }
        FileStat stat2 = runtime2.getPosix().stat(directory.toString());
        if (!stat2.isDirectory()) {
            throw runtime2.newErrnoENOTDIRError(path2);
        }
        return directory;
    }

    private static String dirFromPath(String path2, Ruby runtime2) throws RaiseException {
        String dir = path2;
        String[] pathParts = RubyFile.splitURI(path2);
        if (pathParts != null) {
            if (pathParts[0].startsWith("file:") && pathParts[1].length() > 0 && pathParts[1].indexOf(".jar!/") == -1) {
                dir = pathParts[1];
            } else {
                throw runtime2.newErrnoENOTDIRError(dir);
            }
        }
        return dir;
    }

    private static String[] list(FileResource directory) {
        String[] contents = directory.list();
        return contents == null ? NO_FILES : contents;
    }

    protected static List<String> getContents(FileResource directory) {
        String[] contents = directory.list();
        List<String> result2 = contents != null ? Arrays.asList(contents) : Collections.emptyList();
        return result2;
    }

    protected static List<RubyString> getContents(FileResource directory, Ruby runtime2) {
        List<RubyString> result2;
        String[] contents = directory.list();
        if (contents != null) {
            result2 = new ArrayList<RubyString>(contents.length);
            for (int i2 = 0; i2 < contents.length; ++i2) {
                result2.add(runtime2.newString(contents[i2]));
            }
        } else {
            result2 = Collections.emptyList();
        }
        return result2;
    }

    public static IRubyObject getHomeDirectoryPath(ThreadContext context, String user) {
        Ruby runtime2 = context.runtime;
        try {
            return runtime2.newString(runtime2.getPosix().getpwnam(user).getHome());
        }
        catch (Exception e) {
            String passwd2;
            try {
                FileInputStream stream = new FileInputStream("/etc/passwd");
                int readBytes = stream.available();
                byte[] bytes2 = new byte[readBytes];
                readBytes = stream.read(bytes2);
                stream.close();
                passwd2 = new String(bytes2, 0, readBytes);
            }
            catch (IOException ioe) {
                return runtime2.getNil();
            }
            List<String> rows = StringSupport.split(passwd2, '\n');
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                List<String> fields2 = StringSupport.split(rows.get(i2), ':');
                if (!fields2.get(0).equals(user)) continue;
                return runtime2.newString(fields2.get(5));
            }
            throw runtime2.newArgumentError("user " + user + " doesn't exist");
        }
    }

    public static RubyString getHomeDirectoryPath(ThreadContext context) {
        RubyString homeKey = RubyString.newStringShared(context.runtime, HOME);
        return RubyDir.getHomeDirectoryPath(context, context.runtime.getENV().op_aref(context, homeKey));
    }

    static RubyString getHomeDirectoryPath(ThreadContext context, IRubyObject home2) {
        Ruby runtime2 = context.runtime;
        if (home2 == null || home2 == context.nil) {
            IRubyObject ENV_JAVA = runtime2.getObject().getConstant("ENV_JAVA");
            home2 = ENV_JAVA.callMethod(context, "[]", RubyString.newString(runtime2, user_home, (Encoding)RubyString.UTF8));
        }
        if (home2 == null || home2 == context.nil) {
            home2 = context.runtime.getENV().op_aref(context, runtime2.newString("LOGDIR"));
        }
        if (home2 == null || home2 == context.nil) {
            throw runtime2.newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home2.dup();
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target == File.class) {
            String path2 = this.getPath();
            return (T)(path2 == null ? null : new File(path2));
        }
        if (target == Path.class || target == Watchable.class) {
            String path3 = this.getPath();
            return (T)(path3 == null ? null : FileSystems.getDefault().getPath(path3, new String[0]));
        }
        return super.toJava(target);
    }

    @Deprecated
    public static RubyArray entries19(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyDir.entries(context, recv2, arg2);
    }

    @Deprecated
    public static RubyArray entries19(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        return RubyDir.entries(context, recv2, arg2, opts);
    }

    @Deprecated
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        return RubyDir.foreachCommon(context, recv2, RubyFile.get_path(context, path2), null, block);
    }

    @Deprecated
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject enc, Block block) {
        return RubyDir.foreachCommon(context, recv2, RubyFile.get_path(context, path2), RubyHash.newKwargs(context.runtime, "encoding", enc), block);
    }

    @Deprecated
    public static RubyArray entries(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.entries(recv2.getRuntime().getCurrentContext(), recv2, path2);
    }

    @Deprecated
    public static RubyArray entries(IRubyObject recv2, IRubyObject path2, IRubyObject arg2, IRubyObject opts) {
        return RubyDir.entries(recv2.getRuntime().getCurrentContext(), recv2, path2, opts);
    }
}

