/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReifyClosureInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    public ReifyClosureInstr(Variable result2, Variable source2) {
        super(Operation.REIFY_CLOSURE, result2, source2);
        assert (result2 != null) : "ReceiveClosureInstr result is null";
    }

    public Variable getSource() {
        return (Variable)this.getOperand1();
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.RECEIVES_CLOSURE_ARG);
        return true;
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReifyClosureInstr(info.getRenamedVariable(this.getResult()), info.getRenamedVariable(this.getSource()));
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        return new CopyInstr(ii.getRenamedVariable(this.result), (Operand)ii.getRenamedVariable(this.getSource()));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getSource());
    }

    public static ReifyClosureInstr decode(IRReaderDecoder d) {
        return new ReifyClosureInstr(d.decodeVariable(), d.decodeVariable());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Block block = (Block)this.getSource().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.newProc(context.runtime, block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReifyClosureInstr(this);
    }
}

