/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.posix.util.WindowsHelpers;

public final class WString {
    static final Runtime runtime = Runtime.getSystemRuntime();
    private final byte[] bytes;
    public static final ToNativeConverter<WString, Pointer> Converter = new ToNativeConverter<WString, Pointer>(){

        @Override
        public Pointer toNative(WString value2, ToNativeContext context) {
            if (value2 == null) {
                return null;
            }
            Pointer memory = Memory.allocateDirect(runtime, value2.bytes.length + 1, true);
            memory.put(0L, value2.bytes, 0, value2.bytes.length);
            return memory;
        }

        @Override
        public Class<Pointer> nativeType() {
            return Pointer.class;
        }
    };

    WString(String string2) {
        this.bytes = WindowsHelpers.toWString(string2);
    }

    private WString(byte[] bytes2) {
        this.bytes = bytes2;
    }

    public static WString path(String path2) {
        return WString.path(path2, false);
    }

    public static WString path(String path2, boolean longPathExtensionNeeded) {
        if (longPathExtensionNeeded && path2.length() > 240) {
            if (path2.startsWith("//")) {
                path2 = "//?/UNC/" + path2.substring(2);
            } else if (path2.startsWith("\\\\")) {
                path2 = "\\\\?\\UNC\\" + path2.substring(2);
            } else if (WindowsHelpers.isDriveLetterPath(path2)) {
                path2 = path2.contains("/") ? "//?/" + path2 : "\\\\?\\" + path2;
            }
        }
        return new WString(WindowsHelpers.toWPath(path2));
    }
}

