/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.osgi.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.osgi.internal.BundleWiringOSGiClassLoaderAdapter;
import org.jruby.embed.osgi.internal.IOSGiClassLoaderAdapter;
import org.jruby.embed.osgi.internal.ReflectiveOSGiClassLoaderAdapter;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;

public class JRubyOSGiBundleClassLoader
extends ClassLoader
implements BundleReference {
    private static final Logger LOG = LoggerFactory.getLogger(JRubyOSGiBundleClassLoader.class.getName());
    private static final IOSGiClassLoaderAdapter ADAPTER;
    private boolean _lookInOsgiFirst = true;
    private LinkedHashMap<Bundle, ClassLoader> _libraries = new LinkedHashMap();

    public JRubyOSGiBundleClassLoader() {
        super(ScriptingContainer.class.getClassLoader());
    }

    public JRubyOSGiBundleClassLoader(Bundle creator) {
        this();
        this.addBundle(creator);
    }

    public void addBundle(Class<?> classInOsgiBundle) {
        Bundle b2 = FrameworkUtil.getBundle(classInOsgiBundle);
        if (b2 == null) {
            throw new IllegalArgumentException(classInOsgiBundle + " is not loaded by a bundle. Its classloader is " + classInOsgiBundle.getClassLoader() + " does not implement " + "org.osgi.framework.BundleReference");
        }
        this._libraries.put(b2, classInOsgiBundle.getClassLoader());
    }

    public boolean addBundle(Bundle bundle) {
        return this._libraries.put(bundle, ADAPTER.getClassLoader(bundle)) != null;
    }

    public boolean removeBundle(Bundle bundle) throws IOException {
        return this._libraries.remove(bundle) != null;
    }

    public Bundle getBundle() {
        return this._libraries.keySet().iterator().next();
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        LinkedList<Enumeration<URL>> enums = new LinkedList<Enumeration<URL>>();
        for (ClassLoader cl : this._libraries.values()) {
            enums.add(cl.getResources(name2));
        }
        Enumeration<URL> urls = super.getResources(name2);
        if (this._lookInOsgiFirst) {
            enums.addFirst(urls);
        } else {
            enums.addLast(urls);
        }
        return Collections.enumeration(this.toList(enums));
    }

    @Override
    public URL getResource(String name2) {
        if (this._lookInOsgiFirst) {
            URL url = null;
            for (ClassLoader cl : this._libraries.values()) {
                url = cl.getResource(name2);
                if (url == null) continue;
                return url;
            }
            return super.getResource(name2);
        }
        URL url = super.getResource(name2);
        if (url != null) {
            return url;
        }
        for (ClassLoader cl : this._libraries.values()) {
            url = cl.getResource(name2);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private List<URL> toList(List<Enumeration<URL>> l) {
        LinkedList<URL> list2 = new LinkedList<URL>();
        for (Enumeration<URL> e : l) {
            while (e != null && e.hasMoreElements()) {
                list2.add(e.nextElement());
            }
        }
        return list2;
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        if (this._lookInOsgiFirst) {
            for (ClassLoader cl : this._libraries.values()) {
                try {
                    return cl.loadClass(name2);
                }
                catch (ClassNotFoundException cne) {
                }
            }
            return super.findClass(name2);
        }
        try {
            return super.findClass(name2);
        }
        catch (ClassNotFoundException cne) {
            for (ClassLoader cl : this._libraries.values()) {
                try {
                    return cl.loadClass(name2);
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
            throw cne;
        }
    }

    static {
        IOSGiClassLoaderAdapter chosenAdapter = null;
        try {
            Bundle b2 = FrameworkUtil.getBundle(JRubyOSGiBundleClassLoader.class);
            b2.loadClass("org.osgi.framework.wiring.BundleWiring");
            chosenAdapter = new BundleWiringOSGiClassLoaderAdapter();
        }
        catch (Exception e) {
            LOG.warn("Could not load BundleWiring.  Falling back to reflection.", new Object[0]);
            chosenAdapter = new ReflectiveOSGiClassLoaderAdapter();
        }
        ADAPTER = chosenAdapter;
    }
}

