/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public class Collect
extends Transform {
    private final MethodType source;
    private final int index;
    private final int count;
    private final Class arrayType;

    public Collect(MethodType source2, int index2, Class arrayType) {
        this.source = source2;
        this.index = index2;
        this.count = source2.parameterCount() - index2;
        this.arrayType = arrayType;
    }

    public Collect(MethodType source2, int index2, int count2, Class arrayType) {
        this.source = source2;
        this.index = index2;
        this.count = count2;
        this.arrayType = arrayType;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        if (this.index + this.count == this.source.parameterCount()) {
            return target.asCollector(this.arrayType, this.count);
        }
        int[] movePermute = new int[this.source.parameterCount()];
        int[] moveBackPermute = new int[target.type().parameterCount()];
        for (int i2 = 0; i2 < this.index; ++i2) {
            movePermute[i2] = i2;
            moveBackPermute[i2] = i2;
        }
        int shifted = 0;
        int i3 = this.index;
        while (i3 + this.count < movePermute.length) {
            movePermute[i3] = i3 + this.count;
            ++i3;
            ++shifted;
        }
        i3 = this.index;
        while (i3 + 1 < moveBackPermute.length) {
            moveBackPermute[i3 + 1] = i3;
            ++i3;
        }
        for (i3 = this.index + shifted; i3 < movePermute.length; ++i3) {
            movePermute[i3] = i3 - shifted;
        }
        moveBackPermute[this.index] = moveBackPermute.length - 1;
        return Binder.from(this.source).permute(movePermute).collect(this.source.parameterCount() - this.count, this.arrayType).permute(moveBackPermute).invoke(target);
    }

    @Override
    public MethodType down(MethodType type2) {
        this.assertTypesAreCompatible();
        return type2.dropParameterTypes(this.index, this.index + this.count).insertParameterTypes(this.index, this.arrayType);
    }

    private void assertTypesAreCompatible() {
        Class<?> componentType = this.arrayType.getComponentType();
        for (int i2 = this.index; i2 < this.index + this.count; ++i2) {
            TypeDescriptor.OfField in = this.source.parameterType(i2);
            assert (((Class)in).isAssignableFrom(componentType)) : "incoming type " + ((Class)in).getName() + " not compatible with " + componentType.getName() + "[]";
        }
    }

    @Override
    public String toString() {
        return "collect at " + this.index + " into " + this.arrayType.getName();
    }
}

