/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import java.util.concurrent.Callable;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class HandleMethod
extends DynamicMethod
implements MethodArgs2 {
    private final Callable<MethodHandle[]> targetsGenerator;
    private volatile MethodHandle[] targets;
    private MethodHandle target0;
    private MethodHandle target1;
    private MethodHandle target2;
    private MethodHandle target3;
    private MethodHandle target4;
    private final String parameterDesc;
    private final Signature signature;
    private final boolean builtin;
    private final boolean notImplemented;

    public HandleMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, Callable<MethodHandle[]> targetsGenerator, Signature signature, boolean builtin, boolean notImplemented, String parameterDesc) {
        super(implementationClass, visibility, callConfig);
        this.targetsGenerator = targetsGenerator;
        this.parameterDesc = parameterDesc;
        this.signature = signature;
        this.builtin = builtin;
        this.notImplemented = notImplemented;
    }

    @Override
    public Arity getArity() {
        return this.signature.arity();
    }

    @Override
    public boolean isBuiltin() {
        return this.builtin;
    }

    @Override
    public boolean isNotImplemented() {
        return this.notImplemented;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    private void ensureTargets() {
        if (this.targets != null) {
            return;
        }
        try {
            MethodHandle[] targets = this.targetsGenerator.call();
            this.target0 = targets[0];
            this.target1 = targets[1];
            this.target2 = targets[2];
            this.target3 = targets[3];
            this.target4 = targets[4];
            this.targets = targets;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        this.ensureTargets();
        try {
            return this.target4.invokeExact(context, self2, clazz, name2, args2, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        this.ensureTargets();
        if (this.target0 == null) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        try {
            return this.target0.invokeExact(context, self2, clazz, name2, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        this.ensureTargets();
        if (this.target1 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, block);
        }
        try {
            return this.target1.invokeExact(context, self2, clazz, name2, arg0, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.ensureTargets();
        if (this.target2 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }
        try {
            return this.target2.invokeExact(context, self2, clazz, name2, arg0, arg1, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        this.ensureTargets();
        if (this.target3 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        try {
            return this.target3.invokeExact(context, self2, clazz, name2, arg0, arg1, arg2, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public DynamicMethod dup() {
        return new HandleMethod(this.implementationClass, this.visibility, this.callConfig, this.targetsGenerator, this.signature, this.builtin, this.notImplemented, this.parameterDesc);
    }

    @Override
    public String[] getParameterList() {
        if (this.parameterDesc != null && this.parameterDesc.length() > 0) {
            return this.parameterDesc.split(";");
        }
        return new String[0];
    }

    public MethodHandle getHandle(int arity2) {
        this.ensureTargets();
        return this.targets[arity2];
    }
}

