/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.enxio.channels.NativeSelectableChannel;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.platform.Platform;
import org.jruby.util.io.FilenoUtil;

public class ChannelFD
implements Closeable {
    public Channel ch;
    public ReadableByteChannel chRead;
    public WritableByteChannel chWrite;
    public FileChannel chSeek;
    public SelectableChannel chSelect;
    public FileChannel chFile;
    public SocketChannel chSock;
    public NativeSelectableChannel chNative;
    public int realFileno;
    public int fakeFileno;
    private AtomicInteger refs;
    public FileLock currentLock;
    private POSIX posix;
    public boolean isNativeFile = false;
    private final FilenoUtil filenoUtil;

    public ChannelFD(Channel fd, POSIX posix, FilenoUtil filenoUtil) {
        assert (fd != null);
        this.ch = fd;
        this.posix = posix;
        this.filenoUtil = filenoUtil;
        this.initFileno();
        this.initChannelTypes();
        this.refs = new AtomicInteger(1);
        filenoUtil.registerWrapper(this.realFileno, this);
        filenoUtil.registerWrapper(this.fakeFileno, this);
    }

    private void initFileno() {
        this.realFileno = FilenoUtil.filenoFrom(this.ch);
        this.fakeFileno = this.realFileno == -1 ? this.filenoUtil.getNewFileno() : -1;
    }

    public ChannelFD dup() {
        if (this.realFileno != -1 && !Platform.IS_WINDOWS) {
            return new ChannelFD(new NativeDeviceChannel(this.posix.dup(this.realFileno)), this.posix, this.filenoUtil);
        }
        Channel ch = this.ch;
        ChannelFD fd = new ChannelFD(ch, this.posix, this.filenoUtil);
        fd.refs = this.refs;
        fd.refs.incrementAndGet();
        return fd;
    }

    public int dup2From(POSIX posix, ChannelFD dup2Source) {
        if (dup2Source.realFileno != -1 && this.realFileno != -1 && this.chFile == null) {
            return posix.dup2(dup2Source.realFileno, this.realFileno);
        }
        this.ch = dup2Source.ch;
        this.initFileno();
        this.initChannelTypes();
        this.refs = dup2Source.refs;
        this.refs.incrementAndGet();
        this.currentLock = dup2Source.currentLock;
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.finish(true);
    }

    public int bestFileno() {
        return this.realFileno == -1 ? this.fakeFileno : this.realFileno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean close2) throws IOException {
        AtomicInteger atomicInteger = this.refs;
        synchronized (atomicInteger) {
            int count2;
            if (this.refs.get() <= 0) {
                throw new ClosedChannelException();
            }
            if (!this.ch.isOpen()) {
                throw new ClosedChannelException();
            }
            if (close2 && (count2 = this.refs.decrementAndGet()) <= 0) {
                try {
                    this.ch.close();
                }
                finally {
                    this.filenoUtil.unregisterWrapper(this.realFileno);
                    this.filenoUtil.unregisterWrapper(this.fakeFileno);
                }
            }
        }
    }

    private void initChannelTypes() {
        FileStat stat2;
        assert (this.realFileno != -1 || this.fakeFileno != -1) : "initialize filenos before initChannelTypes";
        this.chRead = this.ch instanceof ReadableByteChannel ? (ReadableByteChannel)this.ch : null;
        this.chWrite = this.ch instanceof WritableByteChannel ? (WritableByteChannel)this.ch : null;
        this.chSeek = this.ch instanceof FileChannel ? (FileChannel)this.ch : null;
        this.chSelect = this.ch instanceof SelectableChannel ? (SelectableChannel)this.ch : null;
        this.chFile = this.ch instanceof FileChannel ? (FileChannel)this.ch : null;
        this.chSock = this.ch instanceof SocketChannel ? (SocketChannel)this.ch : null;
        this.chNative = this.ch instanceof NativeSelectableChannel ? (NativeSelectableChannel)this.ch : null;
        if (this.chNative != null && (stat2 = this.posix.fstat(this.chNative.getFD())).isFile()) {
            this.chSelect = null;
            this.isNativeFile = true;
        }
    }
}

