/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CurrentScope
extends Operand {
    public static final CurrentScope[] CURRENT_SCOPE = new CurrentScope[]{new CurrentScope(0), new CurrentScope(1), new CurrentScope(2), new CurrentScope(3), new CurrentScope(4)};
    private final int scopeNestingDepth;

    public static CurrentScope ScopeFor(int depth) {
        return depth < CURRENT_SCOPE.length ? CURRENT_SCOPE[depth] : new CurrentScope(depth);
    }

    public CurrentScope(int scopeNestingDepth) {
        super(OperandType.CURRENT_SCOPE);
        this.scopeNestingDepth = scopeNestingDepth;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public int getScopeNestingDepth() {
        return this.scopeNestingDepth;
    }

    public int hashCode() {
        return this.scopeNestingDepth;
    }

    public boolean equals(Object other) {
        return other instanceof CurrentScope && this.scopeNestingDepth == ((CurrentScope)other).scopeNestingDepth;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        StaticScope scope = currScope;
        int n = this.scopeNestingDepth;
        while (n > 0) {
            if ((scope = scope.getEnclosingScope()).getScopeType() == null) continue;
            --n;
        }
        return scope;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CurrentScope(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getScopeNestingDepth());
    }

    public static CurrentScope decode(IRReaderDecoder d) {
        return CurrentScope.ScopeFor(d.decodeInt());
    }

    public String toString() {
        return "scope<" + this.scopeNestingDepth + ">";
    }
}

