/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodNodes;
import org.jruby.internal.runtime.methods.ReflectedCompiledMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMultiMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ReflectionMethodFactory
extends MethodFactory {
    private static final Logger LOG = LoggerFactory.getLogger("ReflectionMethodFactory");

    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule implementationClass, String rubyName, String javaName, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc, MethodNodes methodNodes) {
        return this.getCompiledMethod(implementationClass, rubyName, javaName, visibility, scope, scriptObject, callConfig, position, parameterDesc, methodNodes);
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String rubyName, String javaName, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc, MethodNodes methodNodes) {
        try {
            Class<?> scriptClass = scriptObject.getClass();
            Method method = scriptClass.getMethod(javaName, scriptClass, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
            return new ReflectedCompiledMethod(implementationClass, visibility, scope, scriptObject, method, callConfig, position, parameterDesc);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("No method with name " + javaName + " found in " + scriptObject.getClass());
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        try {
            if (!Modifier.isPublic(desc.getDeclaringClass().getModifiers())) {
                LOG.warn("warning: binding non-public class {}; reflected handles won't work", desc.declaringClassName);
            }
            Method method = desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses());
            ReflectedJavaMethod ic = new ReflectedJavaMethod(implementationClass, method, desc.anno);
            TypePopulator.populateMethod(ic, ic.getArity().getValue(), method.getName(), Modifier.isStatic(method.getModifiers()), CallConfiguration.getCallConfigByAnno(desc.anno), desc.anno.notImplemented());
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        try {
            if (!Modifier.isPublic(descs.get(0).getDeclaringClass().getModifiers())) {
                LOG.warn("warning: binding non-public class {}; reflected handles won't work", descs.get((int)0).declaringClassName);
            }
            ArrayList<Method> methods2 = new ArrayList<Method>();
            ArrayList<JRubyMethod> annotations2 = new ArrayList<JRubyMethod>();
            for (JavaMethodDescriptor desc : descs) {
                methods2.add(desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses()));
                annotations2.add(desc.anno);
            }
            Method method0 = (Method)methods2.get(0);
            JRubyMethod anno0 = (JRubyMethod)annotations2.get(0);
            ReflectedJavaMultiMethod ic = new ReflectedJavaMultiMethod(implementationClass, methods2, annotations2);
            TypePopulator.populateMethod(ic, ic.getArity().getValue(), method0.getName(), Modifier.isStatic(method0.getModifiers()), CallConfiguration.getCallConfigByAnno(anno0), anno0.notImplemented());
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

