/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.HashMap;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassListener;
import org.jruby.ir.representations.CFG;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class BasicCompilerPassListener
implements CompilerPassListener {
    private static final Logger LOG = LoggerFactory.getLogger("BasicCompilerPassListener");
    private Map<CompilerPass, Long> times = new HashMap<CompilerPass, Long>();

    @Override
    public void alreadyExecuted(CompilerPass passClass, IRScope scope, Object data2, boolean childScope) {
    }

    @Override
    public void startExecute(CompilerPass pass2, IRScope scope, boolean childScope) {
        this.times.put(pass2, new Long(System.currentTimeMillis()));
        LOG.info("Starting " + pass2.getLabel() + " on scope " + scope, new Object[0]);
    }

    @Override
    public void endExecute(CompilerPass pass2, IRScope scope, Object data2, boolean childScope) {
        Long startTime = this.times.get(pass2);
        long timeTaken = startTime != null ? System.currentTimeMillis() - startTime : -1L;
        CFG c = scope.getCFG();
        if (c != null) {
            LOG.info("\nGraph:\n" + c.toStringGraph(), new Object[0]);
            LOG.info("\nInstructions[" + this.getScopeUUID(scope) + "," + scope.getClass().getSimpleName() + "," + pass2.getClass().getSimpleName() + "]:\n" + c.toStringInstrs() + "\n:Instructions", new Object[0]);
        } else {
            LOG.info("\n  instrs:\n" + scope.toStringInstrs(), new Object[0]);
        }
        if (startTime > 0L) {
            LOG.info("Finished " + pass2.getLabel() + " on scope in " + timeTaken + "ms.", new Object[0]);
        } else {
            LOG.info("Finished " + pass2.getLabel() + " on scope " + scope, new Object[0]);
        }
    }

    private String getScopeUUID(IRScope scope) {
        if (scope instanceof IRScriptBody || scope instanceof IRClosure) {
            return "" + scope.getFileName() + "#" + scope.getLineNumber() + "#";
        }
        return "" + scope.getFileName() + "#" + scope.getLineNumber() + "#" + scope.getName();
    }
}

