/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ScopeModule
extends Operand {
    public static final ScopeModule[] SCOPE_MODULE = new ScopeModule[]{new ScopeModule(0), new ScopeModule(1), new ScopeModule(2), new ScopeModule(3), new ScopeModule(4)};
    private final int scopeModuleDepth;

    public static ScopeModule ModuleFor(int depth) {
        return depth < SCOPE_MODULE.length ? SCOPE_MODULE[depth] : new ScopeModule(depth);
    }

    public ScopeModule(int scopeModuleDepth) {
        super(OperandType.SCOPE_MODULE);
        this.scopeModuleDepth = scopeModuleDepth;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    public int hashCode() {
        return this.scopeModuleDepth;
    }

    public int getScopeModuleDepth() {
        return this.scopeModuleDepth;
    }

    public boolean equals(Object other) {
        return other instanceof ScopeModule && this.scopeModuleDepth == ((ScopeModule)other).scopeModuleDepth;
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public String toString() {
        return "module<" + this.scopeModuleDepth + ">";
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return Helpers.getNthScopeModule(currScope, this.scopeModuleDepth);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getScopeModuleDepth());
    }

    public static ScopeModule decode(IRReaderDecoder d) {
        return ScopeModule.ModuleFor(d.decodeInt());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ScopeModule(this);
    }
}

