/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SetCapturedVarInstr
extends ResultBaseInstr
implements FixedArityInstr {
    private final String varName;

    public SetCapturedVarInstr(Variable result2, Operand match2Result, String varName) {
        super(Operation.SET_CAPTURED_VAR, result2, new Operand[]{match2Result});
        assert (result2 != null) : "SetCapturedVarInstr result is null";
        this.varName = varName;
    }

    public Operand getMatch2Result() {
        return this.operands[0];
    }

    public String getVarName() {
        return this.varName;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.varName};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new SetCapturedVarInstr(ii.getRenamedVariable(this.result), this.getMatch2Result().cloneForInlining(ii), this.varName);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getMatch2Result());
        e.encode(this.getVarName());
    }

    public static SetCapturedVarInstr decode(IRReaderDecoder d) {
        return new SetCapturedVarInstr(d.decodeVariable(), d.decodeOperand(), d.decodeString());
    }

    @Override
    @Interp
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject matchRes = (IRubyObject)this.getMatch2Result().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.setCapturedVar(context, matchRes, this.varName);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SetCapturedVarInstr(this);
    }
}

