/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryObject;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.MemoryUtil;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.TypeSizeMapper;
import org.jruby.ext.ffi.Util;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"FFI::AbtractMemoryAbstractMemory"}, parent="Object")
public abstract class AbstractMemory
extends MemoryObject {
    public static final String ABSTRACT_MEMORY_RUBY_CLASS = "AbstractMemory";
    protected long size;
    protected int typeSize;

    public static RubyClass createAbstractMemoryClass(Ruby runtime, RubyModule module) {
        RubyClass result2 = module.defineClassUnder(ABSTRACT_MEMORY_RUBY_CLASS, runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result2.defineAnnotatedMethods(AbstractMemory.class);
        result2.defineAnnotatedConstants(AbstractMemory.class);
        return result2;
    }

    protected static final int calculateTypeSize(ThreadContext context, IRubyObject sizeArg) {
        if (sizeArg instanceof RubyFixnum) {
            return (int)((RubyFixnum)sizeArg).getLongValue();
        }
        if (sizeArg instanceof RubySymbol) {
            return TypeSizeMapper.getTypeSize(context, (RubySymbol)sizeArg);
        }
        if (sizeArg instanceof Type) {
            return ((Type)sizeArg).getNativeSize();
        }
        if (sizeArg instanceof RubyClass && Struct.isStruct(context.runtime, (RubyClass)sizeArg)) {
            return Struct.getStructSize(context.runtime, sizeArg);
        }
        DynamicMethod sizeMethod = sizeArg.getMetaClass().searchMethod("size");
        if (!sizeMethod.isUndefined()) {
            return (int)RubyFixnum.num2long(sizeMethod.call(context, sizeArg, sizeArg.getMetaClass(), "size"));
        }
        throw context.runtime.newArgumentError("Invalid size argument");
    }

    protected static final RubyArray checkArray(IRubyObject obj) {
        if (!(obj instanceof RubyArray)) {
            throw obj.getRuntime().newArgumentError("Array expected");
        }
        return (RubyArray)obj;
    }

    private static int checkArrayLength(IRubyObject val) {
        int i2 = RubyNumeric.num2int(val);
        if (i2 < 0) {
            throw val.getRuntime().newArgumentError("negative array length");
        }
        return i2;
    }

    protected AbstractMemory(Ruby runtime, RubyClass klass, MemoryIO io2, long size2) {
        this(runtime, klass, io2, size2, 1);
    }

    protected AbstractMemory(Ruby runtime, RubyClass klass, MemoryIO io2, long size2, int typeSize) {
        super(runtime, klass);
        this.setMemoryIO(io2);
        this.size = size2;
        this.typeSize = typeSize;
    }

    @Override
    protected MemoryIO allocateMemoryIO() {
        throw this.getRuntime().newRuntimeError("allocateMemoryIO should not be called");
    }

    protected final long getOffset(IRubyObject offset2) {
        return Util.longValue(offset2);
    }

    public final long getSize() {
        return this.size;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        return RubyString.newString(context.runtime, "AbstractMemory[size=" + this.size + "]");
    }

    @JRubyMethod(name={"[]"})
    public final IRubyObject aref(ThreadContext context, IRubyObject indexArg) {
        int index2 = RubyNumeric.num2int(indexArg);
        int offset2 = index2 * this.typeSize;
        if ((long)offset2 >= this.size) {
            throw context.runtime.newIndexError(String.format("Index %d out of range", index2));
        }
        return this.slice(context.runtime, offset2);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractMemory)) {
            return false;
        }
        AbstractMemory other = (AbstractMemory)obj;
        return other.getMemoryIO().equals(this.getMemoryIO());
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(this.equals(obj));
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return this.equals(other);
    }

    @Override
    public int hashCode() {
        return 67 * this.getMemoryIO().hashCode();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        this.getMemoryIO().setMemory(0L, this.size, (byte)0);
        return this;
    }

    @JRubyMethod(name={"total", "size", "length"})
    public IRubyObject total(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.size);
    }

    @JRubyMethod(name={"type_size"})
    public final IRubyObject type_size(ThreadContext context) {
        return context.runtime.newFixnum(this.typeSize);
    }

    @JRubyMethod(name={"write_char"}, required=1)
    public IRubyObject write_char(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, Util.int8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int8", "put_char"}, required=1)
    public IRubyObject put_int8(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, Util.int8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int8", "put_char"}, required=2)
    public IRubyObject put_int8(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putByte(this.getOffset(offset2), Util.int8Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_char"})
    public IRubyObject read_char(ThreadContext context) {
        return Util.newSigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_int8", "get_char"})
    public IRubyObject get_int8(ThreadContext context) {
        return Util.newSigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_int8", "get_char"}, required=1)
    public IRubyObject get_int8(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned8(context.runtime, this.getMemoryIO().getByte(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_uchar"}, required=1)
    public IRubyObject write_uchar(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, (byte)Util.uint8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint8", "put_uchar"}, required=1)
    public IRubyObject put_uint8(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, (byte)Util.uint8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint8", "put_uchar"}, required=2)
    public IRubyObject put_uint8(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putByte(this.getOffset(offset2), (byte)Util.uint8Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_uchar"})
    public IRubyObject read_uchar(ThreadContext context) {
        return Util.newUnsigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_uint8", "get_uchar"})
    public IRubyObject get_uint8(ThreadContext context) {
        return Util.newUnsigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_uint8", "get_uchar"}, required=1)
    public IRubyObject get_uint8(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned8(context.runtime, this.getMemoryIO().getByte(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_short"}, required=1)
    public IRubyObject write_short(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, Util.int16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int16", "put_short"}, required=1)
    public IRubyObject put_int16(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, Util.int16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int16", "put_short"}, required=2)
    public IRubyObject put_int16(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putShort(this.getOffset(offset2), Util.int16Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_short"})
    public IRubyObject read_short(ThreadContext context) {
        return Util.newSigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_int16", "get_short"})
    public IRubyObject get_int16(ThreadContext context) {
        return Util.newSigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_int16", "get_short"}, required=1)
    public IRubyObject get_int16(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned16(context.runtime, this.getMemoryIO().getShort(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_ushort"}, required=1)
    public IRubyObject write_ushort(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, (short)Util.uint16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint16", "put_ushort"}, required=1)
    public IRubyObject put_uint16(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, (short)Util.uint16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint16", "put_ushort"}, required=2)
    public IRubyObject put_uint16(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putShort(this.getOffset(offset2), (short)Util.uint16Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_ushort"})
    public IRubyObject read_ushort(ThreadContext context) {
        return Util.newUnsigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_uint16", "get_ushort"})
    public IRubyObject get_uint16(ThreadContext context) {
        return Util.newUnsigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_uint16", "get_ushort"}, required=1)
    public IRubyObject get_uint16(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned16(context.runtime, this.getMemoryIO().getShort(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_int"})
    public IRubyObject write_int(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, Util.int32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int32", "put_int"})
    public IRubyObject put_int32(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, Util.int32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int32", "put_int"}, required=2)
    public IRubyObject put_int32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putInt(this.getOffset(offset2), Util.int32Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_int"})
    public IRubyObject read_int(ThreadContext context) {
        return Util.newSigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_int32", "get_int"})
    public IRubyObject get_int32(ThreadContext context) {
        return Util.newSigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_int32", "get_int"}, required=1)
    public IRubyObject get_int32(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned32(context.runtime, this.getMemoryIO().getInt(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_uint"}, required=1)
    public IRubyObject write_uint(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, (int)Util.uint32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint32", "put_uint"}, required=1)
    public IRubyObject put_uint32(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, (int)Util.uint32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint32", "put_uint"}, required=2)
    public IRubyObject put_uint32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putInt(this.getOffset(offset2), (int)Util.uint32Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_uint"})
    public IRubyObject read_uint(ThreadContext context) {
        return Util.newUnsigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_uint32", "get_uint"})
    public IRubyObject get_uint32(ThreadContext context) {
        return Util.newUnsigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_uint32", "get_uint"}, required=1)
    public IRubyObject get_uint32(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned32(context.runtime, this.getMemoryIO().getInt(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_long_long"}, required=1)
    public IRubyObject write_long_long(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.int64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int64", "put_long_long"}, required=1)
    public IRubyObject put_int64(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.int64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int64", "put_long_long"}, required=2)
    public IRubyObject put_int64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putLong(this.getOffset(offset2), Util.int64Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_long_long"})
    public IRubyObject read_long_long(ThreadContext context) {
        return Util.newSigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_int64", "get_long_long"})
    public IRubyObject get_int64(ThreadContext context) {
        return Util.newSigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_int64", "get_long_long"}, required=1)
    public IRubyObject get_int64(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned64(context.runtime, this.getMemoryIO().getLong(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_ulong_long"}, required=1)
    public IRubyObject write_ulong_long(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.uint64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint64", "put_ulong_long"}, required=1)
    public IRubyObject put_uint64(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.uint64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint64", "put_ulong_long"}, required=2)
    public IRubyObject put_uint64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putLong(this.getOffset(offset2), Util.uint64Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_ulong_long"})
    public IRubyObject read_ulong_long(ThreadContext context) {
        return Util.newUnsigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_uint64", "get_ulong_long"})
    public IRubyObject get_uint64(ThreadContext context) {
        return Util.newUnsigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_uint64", "get_ulong_long"}, required=1)
    public IRubyObject get_uint64(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned64(context.runtime, this.getMemoryIO().getLong(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_long"}, required=1)
    public IRubyObject write_long(ThreadContext context, IRubyObject value2) {
        return this.put_long(context, value2);
    }

    @JRubyMethod(name={"put_long"}, required=1)
    public IRubyObject put_long(ThreadContext context, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_int32(context, value2) : this.put_int64(context, value2);
    }

    @JRubyMethod(name={"put_long"}, required=2)
    public IRubyObject put_long(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_int32(context, offset2, value2) : this.put_int64(context, offset2, value2);
    }

    @JRubyMethod(name={"read_long"})
    public IRubyObject read_long(ThreadContext context) {
        return this.get_long(context);
    }

    @JRubyMethod(name={"get_long"})
    public IRubyObject get_long(ThreadContext context) {
        return Platform.getPlatform().longSize() == 32 ? this.get_int32(context) : this.get_int64(context);
    }

    @JRubyMethod(name={"get_long"}, required=1)
    public IRubyObject get_long(ThreadContext context, IRubyObject offset2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_int32(context, offset2) : this.get_int64(context, offset2);
    }

    @JRubyMethod(name={"put_ulong", "write_ulong"}, required=1)
    public IRubyObject put_ulong(ThreadContext context, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_uint32(context, value2) : this.put_uint64(context, value2);
    }

    @JRubyMethod(name={"put_ulong"}, required=2)
    public IRubyObject put_ulong(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_uint32(context, offset2, value2) : this.put_uint64(context, offset2, value2);
    }

    @JRubyMethod(name={"read_ulong"})
    public IRubyObject read_ulong(ThreadContext context) {
        return this.get_ulong(context);
    }

    @JRubyMethod(name={"get_ulong", "read_ulong"})
    public IRubyObject get_ulong(ThreadContext context) {
        return Platform.getPlatform().longSize() == 32 ? this.get_uint32(context) : this.get_uint64(context);
    }

    @JRubyMethod(name={"get_ulong"}, required=1)
    public IRubyObject get_ulong(ThreadContext context, IRubyObject offset2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_uint32(context, offset2) : this.get_uint64(context, offset2);
    }

    @JRubyMethod(name={"write_float"}, required=1)
    public IRubyObject write_float(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putFloat(0L, Util.floatValue(value2));
        return this;
    }

    @JRubyMethod(name={"put_float32", "put_float"}, required=1)
    public IRubyObject put_float32(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putFloat(0L, Util.floatValue(value2));
        return this;
    }

    @JRubyMethod(name={"put_float32", "put_float"}, required=2)
    public IRubyObject put_float32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putFloat(this.getOffset(offset2), Util.floatValue(value2));
        return this;
    }

    @JRubyMethod(name={"read_float"})
    public IRubyObject read_float(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getFloat(0L));
    }

    @JRubyMethod(name={"get_float32", "get_float"})
    public IRubyObject get_float32(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getFloat(0L));
    }

    @JRubyMethod(name={"get_float32", "get_float"}, required=1)
    public IRubyObject get_float32(ThreadContext context, IRubyObject offset2) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getFloat(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_double"}, required=1)
    public IRubyObject write_double(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putDouble(0L, Util.doubleValue(value2));
        return this;
    }

    @JRubyMethod(name={"put_float64", "put_double"}, required=1)
    public IRubyObject put_float64(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putDouble(0L, Util.doubleValue(value2));
        return this;
    }

    @JRubyMethod(name={"put_float64", "put_double"}, required=2)
    public IRubyObject put_float64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putDouble(this.getOffset(offset2), Util.doubleValue(value2));
        return this;
    }

    @JRubyMethod(name={"read_double"})
    public IRubyObject read_double(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getDouble(0L));
    }

    @JRubyMethod(name={"get_float64", "get_double"})
    public IRubyObject get_float64(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getDouble(0L));
    }

    @JRubyMethod(name={"get_float64", "get_double"}, required=1)
    public IRubyObject get_float64(ThreadContext context, IRubyObject offset2) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getDouble(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"get_array_of_int8", "get_array_of_char"}, required=2)
    public IRubyObject get_array_of_int8(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned8(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int8", "put_array_of_char"}, required=2)
    public IRubyObject put_array_of_int8(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned8(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint8", "get_array_of_uchar"}, required=2)
    public IRubyObject get_array_of_uint8(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned8(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint8", "put_array_of_uchar"}, required=2)
    public IRubyObject put_array_of_uint8(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned8(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_int16", "get_array_of_short"}, required=2)
    public IRubyObject get_array_of_int16(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned16(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int16", "put_array_of_short"}, required=2)
    public IRubyObject put_array_of_int16(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned16(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint16", "get_array_of_ushort"}, required=2)
    public IRubyObject get_array_of_uint16(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned16(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint16", "put_array_of_ushort"}, required=2)
    public IRubyObject put_array_of_uint16(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned16(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_int32", "get_array_of_int"}, required=2)
    public IRubyObject get_array_of_int32(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned32(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int32", "put_array_of_int"}, required=2)
    public IRubyObject put_array_of_int32(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned32(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint32", "get_array_of_uint"}, required=2)
    public IRubyObject get_array_of_uint32(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned32(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint32", "put_array_of_uint"}, required=2)
    public IRubyObject put_array_of_uint32(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned32(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_long"}, required=2)
    public IRubyObject get_array_of_long(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_array_of_int32(context, offset2, length2) : this.get_array_of_int64(context, offset2, length2);
    }

    @JRubyMethod(name={"put_array_of_long"}, required=2)
    public IRubyObject put_array_of_long(ThreadContext context, IRubyObject offset2, IRubyObject arr) {
        return Platform.getPlatform().longSize() == 32 ? this.put_array_of_int32(context, offset2, arr) : this.put_array_of_int64(context, offset2, arr);
    }

    @JRubyMethod(name={"get_array_of_ulong"}, required=2)
    public IRubyObject get_array_of_ulong(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_array_of_uint32(context, offset2, length2) : this.get_array_of_uint64(context, offset2, length2);
    }

    @JRubyMethod(name={"put_array_of_ulong"}, required=2)
    public IRubyObject put_array_of_ulong(ThreadContext context, IRubyObject offset2, IRubyObject arr) {
        return Platform.getPlatform().longSize() == 32 ? this.put_array_of_uint32(context, offset2, arr) : this.put_array_of_uint64(context, offset2, arr);
    }

    @JRubyMethod(name={"get_array_of_int64", "get_array_of_long_long"}, required=2)
    public IRubyObject get_array_of_int64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned64(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int64", "put_array_of_long_long"}, required=2)
    public IRubyObject put_array_of_int64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned64(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint64", "get_array_of_ulong_long"}, required=2)
    public IRubyObject get_array_of_uint64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned64(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint64", "put_array_of_ulong_long"}, required=2)
    public IRubyObject put_array_of_uint64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned64(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_float32", "get_array_of_float"}, required=2)
    public IRubyObject get_array_of_float(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat32(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_float32", "put_array_of_float"}, required=2)
    public IRubyObject put_array_of_float(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfFloat32(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_float64", "get_array_of_double"}, required=2)
    public IRubyObject get_array_of_float64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat64(context.runtime, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_float64", "put_array_of_double"}, required=2)
    public IRubyObject put_array_of_float64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfFloat64(context.runtime, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int8", "read_array_of_char"}, required=1)
    public IRubyObject read_array_of_int8(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned8(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int8", "write_array_of_char"}, required=1)
    public IRubyObject write_array_of_int8(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned8(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint8", "read_array_of_uchar"}, required=1)
    public IRubyObject read_array_of_uint8(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned8(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint8", "write_array_of_uchar"}, required=1)
    public IRubyObject write_array_of_uint8(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned8(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int16", "read_array_of_short"}, required=1)
    public IRubyObject read_array_of_int16(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned16(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int16", "write_array_of_short"}, required=1)
    public IRubyObject write_array_of_int16(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned16(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint16", "read_array_of_ushort"}, required=1)
    public IRubyObject read_array_of_uint16(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned16(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint16", "write_array_of_ushort"}, required=1)
    public IRubyObject write_array_of_uint16(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned16(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int32", "read_array_of_int"}, required=1)
    public IRubyObject read_array_of_int32(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned32(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int32", "write_array_of_int"}, required=1)
    public IRubyObject write_array_of_int32(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned32(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint32", "read_array_of_uint"}, required=1)
    public IRubyObject read_array_of_uint32(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned32(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint32", "write_array_of_uint"}, required=1)
    public IRubyObject write_array_of_uint32(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned32(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int64", "read_array_of_long_long"}, required=1)
    public IRubyObject read_array_of_int64(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned64(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int64", "write_array_of_long_long"}, required=1)
    public IRubyObject write_array_of_int64(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned64(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint64", "read_array_of_ulong_long"}, required=1)
    public IRubyObject read_array_of_uint64(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned64(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint64", "write_array_of_ulong_long"}, required=1)
    public IRubyObject write_array_of_uint64(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned64(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_long"}, required=1)
    public IRubyObject read_array_of_long(ThreadContext context, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.read_array_of_int32(context, length2) : this.read_array_of_int64(context, length2);
    }

    @JRubyMethod(name={"write_array_of_long"}, required=1)
    public IRubyObject write_array_of_long(ThreadContext context, IRubyObject ary) {
        return Platform.getPlatform().longSize() == 32 ? this.write_array_of_int32(context, ary) : this.write_array_of_int64(context, ary);
    }

    @JRubyMethod(name={"read_array_of_ulong"}, required=1)
    public IRubyObject read_array_of_ulong(ThreadContext context, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.read_array_of_uint32(context, length2) : this.read_array_of_uint64(context, length2);
    }

    @JRubyMethod(name={"write_array_of_ulong"}, required=1)
    public IRubyObject write_array_of_ulong(ThreadContext context, IRubyObject ary) {
        return Platform.getPlatform().longSize() == 32 ? this.write_array_of_uint32(context, ary) : this.write_array_of_uint64(context, ary);
    }

    @JRubyMethod(name={"read_array_of_float32", "read_array_of_float"}, required=1)
    public IRubyObject read_array_of_float(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat32(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_float32", "write_array_of_float"}, required=1)
    public IRubyObject write_array_of_float(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfFloat32(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_float64", "read_array_of_double"}, required=1)
    public IRubyObject read_array_of_float64(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat64(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_float64", "write_array_of_double"}, required=1)
    public IRubyObject write_array_of_float64(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfFloat64(context.runtime, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_type"}, required=2)
    public IRubyObject read_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject lenArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        MemoryOp op = MemoryOp.getMemoryOp(type2);
        if (op == null) {
            throw context.runtime.newTypeError("cannot get memory reader for type " + type2);
        }
        int len = AbstractMemory.checkArrayLength(lenArg);
        RubyArray arr = RubyArray.newArray(context.runtime, len);
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            arr.add(op.get(context, this.getMemoryIO(), (long)off));
            ++i2;
            off += type2.size;
        }
        return arr;
    }

    @JRubyMethod(name={"read_array_of_type"}, required=3)
    public IRubyObject read_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject reader, IRubyObject lenArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        DynamicMethod method = this.getMetaClass().searchMethod(reader.asJavaString());
        int len = AbstractMemory.checkArrayLength(lenArg);
        RubyArray arr = RubyArray.newArray(context.runtime, len);
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            arr.add(method.call(context, this.slice(context.runtime, off, type2.size), this.getMetaClass(), reader.asJavaString()));
            ++i2;
            off += type2.size;
        }
        return arr;
    }

    @JRubyMethod(name={"write_array_of_type"}, required=2)
    public IRubyObject write_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject aryArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        MemoryOp op = MemoryOp.getMemoryOp(type2);
        if (op == null) {
            throw context.runtime.newTypeError("cannot get memory writer for type " + type2);
        }
        RubyArray arr = aryArg.convertToArray();
        int len = arr.size();
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            op.put(context, this.getMemoryIO(), (long)off, arr.entry(i2));
            ++i2;
            off += type2.size;
        }
        return this;
    }

    @JRubyMethod(name={"write_array_of_type"}, required=3)
    public IRubyObject write_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject writer, IRubyObject aryArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        DynamicMethod method = this.getMetaClass().searchMethod(writer.asJavaString());
        RubyArray arr = aryArg.convertToArray();
        int len = arr.size();
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            method.call(context, (IRubyObject)this.slice(context.runtime, off, type2.size), (RubyModule)this.getMetaClass(), writer.asJavaString(), arr.entry(i2));
            ++i2;
            off += type2.size;
        }
        return this;
    }

    @JRubyMethod(name={"read_string"})
    public IRubyObject read_string(ThreadContext context) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), 0L);
    }

    @JRubyMethod(name={"read_string"})
    public IRubyObject read_string(ThreadContext context, IRubyObject rbLength) {
        return !rbLength.isNil() ? MemoryUtil.getTaintedByteString(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(rbLength)) : MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), 0L);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), 0L);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context, IRubyObject offArg) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), this.getOffset(offArg));
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context, IRubyObject offArg, IRubyObject lenArg) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), this.getOffset(offArg), Util.int32Value(lenArg));
    }

    @JRubyMethod(name={"get_array_of_string"}, required=1)
    public IRubyObject get_array_of_string(ThreadContext context, IRubyObject rbOffset) {
        MemoryIO mem;
        int POINTER_SIZE = Platform.getPlatform().addressSize() / 8;
        Ruby runtime = context.runtime;
        RubyArray arr = RubyArray.newArray(runtime);
        for (long off = this.getOffset(rbOffset); off <= this.size - (long)POINTER_SIZE && (mem = this.getMemoryIO().getMemoryIO(off)) != null && !mem.isNull(); off += (long)POINTER_SIZE) {
            arr.add(MemoryUtil.getTaintedString(runtime, mem, 0L));
        }
        return arr;
    }

    @JRubyMethod(name={"get_array_of_string"}, required=2)
    public IRubyObject get_array_of_string(ThreadContext context, IRubyObject rbOffset, IRubyObject rbCount) {
        int POINTER_SIZE = Platform.getPlatform().addressSize() / 8;
        long off = this.getOffset(rbOffset);
        int count2 = Util.int32Value(rbCount);
        Ruby runtime = context.runtime;
        RubyArray arr = RubyArray.newArray(runtime, count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            MemoryIO mem = this.getMemoryIO().getMemoryIO(off + (long)(i2 * POINTER_SIZE));
            arr.add(mem != null && !mem.isNull() ? MemoryUtil.getTaintedString(runtime, mem, 0L) : runtime.getNil());
        }
        return arr;
    }

    @JRubyMethod(name={"read_array_of_string"})
    public IRubyObject read_array_of_string(ThreadContext context) {
        return this.get_array_of_string(context, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"read_array_of_string"}, required=1)
    public IRubyObject read_array_of_string(ThreadContext context, IRubyObject rbLength) {
        return this.get_array_of_string(context, RubyFixnum.zero(context.runtime), rbLength);
    }

    @JRubyMethod(name={"put_string"})
    public IRubyObject put_string(ThreadContext context, IRubyObject offArg, IRubyObject strArg) {
        long off = this.getOffset(offArg);
        ByteList bl = strArg.convertToString().getByteList();
        this.getMemoryIO().putZeroTerminatedByteArray(off, bl.getUnsafeBytes(), bl.begin(), bl.length());
        return this;
    }

    @JRubyMethod(name={"write_string"})
    public IRubyObject write_string(ThreadContext context, IRubyObject strArg) {
        ByteList bl = strArg.convertToString().getByteList();
        this.getMemoryIO().put(0L, bl.getUnsafeBytes(), bl.begin(), bl.length());
        return this;
    }

    @JRubyMethod(name={"write_string"})
    public IRubyObject write_string(ThreadContext context, IRubyObject strArg, IRubyObject lenArg) {
        ByteList bl = strArg.convertToString().getByteList();
        this.getMemoryIO().put(0L, bl.getUnsafeBytes(), bl.begin(), Math.min(bl.length(), (int)RubyInteger.num2long(lenArg)));
        return this;
    }

    @JRubyMethod(name={"get_bytes"})
    public IRubyObject get_bytes(ThreadContext context, IRubyObject offArg, IRubyObject lenArg) {
        return MemoryUtil.getTaintedByteString(context.runtime, this.getMemoryIO(), this.getOffset(offArg), Util.int32Value(lenArg));
    }

    private IRubyObject putBytes(ThreadContext context, long off, ByteList bl, int idx, int len) {
        if (idx < 0 || idx > bl.length()) {
            throw context.runtime.newRangeError("invalid string index");
        }
        if (len < 0 || len > bl.length() - idx) {
            throw context.runtime.newRangeError("invalid length");
        }
        this.getMemoryIO().put(off, bl.getUnsafeBytes(), bl.begin() + idx, len);
        return this;
    }

    @JRubyMethod(name={"put_bytes"}, required=2, optional=2)
    public IRubyObject put_bytes(ThreadContext context, IRubyObject[] args2) {
        ByteList bl = args2[1].convertToString().getByteList();
        int idx = args2.length > 2 ? Util.int32Value(args2[2]) : 0;
        int len = args2.length > 3 ? Util.int32Value(args2[3]) : bl.length() - idx;
        return this.putBytes(context, this.getOffset(args2[0]), bl, idx, len);
    }

    @JRubyMethod(name={"read_bytes"})
    public IRubyObject read_bytes(ThreadContext context, IRubyObject lenArg) {
        return MemoryUtil.getTaintedByteString(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(lenArg));
    }

    @JRubyMethod(name={"write_bytes"}, required=1, optional=2)
    public IRubyObject write_bytes(ThreadContext context, IRubyObject[] args2) {
        ByteList bl = args2[0].convertToString().getByteList();
        int idx = args2.length > 1 ? Util.int32Value(args2[1]) : 0;
        int len = args2.length > 2 ? Util.int32Value(args2[2]) : bl.length() - idx;
        return this.putBytes(context, 0L, bl, idx, len);
    }

    @JRubyMethod(name={"read_pointer"})
    public IRubyObject read_pointer(ThreadContext context) {
        return this.getPointer(context.runtime, 0L);
    }

    @JRubyMethod(name={"get_pointer"})
    public IRubyObject get_pointer(ThreadContext context) {
        return this.getPointer(context.runtime, 0L);
    }

    @JRubyMethod(name={"get_pointer"}, required=1)
    public IRubyObject get_pointer(ThreadContext context, IRubyObject offset2) {
        return this.getPointer(context.runtime, this.getOffset(offset2));
    }

    private void putPointer(ThreadContext context, long offset2, IRubyObject value2) {
        if (value2 instanceof Pointer) {
            this.putPointer(context, offset2, (Pointer)value2);
        } else if (value2.isNil()) {
            this.getMemoryIO().putAddress(offset2, 0L);
        } else {
            DynamicMethod conversionMethod = value2.getMetaClass().searchMethod("to_ptr");
            if (!conversionMethod.isUndefined()) {
                this.putPointer(context, offset2, conversionMethod.call(context, value2, value2.getMetaClass(), "to_ptr"));
            } else {
                throw context.runtime.newTypeError(value2, context.runtime.getFFI().pointerClass);
            }
        }
    }

    private void putPointer(ThreadContext context, long offset2, Pointer value2) {
        MemoryIO ptr = value2.getMemoryIO();
        if (ptr.isDirect()) {
            this.getMemoryIO().putMemoryIO(offset2, ptr);
        } else if (ptr.isNull()) {
            this.getMemoryIO().putAddress(offset2, 0L);
        } else {
            throw context.runtime.newArgumentError("Cannot convert argument to pointer");
        }
    }

    @JRubyMethod(name={"write_pointer"})
    public IRubyObject write_pointer(ThreadContext context, IRubyObject value2) {
        this.putPointer(context, 0L, value2);
        return this;
    }

    @JRubyMethod(name={"put_pointer"}, required=1)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject value2) {
        this.putPointer(context, 0L, value2);
        return this;
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.putPointer(context, this.getOffset(offset2), value2);
        return this;
    }

    @JRubyMethod(name={"get_array_of_pointer"}, required=2)
    public IRubyObject get_array_of_pointer(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int POINTER_SIZE = Platform.getPlatform().addressSize / 8;
        int count2 = Util.int32Value(length2);
        Ruby runtime = context.runtime;
        RubyArray arr = RubyArray.newArray(runtime, count2);
        long off = this.getOffset(offset2);
        for (int i2 = 0; i2 < count2; ++i2) {
            arr.add(this.getPointer(runtime, off + (long)(i2 * POINTER_SIZE)));
        }
        return arr;
    }

    @JRubyMethod(name={"put_array_of_pointer"}, required=2)
    public IRubyObject put_array_of_pointer(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        int POINTER_SIZE = Platform.getPlatform().addressSize / 8;
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        long off = this.getOffset(offset2);
        for (int i2 = 0; i2 < count2; ++i2) {
            this.putPointer(context, off + (long)(i2 * POINTER_SIZE), arr.entry(i2));
        }
        return this;
    }

    @JRubyMethod(name={"read_array_of_pointer"}, required=1)
    public IRubyObject read_array_of_pointer(ThreadContext context, IRubyObject length2) {
        return this.get_array_of_pointer(context, RubyFixnum.zero(context.runtime), length2);
    }

    @JRubyMethod(name={"write_array_of_pointer"}, required=1)
    public IRubyObject write_array_of_pointer(ThreadContext context, IRubyObject arrParam) {
        return this.put_array_of_pointer(context, RubyFixnum.zero(context.runtime), arrParam);
    }

    @JRubyMethod(name={"put_callback"}, required=3)
    public IRubyObject put_callback(ThreadContext context, IRubyObject offset2, IRubyObject proc, IRubyObject cbInfo) {
        if (!(cbInfo instanceof CallbackInfo)) {
            throw context.runtime.newArgumentError("invalid CallbackInfo");
        }
        Pointer ptr = Factory.getInstance().getCallbackManager().getCallback(context.runtime, (CallbackInfo)cbInfo, proc);
        this.getMemoryIO().putMemoryIO(this.getOffset(offset2), ptr.getMemoryIO());
        return this;
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject value2) {
        return this.slice(context.runtime, RubyNumeric.fix2long(value2));
    }

    @JRubyMethod(name={"order"}, required=0)
    public final IRubyObject order(ThreadContext context) {
        return context.runtime.newSymbol(this.getMemoryIO().order().equals(ByteOrder.LITTLE_ENDIAN) ? "little" : "big");
    }

    @JRubyMethod(name={"order"}, required=1)
    public final IRubyObject order(ThreadContext context, IRubyObject byte_order) {
        return this.order(context.runtime, Util.parseByteOrder(context.runtime, byte_order));
    }

    @JRubyMethod(name={"to_ptr"})
    public final IRubyObject to_ptr(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"slice"})
    public final IRubyObject slice(ThreadContext context, IRubyObject offset2, IRubyObject size2) {
        return this.slice(context.getRuntime(), RubyNumeric.num2int(offset2), RubyNumeric.num2int(size2));
    }

    public abstract AbstractMemory order(Ruby var1, ByteOrder var2);

    protected abstract AbstractMemory slice(Ruby var1, long var2);

    protected abstract AbstractMemory slice(Ruby var1, long var2, long var4);

    protected abstract Pointer getPointer(Ruby var1, long var2);
}

