/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.MethodBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements DataType {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private ISourcePosition sourcePosition;

    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2) {
        super(runtime, rubyClass);
        this.type = type2;
    }

    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2, ISourcePosition sourcePosition) {
        this(runtime, rubyClass, type2);
        this.sourcePosition = sourcePosition;
    }

    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2, String file2, int line) {
        this(runtime, rubyClass, type2, new SimpleSourcePosition(file2, line));
    }

    public static RubyClass createProcClass(Ruby runtime) {
        RubyClass procClass = runtime.defineClass("Proc", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setProc(procClass);
        procClass.setClassIndex(ClassIndex.PROC);
        procClass.setReifiedClass(RubyProc.class);
        procClass.defineAnnotatedMethods(RubyProc.class);
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    @Deprecated
    public static RubyProc newProc(Ruby runtime, Block.Type type2) {
        throw runtime.newRuntimeError("deprecated RubyProc.newProc with no block; do not use");
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2) {
        return RubyProc.newProc(runtime, block, type2, null);
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2, ISourcePosition sourcePosition) {
        RubyProc proc = new RubyProc(runtime, runtime.getProc(), type2, sourcePosition);
        proc.setup(block);
        return proc;
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2, String file2, int line) {
        RubyProc proc = new RubyProc(runtime, runtime.getProc(), type2, file2, line);
        proc.setup(block);
        return proc;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            block = context.getCurrentFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null && block.getProcObject().getMetaClass() == recv2) {
            return block.getProcObject();
        }
        RubyProc obj = new RubyProc(context.runtime, (RubyClass)recv2, Block.Type.PROC);
        obj.setup(block);
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    private void setup(Block procBlock) {
        if (!procBlock.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.isLambda()) {
            // empty if block
        }
        if (this.isThread()) {
            Binding oldBinding = procBlock.getBinding();
            Binding newBinding = new Binding(oldBinding.getSelf(), oldBinding.getFrame().duplicate(), oldBinding.getVisibility(), oldBinding.getDynamicScope(), oldBinding.getMethod(), oldBinding.getFile(), oldBinding.getLine());
            this.block = new Block(procBlock.getBody(), newBinding);
            StaticScope oldScope = this.block.getBody().getStaticScope();
            StaticScope newScope = oldScope.duplicate();
            this.block.getBody().setStaticScope(newScope);
        } else {
            this.block = procBlock;
        }
        this.block.getBinding().setFile(this.block.getBody().getFile());
        this.block.getBinding().setLine(this.block.getBody().getLine());
        this.block.type = this.type;
        this.block.setProcObject(this);
        this.block.getBinding().getDummyScope(this.block.getBody().getStaticScope());
    }

    @Override
    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc newProc = RubyProc.newProc(this.getRuntime(), this.block, this.type, this.sourcePosition);
        return newProc;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        return RubyProc.newProc(this.getRuntime(), this.block, this.type, this.sourcePosition);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        return this.getRuntime().newBoolean(other instanceof RubyProc && (this == other || this.block.equals(((RubyProc)other).block)));
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s19();
    }

    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public IRubyObject to_s19() {
        StringBuilder sb = new StringBuilder("#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + this.block.getBody().getFile() + ":" + (this.block.getBody().getLine() + 1));
        if (this.isLambda()) {
            sb.append(" (lambda)");
        }
        sb.append(">");
        return RubyString.newString(this.getRuntime(), sb.toString());
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.call19(context, args2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.call(context, args2, null, Block.NULL_BLOCK);
    }

    public static IRubyObject[] prepareArgs(ThreadContext context, Block.Type type2, BlockBody blockBody, IRubyObject[] args2) {
        int needsKwargs;
        boolean restKwargs;
        Arity arity2 = blockBody.arity();
        if (arity2 == null) {
            return args2;
        }
        if (args2 == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (type2 == Block.Type.LAMBDA) {
            blockBody.getSignature().checkArity(context.runtime, args2);
            return args2;
        }
        boolean isFixed = arity2.isFixed();
        int required = arity2.required();
        int actual = args2.length;
        boolean bl = restKwargs = blockBody instanceof IRBlockBody && ((IRBlockBody)blockBody).getSignature().hasKwargs();
        if ((arity2 != Arity.ONE_ARGUMENT && required != 0 && (isFixed || arity2 != Arity.OPTIONAL) || restKwargs) && actual == 1 && args2[0].respondsTo("to_ary")) {
            args2 = args2[0].convertToArray().toJavaArray();
            actual = args2.length;
        }
        int n = needsKwargs = blockBody instanceof IRBlockBody && ((IRBlockBody)blockBody).getSignature().hasKwargs() ? 1 - ((IRBlockBody)blockBody).getSignature().getRequiredKeywordForArityCount() : 0;
        if (isFixed && required > 0 && required + needsKwargs != actual) {
            IRubyObject[] newArgs = Arrays.copyOf(args2, required + needsKwargs);
            if (required > actual) {
                Helpers.fillNil(newArgs, actual, required, context.runtime);
            } else if (needsKwargs != 0) {
                newArgs[newArgs.length - 1] = args2.length < required + needsKwargs ? RubyHash.newHash(context.runtime) : args2[args2.length - 1];
            }
            args2 = newArgs;
        }
        return args2;
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, rest=true)
    public IRubyObject call19(ThreadContext context, IRubyObject[] args2, Block blockCallArg) {
        IRubyObject[] preppedArgs = RubyProc.prepareArgs(context, this.type, this.block.getBody(), args2);
        return this.call(context, preppedArgs, null, blockCallArg);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Block passedBlock) {
        Block newBlock;
        assert (args2 != null);
        if (self2 == null) {
            newBlock = this.block;
        } else {
            newBlock = this.block.cloneBlockAndFrame();
            newBlock.getBinding().setSelf(self2);
        }
        return newBlock.call(context, args2, passedBlock);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.getSignature().arityValue());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }

    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.sourcePosition != null) {
            return runtime.newArray((IRubyObject)runtime.newString(this.sourcePosition.getFile()), (IRubyObject)runtime.newFixnum(this.sourcePosition.getLine() + 1));
        }
        if (this.block != null) {
            Binding binding2 = this.block.getBinding();
            return runtime.newArray((IRubyObject)runtime.newString(binding2.getFile()), (IRubyObject)runtime.newFixnum(binding2.getLine() + 1));
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        BlockBody body = this.getBlock().getBody();
        if (body instanceof MethodBlock) {
            return ((MethodBlock)body).getMethod().parameters(context);
        }
        return Helpers.parameterListToParameters(context.runtime, body.getParameterList(), this.isLambda());
    }

    @JRubyMethod(name={"lambda?"})
    public IRubyObject lambda_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isLambda());
    }

    private boolean isLambda() {
        return this.type.equals((Object)Block.Type.LAMBDA);
    }

    private boolean isProc() {
        return this.type.equals((Object)Block.Type.PROC);
    }

    private boolean isThread() {
        return this.type.equals((Object)Block.Type.THREAD);
    }
}

