/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.Node;
import org.jruby.runtime.ThreadContext;

public class ParsingAndRunManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealWithRunFromMain(Ruby runtime, InputStream inputStream, String filename2) {
        Node scriptNode = runtime.parseFromMain(inputStream, filename2);
        try {
            inputStream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        ThreadContext context = runtime.getCurrentContext();
        String oldFile = context.getFile();
        int oldLine = context.getLine();
        try {
            RubyInstanceConfig config;
            if (scriptNode != null) {
                context.setFileAndLine(scriptNode.getPosition());
            }
            if ((config = runtime.getInstanceConfig()).isAssumePrinting() || config.isAssumeLoop()) {
                runtime.runWithGetsLoop(scriptNode, config.isAssumePrinting(), config.isProcessLineEnds(), config.isSplit());
            } else {
                runtime.runNormally(scriptNode);
            }
        }
        finally {
            context.setFileAndLine(oldFile, oldLine);
        }
    }
}

