/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleChain;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public class RubyModule
extends RubyBasicObject
implements ModuleChain {
    public static final Object VISIBILITY_FRAME_SLOT_ID = new Object();
    private final RubyContext context;
    @CompilerDirectives.CompilationFinal
    protected ModuleChain parentModule;
    private LexicalScope lexicalScope;
    private String name;
    private final Map<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
    private final Map<String, RubyConstant> constants = new HashMap<String, RubyConstant>();
    private final Map<String, Object> classVariables = new HashMap<String, Object>();
    private final CyclicAssumption unmodifiedAssumption;
    private final Set<RubyModule> dependents = Collections.newSetFromMap(new WeakHashMap());
    private final Set<RubyModule> lexicalDependents = Collections.newSetFromMap(new WeakHashMap());

    public static void debugModuleChain(RubyModule module) {
        for (ModuleChain chain = module; chain != null; chain = chain.getParentModule()) {
            System.err.print(chain.getClass());
            RubyModule real2 = chain.getActualModule();
            System.err.print(" " + real2.getName());
            System.err.println();
        }
    }

    public RubyModule(RubyContext context, RubyModule lexicalParent, String name2) {
        this(context, lexicalParent, name2, null);
    }

    public RubyModule(RubyContext context, RubyModule lexicalParent, String name2, RubyNode currentNode) {
        this(context, context.getCoreLibrary().getModuleClass(), lexicalParent, name2, currentNode);
    }

    protected RubyModule(RubyContext context, RubyClass selfClass, RubyModule lexicalParent, String name2, RubyNode currentNode) {
        super(selfClass, context);
        this.context = context;
        this.name = name2;
        this.unmodifiedAssumption = new CyclicAssumption(name2 + " is unmodified");
        this.getAdoptedByLexicalParent(lexicalParent, currentNode);
    }

    protected void getAdoptedByLexicalParent(RubyModule lexicalParent, RubyNode currentNode) {
        if (lexicalParent != null) {
            lexicalParent.setConstant(currentNode, this.name, this);
            lexicalParent.addLexicalDependent(this);
            if (lexicalParent != this.context.getCoreLibrary().getObjectClass()) {
                this.name = lexicalParent.getName() + "::" + this.name;
            }
        }
    }

    public void initCopy(RubyModule other) {
        this.name = other.name;
        this.parentModule = other.parentModule;
        this.methods.putAll(other.methods);
        this.constants.putAll(other.constants);
        this.classVariables.putAll(other.classVariables);
    }

    public boolean isOnlyAModule() {
        return !(this instanceof RubyClass);
    }

    protected void unsafeSetParent(RubyModule parent) {
        this.parentModule = parent;
        parent.addDependent(this);
        this.newVersion();
    }

    public void include(Node currentNode, RubyModule module) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        Stack<RubyModule> moduleAncestors = new Stack<RubyModule>();
        for (RubyModule ancestor : module.ancestors()) {
            moduleAncestors.push(ancestor);
        }
        while (!moduleAncestors.isEmpty()) {
            RubyModule mod = (RubyModule)moduleAncestors.pop();
            this.parentModule = new IncludedModule(mod, this.parentModule);
            mod.addDependent(this);
        }
        this.newVersion();
    }

    public void setConstant(RubyNode currentNode, String name2, Object value2) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        RubyConstant previous = this.getConstants().get(name2);
        if (previous == null) {
            this.getConstants().put(name2, new RubyConstant(this, value2, false));
        } else {
            this.getConstants().put(name2, new RubyConstant(this, value2, previous.isPrivate()));
        }
        this.newLexicalVersion();
    }

    public void removeConstant(RubyNode currentNode, String data2) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        this.getConstants().remove(data2);
        this.newLexicalVersion();
    }

    public void removeClassVariable(RubyNode currentNode, String variableName) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        this.classVariables.remove(variableName);
    }

    public void addMethod(RubyNode currentNode, InternalMethod method) {
        RubyNode.notDesignedForCompilation();
        assert (method != null);
        assert (this.getMethods() != null);
        this.checkFrozen(currentNode);
        this.getMethods().put(method.getName(), method.withDeclaringModule(this));
        this.newVersion();
    }

    public void removeMethod(RubyNode currentNode, String methodName) {
        RubyNode.notDesignedForCompilation();
        this.checkFrozen(currentNode);
        this.getMethods().remove(methodName);
        this.newVersion();
    }

    public void undefMethod(RubyNode currentNode, String methodName) {
        RubyNode.notDesignedForCompilation();
        InternalMethod method = ModuleOperations.lookupMethod(this, methodName);
        if (method == null) {
            throw new UnsupportedOperationException();
        }
        this.undefMethod(currentNode, method);
    }

    public void undefMethod(RubyNode currentNode, InternalMethod method) {
        RubyNode.notDesignedForCompilation();
        this.addMethod(currentNode, method.undefined());
    }

    private InternalMethod deepMethodSearch(String name2) {
        InternalMethod method = ModuleOperations.lookupMethod(this, name2);
        if (method == null && this.isOnlyAModule()) {
            method = ModuleOperations.lookupMethod(this.context.getCoreLibrary().getObjectClass(), name2);
        }
        return method;
    }

    public void alias(RubyNode currentNode, String newName, String oldName) {
        RubyNode.notDesignedForCompilation();
        InternalMethod method = this.deepMethodSearch(oldName);
        if (method == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(oldName, this.getName(), currentNode));
        }
        this.addMethod(currentNode, method.withNewName(newName));
    }

    public void changeConstantVisibility(RubyNode currentNode, RubySymbol constant, boolean isPrivate) {
        RubyNode.notDesignedForCompilation();
        RubyConstant rubyConstant = ModuleOperations.lookupConstant(this.getContext(), LexicalScope.NONE, this, constant.toString());
        this.checkFrozen(currentNode);
        if (rubyConstant == null) {
            throw new RaiseException(this.context.getCoreLibrary().nameErrorUninitializedConstant(this, constant.toString(), currentNode));
        }
        rubyConstant.setPrivate(isPrivate);
        this.newLexicalVersion();
    }

    public void appendFeatures(RubyNode currentNode, RubyModule other) {
        RubyNode.notDesignedForCompilation();
        other.include(currentNode, this);
    }

    @Override
    public RubyContext getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + "(" + this.name + ")";
    }

    public void newVersion() {
        RubyNode.notDesignedForCompilation();
        this.newVersion(new HashSet<RubyModule>(), false);
    }

    public void newLexicalVersion() {
        RubyNode.notDesignedForCompilation();
        this.newVersion(new HashSet<RubyModule>(), true);
    }

    private void newVersion(Set<RubyModule> alreadyInvalidated, boolean considerLexicalDependents) {
        if (alreadyInvalidated.contains(this)) {
            return;
        }
        this.unmodifiedAssumption.invalidate();
        alreadyInvalidated.add(this);
        for (RubyModule dependent : this.dependents) {
            dependent.newVersion(alreadyInvalidated, considerLexicalDependents);
        }
        if (considerLexicalDependents) {
            for (RubyModule dependent : this.lexicalDependents) {
                dependent.newVersion(alreadyInvalidated, considerLexicalDependents);
            }
        }
    }

    public void addDependent(RubyModule dependent) {
        RubyNode.notDesignedForCompilation();
        this.dependents.add(dependent);
    }

    public void addLexicalDependent(RubyModule lexicalChild) {
        RubyNode.notDesignedForCompilation();
        if (lexicalChild != this) {
            this.lexicalDependents.add(lexicalChild);
        }
    }

    public Assumption getUnmodifiedAssumption() {
        RubyNode.notDesignedForCompilation();
        return this.unmodifiedAssumption.getAssumption();
    }

    public static void setCurrentVisibility(Visibility visibility) {
        RubyNode.notDesignedForCompilation();
        Frame callerFrame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
        assert (callerFrame != null);
        assert (callerFrame.getFrameDescriptor() != null);
        FrameSlot visibilitySlot = callerFrame.getFrameDescriptor().findFrameSlot(VISIBILITY_FRAME_SLOT_ID);
        assert (visibilitySlot != null) : "no visibility slot";
        callerFrame.setObject(visibilitySlot, (Object)visibility);
    }

    public void visibilityMethod(RubyNode currentNode, Object[] arguments, Visibility visibility) {
        RubyNode.notDesignedForCompilation();
        if (arguments.length == 0) {
            RubyModule.setCurrentVisibility(visibility);
        } else {
            for (Object arg2 : arguments) {
                String methodName;
                if (arg2 instanceof RubySymbol) {
                    methodName = ((RubySymbol)arg2).toString();
                } else if (arg2 instanceof RubyString) {
                    methodName = ((RubyString)arg2).toString();
                } else {
                    throw new UnsupportedOperationException();
                }
                InternalMethod method = this.deepMethodSearch(methodName);
                if (method == null) {
                    throw new RuntimeException("Couldn't find method " + arg2.toString());
                }
                if (visibility == Visibility.MODULE_FUNCTION) {
                    this.addMethod(currentNode, method.withVisibility(Visibility.PRIVATE));
                    this.getSingletonClass(currentNode).addMethod(currentNode, method.withVisibility(Visibility.PUBLIC));
                    continue;
                }
                this.addMethod(currentNode, method.withVisibility(visibility));
            }
        }
    }

    public Map<String, RubyConstant> getConstants() {
        return this.constants;
    }

    public Map<String, InternalMethod> getMethods() {
        return this.methods;
    }

    public Map<String, Object> getClassVariables() {
        return this.classVariables;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (RubyConstant constant : this.constants.values()) {
            if (!(constant.getValue() instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)constant.getValue()).visitObjectGraph(visitor);
        }
        for (InternalMethod method : this.methods.values()) {
            if (method.getDeclarationFrame() == null) continue;
            this.getContext().getObjectSpaceManager().visitFrame(method.getDeclarationFrame(), visitor);
        }
    }

    @Override
    public ModuleChain getParentModule() {
        return this.parentModule;
    }

    @Override
    public RubyModule getActualModule() {
        return this;
    }

    public Iterable<RubyModule> ancestors() {
        final RubyModule top = this;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new AncestorIterator(top);
            }
        };
    }

    public Iterable<RubyModule> parentAncestors() {
        final ModuleChain top = this.parentModule;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new AncestorIterator(top);
            }
        };
    }

    public Iterable<RubyModule> includedModules() {
        final ModuleChain top = this.parentModule;
        return new Iterable<RubyModule>(){

            @Override
            public Iterator<RubyModule> iterator() {
                return new IncludedModulesIterator(top);
            }
        };
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setLexicalScope(LexicalScope lexicalScope) {
        this.lexicalScope = lexicalScope;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public static class ModuleAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyModule(context, null, null);
        }
    }

    private class IncludedModulesIterator
    extends AncestorIterator {
        public IncludedModulesIterator(ModuleChain top) {
            super(top);
        }

        @Override
        public boolean hasNext() {
            return super.hasNext() && !(this.module instanceof RubyClass);
        }
    }

    private class AncestorIterator
    implements Iterator<RubyModule> {
        ModuleChain module;

        public AncestorIterator(ModuleChain top) {
            this.module = top;
        }

        @Override
        public boolean hasNext() {
            return this.module != null;
        }

        @Override
        public RubyModule next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ModuleChain mod = this.module;
            this.module = this.module.getParentModule();
            return mod.getActualModule();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class IncludedModule
    implements ModuleChain {
        private final RubyModule includedModule;
        private final ModuleChain parentModule;

        public IncludedModule(RubyModule includedModule, ModuleChain parentModule) {
            this.includedModule = includedModule;
            this.parentModule = parentModule;
        }

        @Override
        public ModuleChain getParentModule() {
            return this.parentModule;
        }

        @Override
        public RubyModule getActualModule() {
            return this.includedModule;
        }

        public String toString() {
            return super.toString() + "(" + this.includedModule + ")";
        }
    }
}

