/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class OpenModuleNode
extends RubyNode {
    @Node.Child
    private RubyNode definingModule;
    @Node.Child
    private MethodDefinitionNode definitionMethod;
    protected final LexicalScope lexicalScope;
    @Node.Child
    private IndirectCallNode callModuleDefinitionNode;

    public OpenModuleNode(RubyContext context, SourceSection sourceSection, RubyNode definingModule, MethodDefinitionNode definitionMethod, LexicalScope lexicalScope) {
        super(context, sourceSection);
        this.definingModule = definingModule;
        this.definitionMethod = definitionMethod;
        this.lexicalScope = lexicalScope;
        this.callModuleDefinitionNode = Truffle.getRuntime().createIndirectCallNode();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        OpenModuleNode.notDesignedForCompilation();
        RubyModule module = (RubyModule)this.definingModule.execute(frame);
        this.lexicalScope.setLiveModule(module);
        this.lexicalScope.getParent().getLiveModule().addLexicalDependent(module);
        InternalMethod definition = this.definitionMethod.executeMethod(frame).withDeclaringModule(module);
        return this.callModuleDefinitionNode.call(frame, definition.getCallTarget(), RubyArguments.pack(definition, definition.getDeclarationFrame(), module, null, new Object[0]));
    }
}

