/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.runtime.methods.Arity;

public class CheckArityNode
extends RubyNode {
    private final Arity arity;
    private final String[] keywords;
    private final boolean keywordsRest;

    public CheckArityNode(RubyContext context, SourceSection sourceSection, Arity arity2) {
        this(context, sourceSection, arity2, new String[0], false);
    }

    public CheckArityNode(RubyContext context, SourceSection sourceSection, Arity arity2, String[] keywords, boolean keywordsRest) {
        super(context, sourceSection);
        this.arity = arity2;
        this.keywords = keywords;
        this.keywordsRest = keywordsRest;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        int given = RubyArguments.getUserArgumentsCount(frame.getArguments());
        if (!this.checkArity(frame, given)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(given, this.arity.getRequired(), this));
        }
        if (!this.keywordsRest && this.arity.hasKeywords() && this.getKeywordsHash(frame) != null) {
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(this.getKeywordsHash(frame))) {
                if (this.keywordAllowed(keyValue.getKey().toString())) continue;
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("unknown keyword: " + keyValue.getKey().toString(), this));
            }
        }
    }

    private boolean checkArity(VirtualFrame frame, int given) {
        if (this.arity.hasKeywords() && this.getKeywordsHash(frame) != null) {
            --given;
        }
        if (this.arity.getRequired() != 0 && given < this.arity.getRequired()) {
            return false;
        }
        return this.arity.allowsMore() || given <= this.arity.getRequired() + this.arity.getOptional();
    }

    private boolean keywordAllowed(String keyword) {
        for (String allowedKeyword : this.keywords) {
            if (!keyword.equals(allowedKeyword)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeVoid(frame);
        return this.getContext().getCoreLibrary().getNilObject();
    }

    private RubyHash getKeywordsHash(VirtualFrame frame) {
        if (RubyArguments.getUserArgumentsCount(frame.getArguments()) <= this.arity.getRequired()) {
            return null;
        }
        Object lastArgument = RubyArguments.getUserArgument(frame.getArguments(), RubyArguments.getUserArgumentsCount(frame.getArguments()) - 1);
        if (lastArgument instanceof RubyHash) {
            return (RubyHash)lastArgument;
        }
        return null;
    }
}

