/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.instrument;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.KillException;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.TruffleEventReceiver;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyString;

@NodeInfo(cost=NodeCost.NONE)
public final class RubyWrapperNode
extends RubyNode
implements ProbeNode.WrapperNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private ProbeNode probeNode;

    public RubyWrapperNode(RubyNode child) {
        super(child.getContext(), child.getSourceSection());
        assert (!(child instanceof RubyWrapperNode));
        this.child = child;
    }

    @Override
    public String instrumentationInfo() {
        return "Wrapper node for Ruby";
    }

    @Override
    public RubyNode getNonWrapperNode() {
        return this.child;
    }

    @Override
    public void insertProbe(ProbeNode newProbeNode) {
        this.probeNode = this.insert(newProbeNode);
    }

    @Override
    public Probe getProbe() {
        try {
            return this.probeNode.getProbe();
        }
        catch (IllegalStateException e) {
            throw new UnsupportedOperationException("A lite-Probed wrapper has no explicit Probe");
        }
    }

    @Override
    public RubyNode getChild() {
        return this.child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.execute(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public RubyArray executeArray(VirtualFrame frame) throws UnexpectedResultException {
        RubyArray result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.executeArray(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public RubyBignum executeBignum(VirtualFrame frame) throws UnexpectedResultException {
        RubyBignum result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.executeBignum(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        boolean result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.executeBoolean(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.child.isDefined(frame);
    }

    @Override
    public int executeIntegerFixnum(VirtualFrame frame) throws UnexpectedResultException {
        int result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.executeIntegerFixnum(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public long executeLongFixnum(VirtualFrame frame) throws UnexpectedResultException {
        long result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.executeLongFixnum(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public double executeFloat(VirtualFrame frame) throws UnexpectedResultException {
        double result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.executeFloat(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public RubyString executeRubyString(VirtualFrame frame) throws UnexpectedResultException {
        RubyString result2;
        this.probeNode.enter(this.child, frame);
        try {
            result2 = this.child.executeRubyString(frame);
            this.probeNode.returnValue(this.child, frame, result2);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result2;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.probeNode.enter(this.child, frame);
        try {
            this.child.executeVoid(frame);
            this.probeNode.returnVoid(this.child, frame);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional(this.child, frame, e);
            throw e;
        }
    }

    @Override
    public Probe probe() {
        throw new UnsupportedOperationException("Cannot call probe() on a wrapper.");
    }

    @Override
    public void probeLite(TruffleEventReceiver eventReceiver) {
        throw new UnsupportedOperationException("Cannot call probeLite() on a wrapper.");
    }
}

