/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;

@CoreClass(name="TrueClass")
public abstract class TrueClassNodes {

    @CoreMethod(names={"^"}, needsSelf=false, required=1)
    public static abstract class XorNode
    extends UnaryCoreMethodNode {
        public XorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public XorNode(XorNode prev) {
            super(prev);
        }

        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeFactory.create(this.getContext(), this.getSourceSection(), operand);
        }

        @Specialization
        public boolean xor(boolean other) {
            return !other;
        }
    }

    @CoreMethod(names={"|"}, needsSelf=false, required=1)
    public static abstract class OrNode
    extends CoreMethodNode {
        public OrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OrNode(OrNode prev) {
            super(prev);
        }

        @Specialization
        public boolean or(Object other) {
            return true;
        }
    }

    @CoreMethod(names={"&"}, needsSelf=false, required=1)
    public static abstract class AndNode
    extends UnaryCoreMethodNode {
        public AndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AndNode(AndNode prev) {
            super(prev);
        }

        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeFactory.create(this.getContext(), this.getSourceSection(), operand);
        }

        @Specialization
        public boolean and(boolean other) {
            return other;
        }
    }
}

