/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.RangeNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=RangeNodes.class)
public final class RangeNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(EqualNodeFactory.getInstance(), CollectNodeFactory.getInstance(), EachNodeFactory.getInstance(), ExcludeEndNodeFactory.getInstance(), FirstNodeFactory.getInstance(), IncludeNodeFactory.getInstance(), LastNodeFactory.getInstance(), StepNodeFactory.getInstance(), ToANodeFactory.getInstance(), ToSNodeFactory.getInstance());
    }

    @GeneratedBy(value=RangeNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<RangeNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(RangeNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSObjectRangeNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSObjectRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class}, 0, 0);

            ToSObjectRangeNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof ObjectRange");
                }
                return super.toS(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    return super.toS(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToSNode create0(RangeNodes.ToSNode current2) {
                return new ToSObjectRangeNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSIntegerFixnumRangeNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class}, 0, 0);

            ToSIntegerFixnumRangeNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToSNode create0(RangeNodes.ToSNode current2) {
                return new ToSIntegerFixnumRangeNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends RangeNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ToSBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ToSUninitializedNode(this), new ToSPolymorphicNode(this), (ToSBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    return (ToSBaseNode)ToSIntegerFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    return (ToSBaseNode)ToSObjectRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.ToANode.class)
    public static final class ToANodeFactory
    extends NodeFactoryBase<RangeNodes.ToANode> {
        private static ToANodeFactory toANodeFactoryInstance;

        private ToANodeFactory() {
            super(RangeNodes.ToANode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.ToANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToANodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.ToANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToAUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.ToANode> getInstance() {
            if (toANodeFactoryInstance == null) {
                toANodeFactoryInstance = new ToANodeFactory();
            }
            return toANodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToAPolymorphicNode
        extends ToABaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToAPolymorphicNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToAIntegerFixnumRangeNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToAIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class}, 0, 0);

            ToAIntegerFixnumRangeNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                return super.toA(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    return super.toA(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToANode create0(RangeNodes.ToANode current2) {
                return new ToAIntegerFixnumRangeNode((ToABaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToAUninitializedNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToAUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToAUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToAUninitializedNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToABaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToANode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToAUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        private static abstract class ToABaseNode
        extends RangeNodes.ToANode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToABaseNode next0;

            ToABaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToABaseNode(ToABaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToABaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToAUninitializedNode(this);
                    ((ToAUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ToABaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ToAUninitializedNode(this), new ToAPolymorphicNode(this), (ToABaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToABaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    return (ToABaseNode)ToAIntegerFixnumRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToABaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToABaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.StepNode.class)
    public static final class StepNodeFactory
    extends NodeFactoryBase<RangeNodes.StepNode> {
        private static StepNodeFactory stepNodeFactoryInstance;

        private StepNodeFactory() {
            super(RangeNodes.StepNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.StepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StepNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.StepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StepUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.StepNode> getInstance() {
            if (stepNodeFactoryInstance == null) {
                stepNodeFactoryInstance = new StepNodeFactory();
            }
            return stepNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StepPolymorphicNode
        extends StepBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StepPolymorphicNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepIntegerFixnumRangeRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepIntegerFixnumRangeRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, Integer.TYPE, RubyProc.class}, 0, 0);

            StepIntegerFixnumRangeRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                int arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current2) {
                return new StepIntegerFixnumRangeRubyProcNode((StepBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StepUninitializedNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StepUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StepUninitializedNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StepBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StepBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StepUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        private static abstract class StepBaseNode
        extends RangeNodes.StepNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StepBaseNode next0;

            StepBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StepBaseNode(StepBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                StepBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StepBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StepUninitializedNode(this);
                    ((StepUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = StepBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new StepUninitializedNode(this), new StepPolymorphicNode(this), (StepBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StepBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    return (StepBaseNode)StepIntegerFixnumRangeRubyProcNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StepBaseNode otherCast = (StepBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StepBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.LastNode.class)
    public static final class LastNodeFactory
    extends NodeFactoryBase<RangeNodes.LastNode> {
        private static LastNodeFactory lastNodeFactoryInstance;

        private LastNodeFactory() {
            super(RangeNodes.LastNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.LastNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LastNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.LastNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LastUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.LastNode> getInstance() {
            if (lastNodeFactoryInstance == null) {
                lastNodeFactoryInstance = new LastNodeFactory();
            }
            return lastNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.LastNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LastPolymorphicNode
        extends LastBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LastPolymorphicNode(LastBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.LastNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LastObjectObjectRangeNode
        extends LastBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LastObjectObjectRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class}, 0, 0);

            LastObjectObjectRangeNode(LastBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof ObjectRange");
                }
                return super.last(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    return super.last(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.LastNode create0(RangeNodes.LastNode current2) {
                return new LastObjectObjectRangeNode((LastBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.LastNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LastIntIntegerFixnumRangeNode
        extends LastBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LastIntIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class}, 0, 0);

            LastIntIntegerFixnumRangeNode(LastBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof IntegerFixnumRange"));
                }
                return super.last(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    return super.last(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.LastNode create0(RangeNodes.LastNode current2) {
                return new LastIntIntegerFixnumRangeNode((LastBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.LastNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LastUninitializedNode
        extends LastBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LastUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LastUninitializedNode(LastBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LastBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LastBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.LastNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LastUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.LastNode.class)
        private static abstract class LastBaseNode
        extends RangeNodes.LastNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LastBaseNode next0;

            LastBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LastBaseNode(LastBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                LastBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LastBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LastUninitializedNode(this);
                    ((LastUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = LastBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new LastUninitializedNode(this), new LastPolymorphicNode(this), (LastBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LastBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    return (LastBaseNode)LastIntIntegerFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    return (LastBaseNode)LastObjectObjectRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LastBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LastBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.IncludeNode.class)
    public static final class IncludeNodeFactory
    extends NodeFactoryBase<RangeNodes.IncludeNode> {
        private static IncludeNodeFactory includeNodeFactoryInstance;

        private IncludeNodeFactory() {
            super(RangeNodes.IncludeNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.IncludeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.IncludeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IncludeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.IncludeNode> getInstance() {
            if (includeNodeFactoryInstance == null) {
                includeNodeFactoryInstance = new IncludeNodeFactory();
            }
            return includeNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IncludePolymorphicNode
        extends IncludeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IncludePolymorphicNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=RangeNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeObjectRangeObjectNode
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeObjectRangeObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, Object.class}, 0, 0);

            IncludeObjectRangeObjectNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof ObjectRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.include(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    return super.include(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.IncludeNode create0(RangeNodes.IncludeNode current2) {
                return new IncludeObjectRangeObjectNode((IncludeBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeIntegerFixnumRangeIntNode
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeIntegerFixnumRangeIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, Integer.TYPE}, 0, 0);

            IncludeIntegerFixnumRangeIntNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.include(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.include(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.IncludeNode create0(RangeNodes.IncludeNode current2) {
                return new IncludeIntegerFixnumRangeIntNode((IncludeBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IncludeUninitializedNode
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IncludeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IncludeUninitializedNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IncludeBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.IncludeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IncludeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.IncludeNode.class)
        private static abstract class IncludeBaseNode
        extends RangeNodes.IncludeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IncludeBaseNode next0;

            IncludeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IncludeBaseNode(IncludeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                IncludeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IncludeUninitializedNode(this);
                    ((IncludeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = IncludeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new IncludeUninitializedNode(this), new IncludePolymorphicNode(this), (IncludeBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IncludeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (IncludeBaseNode)IncludeIntegerFixnumRangeIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    return (IncludeBaseNode)IncludeObjectRangeObjectNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IncludeBaseNode otherCast = (IncludeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IncludeBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.FirstNode.class)
    public static final class FirstNodeFactory
    extends NodeFactoryBase<RangeNodes.FirstNode> {
        private static FirstNodeFactory firstNodeFactoryInstance;

        private FirstNodeFactory() {
            super(RangeNodes.FirstNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.FirstNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FirstNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.FirstNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FirstUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.FirstNode> getInstance() {
            if (firstNodeFactoryInstance == null) {
                firstNodeFactoryInstance = new FirstNodeFactory();
            }
            return firstNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FirstPolymorphicNode
        extends FirstBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FirstPolymorphicNode(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FirstObjectObjectRangeNode
        extends FirstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FirstObjectObjectRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class}, 0, 0);

            FirstObjectObjectRangeNode(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof ObjectRange");
                }
                return super.each(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    return super.each(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.FirstNode create0(RangeNodes.FirstNode current2) {
                return new FirstObjectObjectRangeNode((FirstBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FirstIntIntegerFixnumRangeNode
        extends FirstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FirstIntIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class}, 0, 0);

            FirstIntIntegerFixnumRangeNode(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof IntegerFixnumRange"));
                }
                return super.each(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    return super.each(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.FirstNode create0(RangeNodes.FirstNode current2) {
                return new FirstIntIntegerFixnumRangeNode((FirstBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FirstUninitializedNode
        extends FirstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FirstUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FirstUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FirstUninitializedNode(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FirstBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FirstBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.FirstNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FirstUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.FirstNode.class)
        private static abstract class FirstBaseNode
        extends RangeNodes.FirstNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FirstBaseNode next0;

            FirstBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FirstBaseNode(FirstBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FirstBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FirstBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FirstUninitializedNode(this);
                    ((FirstUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = FirstBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new FirstUninitializedNode(this), new FirstPolymorphicNode(this), (FirstBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FirstBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    return (FirstBaseNode)FirstIntIntegerFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    return (FirstBaseNode)FirstObjectObjectRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FirstBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FirstBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
    public static final class ExcludeEndNodeFactory
    extends NodeFactoryBase<RangeNodes.ExcludeEndNode> {
        private static ExcludeEndNodeFactory excludeEndNodeFactoryInstance;

        private ExcludeEndNodeFactory() {
            super(RangeNodes.ExcludeEndNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.ExcludeEndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExcludeEndNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.ExcludeEndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExcludeEndUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.ExcludeEndNode> getInstance() {
            if (excludeEndNodeFactoryInstance == null) {
                excludeEndNodeFactoryInstance = new ExcludeEndNodeFactory();
            }
            return excludeEndNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExcludeEndPolymorphicNode
        extends ExcludeEndBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExcludeEndPolymorphicNode(ExcludeEndBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExcludeEndRubyRangeNode
        extends ExcludeEndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExcludeEndRubyRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.class}, 0, 0);

            ExcludeEndRubyRangeNode(ExcludeEndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyRange");
                }
                return super.excludeEnd(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyRange(arguments0Value)) {
                    RubyRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyRange(arguments0Value);
                    return super.excludeEnd(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ExcludeEndNode create0(RangeNodes.ExcludeEndNode current2) {
                return new ExcludeEndRubyRangeNode((ExcludeEndBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExcludeEndUninitializedNode
        extends ExcludeEndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExcludeEndUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExcludeEndUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExcludeEndUninitializedNode(ExcludeEndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExcludeEndBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExcludeEndBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ExcludeEndNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExcludeEndUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        private static abstract class ExcludeEndBaseNode
        extends RangeNodes.ExcludeEndNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExcludeEndBaseNode next0;

            ExcludeEndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExcludeEndBaseNode(ExcludeEndBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ExcludeEndBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExcludeEndBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExcludeEndUninitializedNode(this);
                    ((ExcludeEndUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ExcludeEndBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ExcludeEndUninitializedNode(this), new ExcludeEndPolymorphicNode(this), (ExcludeEndBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExcludeEndBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyRange(arguments0Value)) {
                    return (ExcludeEndBaseNode)ExcludeEndRubyRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExcludeEndBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExcludeEndBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<RangeNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(RangeNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachPolymorphicNode
        extends EachBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachPolymorphicNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachIntegerFixnumRangeNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, RubyProc.class}, 0, 0);

            EachIntegerFixnumRangeNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.each(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.each(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RangeNodes.EachNode current2) {
                return new EachIntegerFixnumRangeNode((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachUninitializedNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachUninitializedNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        private static abstract class EachBaseNode
        extends RangeNodes.EachNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachBaseNode next0;

            EachBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachBaseNode(EachBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EachBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachUninitializedNode(this);
                    ((EachUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = EachBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new EachUninitializedNode(this), new EachPolymorphicNode(this), (EachBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (EachBaseNode)EachIntegerFixnumRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachBaseNode otherCast = (EachBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.CollectNode.class)
    public static final class CollectNodeFactory
    extends NodeFactoryBase<RangeNodes.CollectNode> {
        private static CollectNodeFactory collectNodeFactoryInstance;

        private CollectNodeFactory() {
            super(RangeNodes.CollectNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.CollectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CollectNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.CollectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CollectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.CollectNode> getInstance() {
            if (collectNodeFactoryInstance == null) {
                collectNodeFactoryInstance = new CollectNodeFactory();
            }
            return collectNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CollectPolymorphicNode
        extends CollectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            CollectPolymorphicNode(CollectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CollectIntegerFixnumRangeNode
        extends CollectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CollectIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, RubyProc.class}, 0, 0);

            CollectIntegerFixnumRangeNode(CollectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.collect(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.collect(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.CollectNode create0(RangeNodes.CollectNode current2) {
                return new CollectIntegerFixnumRangeNode((CollectBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CollectUninitializedNode
        extends CollectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CollectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CollectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CollectUninitializedNode(CollectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CollectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CollectBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.CollectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CollectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        private static abstract class CollectBaseNode
        extends RangeNodes.CollectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CollectBaseNode next0;

            CollectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CollectBaseNode(CollectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CollectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CollectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CollectUninitializedNode(this);
                    ((CollectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = CollectBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new CollectUninitializedNode(this), new CollectPolymorphicNode(this), (CollectBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CollectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (CollectBaseNode)CollectIntegerFixnumRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CollectBaseNode otherCast = (CollectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CollectBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<RangeNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(RangeNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.LongFixnumRange.class ? this.arguments[0].executeLongFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[1].executeIntegerFixnumRange(frameValue) : (this.arguments1PolymorphicType == RubyRange.LongFixnumRange.class ? this.arguments[1].executeLongFixnumRange(frameValue) : (this.arguments1PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[1].executeObjectRange(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualObjectRangeNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualObjectRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, RubyRange.ObjectRange.class}, 0, 0);

            EqualObjectRangeNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.ObjectRange arguments1Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof ObjectRange");
                }
                return super.equal(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectRange(arguments1Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    RubyRange.ObjectRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments1Value);
                    return super.equal(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EqualNode create0(RangeNodes.EqualNode current2) {
                return new EqualObjectRangeNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualLongFixnumRangeIntegerFixnumRangeNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualLongFixnumRangeIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, RubyRange.IntegerFixnumRange.class}, 0, 0);

            EqualLongFixnumRangeIntegerFixnumRangeNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof IntegerFixnumRange");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EqualNode create0(RangeNodes.EqualNode current2) {
                return new EqualLongFixnumRangeIntegerFixnumRangeNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualLongFixnumRangeNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualLongFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, RubyRange.LongFixnumRange.class}, 0, 0);

            EqualLongFixnumRangeNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.LongFixnumRange arguments1Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof LongFixnumRange");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments1Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    RubyRange.LongFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EqualNode create0(RangeNodes.EqualNode current2) {
                return new EqualLongFixnumRangeNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualIntegerFixnumRangeLongFixnumRangeNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualIntegerFixnumRangeLongFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, RubyRange.LongFixnumRange.class}, 0, 0);

            EqualIntegerFixnumRangeLongFixnumRangeNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.LongFixnumRange arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof LongFixnumRange");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    RubyRange.LongFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EqualNode create0(RangeNodes.EqualNode current2) {
                return new EqualIntegerFixnumRangeLongFixnumRangeNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualIntegerFixnumRangeNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, RubyRange.IntegerFixnumRange.class}, 0, 0);

            EqualIntegerFixnumRangeNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof IntegerFixnumRange");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EqualNode create0(RangeNodes.EqualNode current2) {
                return new EqualIntegerFixnumRangeNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends RangeNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = EqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new EqualUninitializedNode(this), new EqualPolymorphicNode(this), (EqualBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                        return (EqualBaseNode)EqualIntegerFixnumRangeNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments1Value)) {
                        return (EqualBaseNode)EqualIntegerFixnumRangeLongFixnumRangeNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments1Value)) {
                        return (EqualBaseNode)EqualLongFixnumRangeNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                        return (EqualBaseNode)EqualLongFixnumRangeIntegerFixnumRangeNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectRange(arguments1Value)) {
                    return (EqualBaseNode)EqualObjectRangeNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

