/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="Numeric")
public abstract class NumericNodes {

    @CoreMethod(names={"step"}, needsBlock=true, required=2)
    public static abstract class StepNode
    extends YieldingCoreMethodNode {
        public StepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StepNode(StepNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass step(VirtualFrame frame, int from, int to, int step2, RubyProc block) {
            for (int i2 = from; i2 <= to; i2 += step2) {
                this.yield(frame, block, i2);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"nonzero?"})
    public static abstract class NonZeroNode
    extends CoreMethodNode {
        public NonZeroNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NonZeroNode(NonZeroNode prev) {
            super(prev);
        }

        @Specialization
        public Object nonZero(int value2) {
            if (value2 == 0) {
                return false;
            }
            return value2;
        }

        @Specialization
        public Object nonZero(long value2) {
            if (value2 == 0L) {
                return false;
            }
            return value2;
        }

        @Specialization
        public Object nonZero(RubyBignum value2) {
            if (value2.isZero()) {
                return false;
            }
            return value2;
        }

        @Specialization
        public Object nonZero(double value2) {
            if (value2 == 0.0) {
                return false;
            }
            return value2;
        }
    }

    @CoreMethod(names={"+@"})
    public static abstract class PosNode
    extends CoreMethodNode {
        public PosNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PosNode(PosNode prev) {
            super(prev);
        }

        @Specialization
        public int pos(int value2) {
            return value2;
        }

        @Specialization
        public long pos(long value2) {
            return value2;
        }

        @Specialization
        public RubyBignum pos(RubyBignum value2) {
            return value2;
        }

        @Specialization
        public double pos(double value2) {
            return value2;
        }
    }
}

