/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;

@GeneratedBy(value=ModuleNodes.class)
public final class ModuleNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ContainsInstanceNodeFactory.getInstance(), IsSubclassOfNodeFactory.getInstance(), CompareNodeFactory.getInstance(), AliasMethodNodeFactory.getInstance(), AncestorsNodeFactory.getInstance(), AppendFeaturesNodeFactory.getInstance(), AttrReaderNodeFactory.getInstance(), AttrWriterNodeFactory.getInstance(), AttrAccessorNodeFactory.getInstance(), ClassEvalNodeFactory.getInstance(), ClassExecNodeFactory.getInstance(), ClassVariableDefinedNodeFactory.getInstance(), ClassVariableGetNodeFactory.getInstance(), ClassVariablesNodeFactory.getInstance(), ConstantsNodeFactory.getInstance(), ConstDefinedNodeFactory.getInstance(), ConstGetNodeFactory.getInstance(), ConstMissingNodeFactory.getInstance(), ConstSetNodeFactory.getInstance(), DefineMethodNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), IncludeNodeFactory.getInstance(), IncludePNodeFactory.getInstance(), MethodDefinedNodeFactory.getInstance(), ModuleFunctionNodeFactory.getInstance(), NameNodeFactory.getInstance(), NestingNodeFactory.getInstance(), PublicNodeFactory.getInstance(), PublicClassMethodNodeFactory.getInstance(), PrivateNodeFactory.getInstance(), PrivateClassMethodNodeFactory.getInstance(), PrivateInstanceMethodsNodeFactory.getInstance(), PublicInstanceMethodsNodeFactory.getInstance(), InstanceMethodsNodeFactory.getInstance(), InstanceMethodNodeFactory.getInstance(), PrivateConstantNodeFactory.getInstance(), PublicConstantNodeFactory.getInstance(), ProtectedNodeFactory.getInstance(), RemoveClassVariableNodeFactory.getInstance(), RemoveMethodNodeFactory.getInstance(), UndefMethodNodeFactory.getInstance());
    }

    @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
    public static final class UndefMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.UndefMethodNode> {
        private static UndefMethodNodeFactory undefMethodNodeFactoryInstance;

        private UndefMethodNodeFactory() {
            super(ModuleNodes.UndefMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.UndefMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UndefMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.UndefMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UndefMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.UndefMethodNode> getInstance() {
            if (undefMethodNodeFactoryInstance == null) {
                undefMethodNodeFactoryInstance = new UndefMethodNodeFactory();
            }
            return undefMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UndefMethodPolymorphicNode
        extends UndefMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            UndefMethodPolymorphicNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyClass.class ? this.arguments[0].executeRubyClass(frameValue) : (this.arguments0PolymorphicType == RubyModule.class ? this.arguments[0].executeRubyModule(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UndefMethodRubyModuleRubySymbolNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            UndefMethodRubyModuleRubySymbolNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.undefMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.undefMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(ModuleNodes.UndefMethodNode current2) {
                return new UndefMethodRubyModuleRubySymbolNode((UndefMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UndefMethodRubyModuleRubyStringNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            UndefMethodRubyModuleRubyStringNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.undefMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.undefMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(ModuleNodes.UndefMethodNode current2) {
                return new UndefMethodRubyModuleRubyStringNode((UndefMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UndefMethodRubyClassRubySymbolNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodRubyClassRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, RubySymbol.class}, 0, 0);

            UndefMethodRubyClassRubySymbolNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.undefMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.undefMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(ModuleNodes.UndefMethodNode current2) {
                return new UndefMethodRubyClassRubySymbolNode((UndefMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UndefMethodRubyClassRubyStringNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodRubyClassRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, RubyString.class}, 0, 0);

            UndefMethodRubyClassRubyStringNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.undefMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.undefMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(ModuleNodes.UndefMethodNode current2) {
                return new UndefMethodRubyClassRubyStringNode((UndefMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UndefMethodUninitializedNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UndefMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UndefMethodUninitializedNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                UndefMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UndefMethodBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UndefMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        private static abstract class UndefMethodBaseNode
        extends ModuleNodes.UndefMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UndefMethodBaseNode next0;

            UndefMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UndefMethodBaseNode(UndefMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                UndefMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UndefMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new UndefMethodUninitializedNode(this);
                    ((UndefMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = UndefMethodBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new UndefMethodUninitializedNode(this), new UndefMethodPolymorphicNode(this), (UndefMethodBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UndefMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (UndefMethodBaseNode)UndefMethodRubyClassRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (UndefMethodBaseNode)UndefMethodRubyClassRubySymbolNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (UndefMethodBaseNode)UndefMethodRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (UndefMethodBaseNode)UndefMethodRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    UndefMethodBaseNode otherCast = (UndefMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (UndefMethodBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
    public static final class RemoveMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveMethodNode> {
        private static RemoveMethodNodeFactory removeMethodNodeFactoryInstance;

        private RemoveMethodNodeFactory() {
            super(ModuleNodes.RemoveMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.RemoveMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RemoveMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.RemoveMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RemoveMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.RemoveMethodNode> getInstance() {
            if (removeMethodNodeFactoryInstance == null) {
                removeMethodNodeFactoryInstance = new RemoveMethodNodeFactory();
            }
            return removeMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RemoveMethodPolymorphicNode
        extends RemoveMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RemoveMethodPolymorphicNode(RemoveMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveMethodRubyModuleRubySymbolNode
        extends RemoveMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveMethodRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            RemoveMethodRubyModuleRubySymbolNode(RemoveMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.removeMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.removeMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveMethodNode create0(ModuleNodes.RemoveMethodNode current2) {
                return new RemoveMethodRubyModuleRubySymbolNode((RemoveMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveMethodRubyModuleRubyStringNode
        extends RemoveMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveMethodRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            RemoveMethodRubyModuleRubyStringNode(RemoveMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.removeMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.removeMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveMethodNode create0(ModuleNodes.RemoveMethodNode current2) {
                return new RemoveMethodRubyModuleRubyStringNode((RemoveMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RemoveMethodUninitializedNode
        extends RemoveMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RemoveMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RemoveMethodUninitializedNode(RemoveMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RemoveMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RemoveMethodBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RemoveMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        private static abstract class RemoveMethodBaseNode
        extends ModuleNodes.RemoveMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RemoveMethodBaseNode next0;

            RemoveMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RemoveMethodBaseNode(RemoveMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                RemoveMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RemoveMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RemoveMethodUninitializedNode(this);
                    ((RemoveMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = RemoveMethodBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new RemoveMethodUninitializedNode(this), new RemoveMethodPolymorphicNode(this), (RemoveMethodBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RemoveMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (RemoveMethodBaseNode)RemoveMethodRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (RemoveMethodBaseNode)RemoveMethodRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RemoveMethodBaseNode otherCast = (RemoveMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RemoveMethodBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
    public static final class RemoveClassVariableNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveClassVariableNode> {
        private static RemoveClassVariableNodeFactory removeClassVariableNodeFactoryInstance;

        private RemoveClassVariableNodeFactory() {
            super(ModuleNodes.RemoveClassVariableNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.RemoveClassVariableNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RemoveClassVariableNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.RemoveClassVariableNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RemoveClassVariableUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.RemoveClassVariableNode> getInstance() {
            if (removeClassVariableNodeFactoryInstance == null) {
                removeClassVariableNodeFactoryInstance = new RemoveClassVariableNodeFactory();
            }
            return removeClassVariableNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RemoveClassVariablePolymorphicNode
        extends RemoveClassVariableBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RemoveClassVariablePolymorphicNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveClassVariableRubyModuleRubySymbolNode
        extends RemoveClassVariableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveClassVariableRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            RemoveClassVariableRubyModuleRubySymbolNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.removeClassVariable(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.removeClassVariable(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveClassVariableNode create0(ModuleNodes.RemoveClassVariableNode current2) {
                return new RemoveClassVariableRubyModuleRubySymbolNode((RemoveClassVariableBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveClassVariableRubyModuleRubyStringNode
        extends RemoveClassVariableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveClassVariableRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            RemoveClassVariableRubyModuleRubyStringNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.removeClassVariable(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.removeClassVariable(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveClassVariableNode create0(ModuleNodes.RemoveClassVariableNode current2) {
                return new RemoveClassVariableRubyModuleRubyStringNode((RemoveClassVariableBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RemoveClassVariableUninitializedNode
        extends RemoveClassVariableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveClassVariableUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RemoveClassVariableUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RemoveClassVariableUninitializedNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RemoveClassVariableBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RemoveClassVariableBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveClassVariableNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RemoveClassVariableUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        private static abstract class RemoveClassVariableBaseNode
        extends ModuleNodes.RemoveClassVariableNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RemoveClassVariableBaseNode next0;

            RemoveClassVariableBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RemoveClassVariableBaseNode(RemoveClassVariableBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                RemoveClassVariableBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RemoveClassVariableBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RemoveClassVariableUninitializedNode(this);
                    ((RemoveClassVariableUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = RemoveClassVariableBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new RemoveClassVariableUninitializedNode(this), new RemoveClassVariablePolymorphicNode(this), (RemoveClassVariableBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RemoveClassVariableBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (RemoveClassVariableBaseNode)RemoveClassVariableRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (RemoveClassVariableBaseNode)RemoveClassVariableRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RemoveClassVariableBaseNode otherCast = (RemoveClassVariableBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RemoveClassVariableBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
    public static final class ProtectedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ProtectedNode> {
        private static ProtectedNodeFactory protectedNodeFactoryInstance;

        private ProtectedNodeFactory() {
            super(ModuleNodes.ProtectedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ProtectedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProtectedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ProtectedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ProtectedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ProtectedNode> getInstance() {
            if (protectedNodeFactoryInstance == null) {
                protectedNodeFactoryInstance = new ProtectedNodeFactory();
            }
            return protectedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ProtectedPolymorphicNode
        extends ProtectedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ProtectedPolymorphicNode(ProtectedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ProtectedRubyModuleNode
        extends ProtectedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            ProtectedRubyModuleNode(ProtectedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.doProtected(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.doProtected(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ProtectedNode create0(ModuleNodes.ProtectedNode current2) {
                return new ProtectedRubyModuleNode((ProtectedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ProtectedUninitializedNode
        extends ProtectedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ProtectedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ProtectedUninitializedNode(ProtectedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ProtectedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ProtectedBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ProtectedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ProtectedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        private static abstract class ProtectedBaseNode
        extends ModuleNodes.ProtectedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ProtectedBaseNode next0;

            ProtectedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ProtectedBaseNode(ProtectedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ProtectedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ProtectedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ProtectedUninitializedNode(this);
                    ((ProtectedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ProtectedBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ProtectedUninitializedNode(this), new ProtectedPolymorphicNode(this), (ProtectedBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ProtectedBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (ProtectedBaseNode)ProtectedRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ProtectedBaseNode otherCast = (ProtectedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ProtectedBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
    public static final class PublicConstantNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicConstantNode> {
        private static PublicConstantNodeFactory publicConstantNodeFactoryInstance;

        private PublicConstantNodeFactory() {
            super(ModuleNodes.PublicConstantNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PublicConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicConstantNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicConstantUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicConstantNode> getInstance() {
            if (publicConstantNodeFactoryInstance == null) {
                publicConstantNodeFactoryInstance = new PublicConstantNodeFactory();
            }
            return publicConstantNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicConstantPolymorphicNode
        extends PublicConstantBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicConstantPolymorphicNode(PublicConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicConstantRubyModuleNode
        extends PublicConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicConstantRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PublicConstantRubyModuleNode(PublicConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.publicConstant(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.publicConstant(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicConstantNode create0(ModuleNodes.PublicConstantNode current2) {
                return new PublicConstantRubyModuleNode((PublicConstantBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicConstantUninitializedNode
        extends PublicConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicConstantUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicConstantUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicConstantUninitializedNode(PublicConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicConstantBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicConstantNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicConstantUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        private static abstract class PublicConstantBaseNode
        extends ModuleNodes.PublicConstantNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicConstantBaseNode next0;

            PublicConstantBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicConstantBaseNode(PublicConstantBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PublicConstantBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicConstantUninitializedNode(this);
                    ((PublicConstantUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PublicConstantBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PublicConstantUninitializedNode(this), new PublicConstantPolymorphicNode(this), (PublicConstantBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicConstantBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PublicConstantBaseNode)PublicConstantRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicConstantBaseNode otherCast = (PublicConstantBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicConstantBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
    public static final class PrivateConstantNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateConstantNode> {
        private static PrivateConstantNodeFactory privateConstantNodeFactoryInstance;

        private PrivateConstantNodeFactory() {
            super(ModuleNodes.PrivateConstantNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrivateConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateConstantNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateConstantUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateConstantNode> getInstance() {
            if (privateConstantNodeFactoryInstance == null) {
                privateConstantNodeFactoryInstance = new PrivateConstantNodeFactory();
            }
            return privateConstantNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateConstantPolymorphicNode
        extends PrivateConstantBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivateConstantPolymorphicNode(PrivateConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateConstantRubyModuleNode
        extends PrivateConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateConstantRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PrivateConstantRubyModuleNode(PrivateConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.privateConstant(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.privateConstant(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateConstantNode create0(ModuleNodes.PrivateConstantNode current2) {
                return new PrivateConstantRubyModuleNode((PrivateConstantBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateConstantUninitializedNode
        extends PrivateConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateConstantUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateConstantUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateConstantUninitializedNode(PrivateConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateConstantBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateConstantNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateConstantUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        private static abstract class PrivateConstantBaseNode
        extends ModuleNodes.PrivateConstantNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateConstantBaseNode next0;

            PrivateConstantBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateConstantBaseNode(PrivateConstantBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PrivateConstantBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateConstantUninitializedNode(this);
                    ((PrivateConstantUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PrivateConstantBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PrivateConstantUninitializedNode(this), new PrivateConstantPolymorphicNode(this), (PrivateConstantBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateConstantBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PrivateConstantBaseNode)PrivateConstantRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateConstantBaseNode otherCast = (PrivateConstantBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateConstantBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
    public static final class InstanceMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.InstanceMethodNode> {
        private static InstanceMethodNodeFactory instanceMethodNodeFactoryInstance;

        private InstanceMethodNodeFactory() {
            super(ModuleNodes.InstanceMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.InstanceMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InstanceMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.InstanceMethodNode> getInstance() {
            if (instanceMethodNodeFactoryInstance == null) {
                instanceMethodNodeFactoryInstance = new InstanceMethodNodeFactory();
            }
            return instanceMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceMethodPolymorphicNode
        extends InstanceMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InstanceMethodPolymorphicNode(InstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value2;
                try {
                    value2 = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceMethodRubyModuleNode
        extends InstanceMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            InstanceMethodRubyModuleNode(InstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value2;
                try {
                    value2 = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.instanceMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.instanceMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodNode create0(ModuleNodes.InstanceMethodNode current2) {
                return new InstanceMethodRubyModuleNode((InstanceMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceMethodUninitializedNode
        extends InstanceMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceMethodUninitializedNode(InstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value2;
                try {
                    value2 = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyUnboundMethod executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InstanceMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceMethodBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        private static abstract class InstanceMethodBaseNode
        extends ModuleNodes.InstanceMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceMethodBaseNode next0;

            InstanceMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceMethodBaseNode(InstanceMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyUnboundMethod executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyUnboundMethod rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InstanceMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InstanceMethodUninitializedNode(this);
                    ((InstanceMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = InstanceMethodBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new InstanceMethodUninitializedNode(this), new InstanceMethodPolymorphicNode(this), (InstanceMethodBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    return (InstanceMethodBaseNode)InstanceMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InstanceMethodBaseNode otherCast = (InstanceMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InstanceMethodBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
    public static final class InstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.InstanceMethodsNode> {
        private static InstanceMethodsNodeFactory instanceMethodsNodeFactoryInstance;

        private InstanceMethodsNodeFactory() {
            super(ModuleNodes.InstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.InstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.InstanceMethodsNode> getInstance() {
            if (instanceMethodsNodeFactoryInstance == null) {
                instanceMethodsNodeFactoryInstance = new InstanceMethodsNodeFactory();
            }
            return instanceMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceMethodsPolymorphicNode
        extends InstanceMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InstanceMethodsPolymorphicNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceMethodsRubyModuleBooleanNode
        extends InstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            InstanceMethodsRubyModuleBooleanNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.instanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.instanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodsNode create0(ModuleNodes.InstanceMethodsNode current2) {
                return new InstanceMethodsRubyModuleBooleanNode((InstanceMethodsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceMethodsRubyModuleUndefinedPlaceholderNode
        extends InstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            InstanceMethodsRubyModuleUndefinedPlaceholderNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.instanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.instanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodsNode create0(ModuleNodes.InstanceMethodsNode current2) {
                return new InstanceMethodsRubyModuleUndefinedPlaceholderNode((InstanceMethodsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceMethodsUninitializedNode
        extends InstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceMethodsUninitializedNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceMethodsBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        private static abstract class InstanceMethodsBaseNode
        extends ModuleNodes.InstanceMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceMethodsBaseNode next0;

            InstanceMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceMethodsBaseNode(InstanceMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InstanceMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InstanceMethodsUninitializedNode(this);
                    ((InstanceMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = InstanceMethodsBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new InstanceMethodsUninitializedNode(this), new InstanceMethodsPolymorphicNode(this), (InstanceMethodsBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (InstanceMethodsBaseNode)InstanceMethodsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (InstanceMethodsBaseNode)InstanceMethodsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InstanceMethodsBaseNode otherCast = (InstanceMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InstanceMethodsBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
    public static final class PublicInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicInstanceMethodsNode> {
        private static PublicInstanceMethodsNodeFactory publicInstanceMethodsNodeFactoryInstance;

        private PublicInstanceMethodsNodeFactory() {
            super(ModuleNodes.PublicInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PublicInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicInstanceMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicInstanceMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicInstanceMethodsNode> getInstance() {
            if (publicInstanceMethodsNodeFactoryInstance == null) {
                publicInstanceMethodsNodeFactoryInstance = new PublicInstanceMethodsNodeFactory();
            }
            return publicInstanceMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicInstanceMethodsPolymorphicNode
        extends PublicInstanceMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicInstanceMethodsPolymorphicNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicInstanceMethodsRubyModuleBooleanNode
        extends PublicInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            PublicInstanceMethodsRubyModuleBooleanNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.publicInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.publicInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicInstanceMethodsNode create0(ModuleNodes.PublicInstanceMethodsNode current2) {
                return new PublicInstanceMethodsRubyModuleBooleanNode((PublicInstanceMethodsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode
        extends PublicInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.publicInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.publicInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicInstanceMethodsNode create0(ModuleNodes.PublicInstanceMethodsNode current2) {
                return new PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode((PublicInstanceMethodsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicInstanceMethodsUninitializedNode
        extends PublicInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicInstanceMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicInstanceMethodsUninitializedNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicInstanceMethodsBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicInstanceMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicInstanceMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        private static abstract class PublicInstanceMethodsBaseNode
        extends ModuleNodes.PublicInstanceMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicInstanceMethodsBaseNode next0;

            PublicInstanceMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicInstanceMethodsBaseNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PublicInstanceMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicInstanceMethodsUninitializedNode(this);
                    ((PublicInstanceMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PublicInstanceMethodsBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PublicInstanceMethodsUninitializedNode(this), new PublicInstanceMethodsPolymorphicNode(this), (PublicInstanceMethodsBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicInstanceMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (PublicInstanceMethodsBaseNode)PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (PublicInstanceMethodsBaseNode)PublicInstanceMethodsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicInstanceMethodsBaseNode otherCast = (PublicInstanceMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicInstanceMethodsBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
    public static final class PrivateInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateInstanceMethodsNode> {
        private static PrivateInstanceMethodsNodeFactory privateInstanceMethodsNodeFactoryInstance;

        private PrivateInstanceMethodsNodeFactory() {
            super(ModuleNodes.PrivateInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrivateInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateInstanceMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateInstanceMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateInstanceMethodsNode> getInstance() {
            if (privateInstanceMethodsNodeFactoryInstance == null) {
                privateInstanceMethodsNodeFactoryInstance = new PrivateInstanceMethodsNodeFactory();
            }
            return privateInstanceMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateInstanceMethodsPolymorphicNode
        extends PrivateInstanceMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivateInstanceMethodsPolymorphicNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateInstanceMethodsRubyModuleBooleanNode
        extends PrivateInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateInstanceMethodsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            PrivateInstanceMethodsRubyModuleBooleanNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.privateInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.privateInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateInstanceMethodsNode create0(ModuleNodes.PrivateInstanceMethodsNode current2) {
                return new PrivateInstanceMethodsRubyModuleBooleanNode((PrivateInstanceMethodsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode
        extends PrivateInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.privateInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.privateInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateInstanceMethodsNode create0(ModuleNodes.PrivateInstanceMethodsNode current2) {
                return new PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode((PrivateInstanceMethodsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateInstanceMethodsUninitializedNode
        extends PrivateInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateInstanceMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateInstanceMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateInstanceMethodsUninitializedNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateInstanceMethodsBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateInstanceMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateInstanceMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        private static abstract class PrivateInstanceMethodsBaseNode
        extends ModuleNodes.PrivateInstanceMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateInstanceMethodsBaseNode next0;

            PrivateInstanceMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateInstanceMethodsBaseNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PrivateInstanceMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateInstanceMethodsUninitializedNode(this);
                    ((PrivateInstanceMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PrivateInstanceMethodsBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PrivateInstanceMethodsUninitializedNode(this), new PrivateInstanceMethodsPolymorphicNode(this), (PrivateInstanceMethodsBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateInstanceMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (PrivateInstanceMethodsBaseNode)PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (PrivateInstanceMethodsBaseNode)PrivateInstanceMethodsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateInstanceMethodsBaseNode otherCast = (PrivateInstanceMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateInstanceMethodsBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
    public static final class PrivateClassMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateClassMethodNode> {
        private static PrivateClassMethodNodeFactory privateClassMethodNodeFactoryInstance;

        private PrivateClassMethodNodeFactory() {
            super(ModuleNodes.PrivateClassMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrivateClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateClassMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateClassMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateClassMethodNode> getInstance() {
            if (privateClassMethodNodeFactoryInstance == null) {
                privateClassMethodNodeFactoryInstance = new PrivateClassMethodNodeFactory();
            }
            return privateClassMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateClassMethodPolymorphicNode
        extends PrivateClassMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivateClassMethodPolymorphicNode(PrivateClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateClassMethodRubyModuleNode
        extends PrivateClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateClassMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PrivateClassMethodRubyModuleNode(PrivateClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.privateClassMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.privateClassMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateClassMethodNode create0(ModuleNodes.PrivateClassMethodNode current2) {
                return new PrivateClassMethodRubyModuleNode((PrivateClassMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateClassMethodUninitializedNode
        extends PrivateClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateClassMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateClassMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateClassMethodUninitializedNode(PrivateClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateClassMethodBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateClassMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateClassMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        private static abstract class PrivateClassMethodBaseNode
        extends ModuleNodes.PrivateClassMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateClassMethodBaseNode next0;

            PrivateClassMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateClassMethodBaseNode(PrivateClassMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PrivateClassMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateClassMethodUninitializedNode(this);
                    ((PrivateClassMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PrivateClassMethodBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PrivateClassMethodUninitializedNode(this), new PrivateClassMethodPolymorphicNode(this), (PrivateClassMethodBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateClassMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PrivateClassMethodBaseNode)PrivateClassMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateClassMethodBaseNode otherCast = (PrivateClassMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateClassMethodBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateNode.class)
    public static final class PrivateNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateNode> {
        private static PrivateNodeFactory privateNodeFactoryInstance;

        private PrivateNodeFactory() {
            super(ModuleNodes.PrivateNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrivateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateNode> getInstance() {
            if (privateNodeFactoryInstance == null) {
                privateNodeFactoryInstance = new PrivateNodeFactory();
            }
            return privateNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivatePolymorphicNode
        extends PrivateBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivatePolymorphicNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePrivate(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateRubyModuleNode
        extends PrivateBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PrivateRubyModuleNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.doPrivate(arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePrivate(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return super.doPrivate(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.doPrivate(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateNode create0(ModuleNodes.PrivateNode current2) {
                return new PrivateRubyModuleNode((PrivateBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateUninitializedNode
        extends PrivateBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateUninitializedNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePrivate(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        private static abstract class PrivateBaseNode
        extends ModuleNodes.PrivateNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateBaseNode next0;

            PrivateBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateBaseNode(PrivateBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PrivateBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateUninitializedNode(this);
                    ((PrivateUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PrivateBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PrivateUninitializedNode(this), new PrivatePolymorphicNode(this), (PrivateBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PrivateBaseNode)PrivateRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateBaseNode otherCast = (PrivateBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
    public static final class PublicClassMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicClassMethodNode> {
        private static PublicClassMethodNodeFactory publicClassMethodNodeFactoryInstance;

        private PublicClassMethodNodeFactory() {
            super(ModuleNodes.PublicClassMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PublicClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicClassMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicClassMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicClassMethodNode> getInstance() {
            if (publicClassMethodNodeFactoryInstance == null) {
                publicClassMethodNodeFactoryInstance = new PublicClassMethodNodeFactory();
            }
            return publicClassMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicClassMethodPolymorphicNode
        extends PublicClassMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicClassMethodPolymorphicNode(PublicClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicClassMethodRubyModuleNode
        extends PublicClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicClassMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PublicClassMethodRubyModuleNode(PublicClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.publicClassMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.publicClassMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicClassMethodNode create0(ModuleNodes.PublicClassMethodNode current2) {
                return new PublicClassMethodRubyModuleNode((PublicClassMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicClassMethodUninitializedNode
        extends PublicClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicClassMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicClassMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicClassMethodUninitializedNode(PublicClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicClassMethodBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicClassMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicClassMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        private static abstract class PublicClassMethodBaseNode
        extends ModuleNodes.PublicClassMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicClassMethodBaseNode next0;

            PublicClassMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicClassMethodBaseNode(PublicClassMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PublicClassMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicClassMethodUninitializedNode(this);
                    ((PublicClassMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PublicClassMethodBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PublicClassMethodUninitializedNode(this), new PublicClassMethodPolymorphicNode(this), (PublicClassMethodBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicClassMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PublicClassMethodBaseNode)PublicClassMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicClassMethodBaseNode otherCast = (PublicClassMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicClassMethodBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicNode.class)
    public static final class PublicNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicNode> {
        private static PublicNodeFactory publicNodeFactoryInstance;

        private PublicNodeFactory() {
            super(ModuleNodes.PublicNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PublicNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicNode> getInstance() {
            if (publicNodeFactoryInstance == null) {
                publicNodeFactoryInstance = new PublicNodeFactory();
            }
            return publicNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicPolymorphicNode
        extends PublicBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicPolymorphicNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePublic(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicRubyModuleNode
        extends PublicBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PublicRubyModuleNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.doPublic(arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePublic(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return super.doPublic(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.doPublic(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicNode create0(ModuleNodes.PublicNode current2) {
                return new PublicRubyModuleNode((PublicBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicUninitializedNode
        extends PublicBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicUninitializedNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePublic(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        private static abstract class PublicBaseNode
        extends ModuleNodes.PublicNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicBaseNode next0;

            PublicBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicBaseNode(PublicBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PublicBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicUninitializedNode(this);
                    ((PublicUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = PublicBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new PublicUninitializedNode(this), new PublicPolymorphicNode(this), (PublicBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PublicBaseNode)PublicRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicBaseNode otherCast = (PublicBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.NestingNode.class)
    public static final class NestingNodeFactory
    extends NodeFactoryBase<ModuleNodes.NestingNode> {
        private static NestingNodeFactory nestingNodeFactoryInstance;

        private NestingNodeFactory() {
            super(ModuleNodes.NestingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.NestingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NestingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.NestingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NestingDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.NestingNode> getInstance() {
            if (nestingNodeFactoryInstance == null) {
                nestingNodeFactoryInstance = new NestingNodeFactory();
            }
            return nestingNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.NestingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NestingDefaultNode
        extends NestingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NestingDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            NestingDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.nesting();
            }

            static ModuleNodes.NestingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NestingDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.NestingNode.class)
        private static abstract class NestingBaseNode
        extends ModuleNodes.NestingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            NestingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.NameNode.class)
    public static final class NameNodeFactory
    extends NodeFactoryBase<ModuleNodes.NameNode> {
        private static NameNodeFactory nameNodeFactoryInstance;

        private NameNodeFactory() {
            super(ModuleNodes.NameNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.NameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NameNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.NameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NameUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.NameNode> getInstance() {
            if (nameNodeFactoryInstance == null) {
                nameNodeFactoryInstance = new NameNodeFactory();
            }
            return nameNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NamePolymorphicNode
        extends NameBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NamePolymorphicNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NameRubyModuleNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            NameRubyModuleNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.name(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.name(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.NameNode create0(ModuleNodes.NameNode current2) {
                return new NameRubyModuleNode((NameBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NameUninitializedNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NameUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NameUninitializedNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NameBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.NameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NameUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        private static abstract class NameBaseNode
        extends ModuleNodes.NameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NameBaseNode next0;

            NameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NameBaseNode(NameBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                NameBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NameUninitializedNode(this);
                    ((NameUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = NameBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new NameUninitializedNode(this), new NamePolymorphicNode(this), (NameBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NameBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (NameBaseNode)NameRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NameBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NameBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
    public static final class ModuleFunctionNodeFactory
    extends NodeFactoryBase<ModuleNodes.ModuleFunctionNode> {
        private static ModuleFunctionNodeFactory moduleFunctionNodeFactoryInstance;

        private ModuleFunctionNodeFactory() {
            super(ModuleNodes.ModuleFunctionNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ModuleFunctionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModuleFunctionNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ModuleFunctionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ModuleFunctionUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ModuleFunctionNode> getInstance() {
            if (moduleFunctionNodeFactoryInstance == null) {
                moduleFunctionNodeFactoryInstance = new ModuleFunctionNodeFactory();
            }
            return moduleFunctionNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ModuleFunctionPolymorphicNode
        extends ModuleFunctionBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ModuleFunctionPolymorphicNode(ModuleFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModuleFunctionRubyModuleNode
        extends ModuleFunctionBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModuleFunctionRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            ModuleFunctionRubyModuleNode(ModuleFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.moduleFunction(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.moduleFunction(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ModuleFunctionNode create0(ModuleNodes.ModuleFunctionNode current2) {
                return new ModuleFunctionRubyModuleNode((ModuleFunctionBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ModuleFunctionUninitializedNode
        extends ModuleFunctionBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModuleFunctionUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ModuleFunctionUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ModuleFunctionUninitializedNode(ModuleFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ModuleFunctionBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ModuleFunctionBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ModuleFunctionNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ModuleFunctionUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        private static abstract class ModuleFunctionBaseNode
        extends ModuleNodes.ModuleFunctionNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ModuleFunctionBaseNode next0;

            ModuleFunctionBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ModuleFunctionBaseNode(ModuleFunctionBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ModuleFunctionBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ModuleFunctionBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ModuleFunctionUninitializedNode(this);
                    ((ModuleFunctionUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ModuleFunctionBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ModuleFunctionUninitializedNode(this), new ModuleFunctionPolymorphicNode(this), (ModuleFunctionBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ModuleFunctionBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (ModuleFunctionBaseNode)ModuleFunctionRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ModuleFunctionBaseNode otherCast = (ModuleFunctionBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ModuleFunctionBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
    public static final class MethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.MethodDefinedNode> {
        private static MethodDefinedNodeFactory methodDefinedNodeFactoryInstance;

        private MethodDefinedNodeFactory() {
            super(ModuleNodes.MethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.MethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.MethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MethodDefinedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.MethodDefinedNode> getInstance() {
            if (methodDefinedNodeFactoryInstance == null) {
                methodDefinedNodeFactoryInstance = new MethodDefinedNodeFactory();
            }
            return methodDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MethodDefinedPolymorphicNode
        extends MethodDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            MethodDefinedPolymorphicNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[2].executeBoolean(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodDefinedRubyModuleRubySymbolUndefinedPlaceholderNode
        extends MethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodDefinedRubyModuleRubySymbolUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, UndefinedPlaceholder.class}, 0, 0);

            MethodDefinedRubyModuleRubySymbolUndefinedPlaceholderNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.isMethodDefined(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.isMethodDefined(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.MethodDefinedNode create0(ModuleNodes.MethodDefinedNode current2) {
                return new MethodDefinedRubyModuleRubySymbolUndefinedPlaceholderNode((MethodDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodDefinedRubyModuleRubyStringBooleanNode
        extends MethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodDefinedRubyModuleRubyStringBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, Boolean.TYPE}, 0, 0);

            MethodDefinedRubyModuleRubyStringBooleanNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof boolean");
                }
                return super.isMethodDefined(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    boolean arguments2ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments2Value);
                    return super.isMethodDefined(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.MethodDefinedNode create0(ModuleNodes.MethodDefinedNode current2) {
                return new MethodDefinedRubyModuleRubyStringBooleanNode((MethodDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodDefinedRubyModuleRubyStringUndefinedPlaceholderNode
        extends MethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodDefinedRubyModuleRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            MethodDefinedRubyModuleRubyStringUndefinedPlaceholderNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.isMethodDefined(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.isMethodDefined(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.MethodDefinedNode create0(ModuleNodes.MethodDefinedNode current2) {
                return new MethodDefinedRubyModuleRubyStringUndefinedPlaceholderNode((MethodDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MethodDefinedUninitializedNode
        extends MethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MethodDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MethodDefinedUninitializedNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                MethodDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MethodDefinedBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.MethodDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MethodDefinedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        private static abstract class MethodDefinedBaseNode
        extends ModuleNodes.MethodDefinedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MethodDefinedBaseNode next0;

            MethodDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MethodDefinedBaseNode(MethodDefinedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                MethodDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MethodDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new MethodDefinedUninitializedNode(this);
                    ((MethodDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = MethodDefinedBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new MethodDefinedUninitializedNode(this), new MethodDefinedPolymorphicNode(this), (MethodDefinedBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MethodDefinedBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (MethodDefinedBaseNode)MethodDefinedRubyModuleRubyStringUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                            return (MethodDefinedBaseNode)MethodDefinedRubyModuleRubyStringBooleanNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (MethodDefinedBaseNode)MethodDefinedRubyModuleRubySymbolUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    MethodDefinedBaseNode otherCast = (MethodDefinedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (MethodDefinedBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IncludePNode.class)
    public static final class IncludePNodeFactory
    extends NodeFactoryBase<ModuleNodes.IncludePNode> {
        private static IncludePNodeFactory includePNodeFactoryInstance;

        private IncludePNodeFactory() {
            super(ModuleNodes.IncludePNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IncludePNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludePNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IncludePNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IncludePUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IncludePNode> getInstance() {
            if (includePNodeFactoryInstance == null) {
                includePNodeFactoryInstance = new IncludePNodeFactory();
            }
            return includePNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IncludePNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IncludePPolymorphicNode
        extends IncludePBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IncludePPolymorphicNode(IncludePBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludePNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludePRubyModuleNode
        extends IncludePBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludePRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            IncludePRubyModuleNode(IncludePBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.include(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.include(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IncludePNode create0(ModuleNodes.IncludePNode current2) {
                return new IncludePRubyModuleNode((IncludePBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludePNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IncludePUninitializedNode
        extends IncludePBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludePUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IncludePUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IncludePUninitializedNode(IncludePBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IncludePBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IncludePBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IncludePNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IncludePUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludePNode.class)
        private static abstract class IncludePBaseNode
        extends ModuleNodes.IncludePNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IncludePBaseNode next0;

            IncludePBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IncludePBaseNode(IncludePBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                IncludePBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IncludePBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IncludePUninitializedNode(this);
                    ((IncludePUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = IncludePBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new IncludePUninitializedNode(this), new IncludePPolymorphicNode(this), (IncludePBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IncludePBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    return (IncludePBaseNode)IncludePRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IncludePBaseNode otherCast = (IncludePBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IncludePBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IncludeNode.class)
    public static final class IncludeNodeFactory
    extends NodeFactoryBase<ModuleNodes.IncludeNode> {
        private static IncludeNodeFactory includeNodeFactoryInstance;

        private IncludeNodeFactory() {
            super(ModuleNodes.IncludeNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IncludeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IncludeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IncludeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IncludeNode> getInstance() {
            if (includeNodeFactoryInstance == null) {
                includeNodeFactoryInstance = new IncludeNodeFactory();
            }
            return includeNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IncludePolymorphicNode
        extends IncludeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IncludePolymorphicNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyModuleNode
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            IncludeRubyModuleNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.include(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.include(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IncludeNode create0(ModuleNodes.IncludeNode current2) {
                return new IncludeRubyModuleNode((IncludeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IncludeUninitializedNode
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IncludeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IncludeUninitializedNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IncludeBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IncludeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IncludeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludeNode.class)
        private static abstract class IncludeBaseNode
        extends ModuleNodes.IncludeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IncludeBaseNode next0;

            IncludeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IncludeBaseNode(IncludeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                IncludeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IncludeUninitializedNode(this);
                    ((IncludeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = IncludeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new IncludeUninitializedNode(this), new IncludePolymorphicNode(this), (IncludeBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IncludeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (IncludeBaseNode)IncludeRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IncludeBaseNode otherCast = (IncludeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IncludeBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<ModuleNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(ModuleNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyModuleNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            InitializeCopyRubyModuleNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.initializeCopy(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.initializeCopy(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeCopyNode create0(ModuleNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyModuleNode((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends ModuleNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = InitializeCopyBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new InitializeCopyUninitializedNode(this), new InitializeCopyPolymorphicNode(this), (InitializeCopyBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    return (InitializeCopyBaseNode)InitializeCopyRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ModuleNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ModuleNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                Object arguments1Value;
                RubyModule arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated) : (this.arguments1PolymorphicType == RubyProc.class ? arguments1ValueEvaluated : arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyModuleRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyModuleRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyProc.class}, 0, 0);

            InitializeRubyModuleRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.initialize(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyProc arguments1Value = arguments1ValueEvaluated;
                return super.initialize(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.initialize(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeNode create0(ModuleNodes.InitializeNode current2) {
                return new InitializeRubyModuleRubyProcNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyModuleUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyModuleUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeNode create0(ModuleNodes.InitializeNode current2) {
                return new InitializeRubyModuleUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyProc arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends ModuleNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = InitializeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new InitializeUninitializedNode(this), new InitializePolymorphicNode(this), (InitializeBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyModuleRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
    public static final class DefineMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.DefineMethodNode> {
        private static DefineMethodNodeFactory defineMethodNodeFactoryInstance;

        private DefineMethodNodeFactory() {
            super(ModuleNodes.DefineMethodNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.DefineMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefineMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.DefineMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DefineMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.DefineMethodNode> getInstance() {
            if (defineMethodNodeFactoryInstance == null) {
                defineMethodNodeFactoryInstance = new DefineMethodNodeFactory();
            }
            return defineMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DefineMethodPolymorphicNode
        extends DefineMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            DefineMethodPolymorphicNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments3Value;
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, arguments3Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : (this.arguments2PolymorphicType == RubyMethod.class ? this.arguments[2].executeRubyMethod(frameValue) : this.arguments[2].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3);
                }
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == RubyProc.class ? this.arguments[3].executeRubyProc(frameValue) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubySymbolRubyMethodUndefinedPlaceholderNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubySymbolRubyMethodUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, RubyMethod.class, UndefinedPlaceholder.class}, 0, 0);

            DefineMethodRubyModuleRubySymbolRubyMethodUndefinedPlaceholderNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyMethod arguments2Value;
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyMethod");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.defineMethod(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyMethod(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    RubyMethod arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.defineMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current2) {
                return new DefineMethodRubyModuleRubySymbolRubyMethodUndefinedPlaceholderNode((DefineMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubySymbolRubyProcUndefinedPlaceholderNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubySymbolRubyProcUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, RubyProc.class, UndefinedPlaceholder.class}, 0, 0);

            DefineMethodRubyModuleRubySymbolRubyProcUndefinedPlaceholderNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyProc arguments2Value;
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyProc");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.defineMethod(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.defineMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current2) {
                return new DefineMethodRubyModuleRubySymbolRubyProcUndefinedPlaceholderNode((DefineMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubySymbolUndefinedPlaceholderRubyProcNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubySymbolUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            DefineMethodRubyModuleRubySymbolUndefinedPlaceholderRubyProcNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.defineMethod(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.defineMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current2) {
                return new DefineMethodRubyModuleRubySymbolUndefinedPlaceholderRubyProcNode((DefineMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubyStringRubyProcUndefinedPlaceholderNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubyStringRubyProcUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, RubyProc.class, UndefinedPlaceholder.class}, 0, 0);

            DefineMethodRubyModuleRubyStringRubyProcUndefinedPlaceholderNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyProc arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyProc");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.defineMethod(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.defineMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current2) {
                return new DefineMethodRubyModuleRubyStringRubyProcUndefinedPlaceholderNode((DefineMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubyStringUndefinedPlaceholderRubyProcNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubyStringUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            DefineMethodRubyModuleRubyStringUndefinedPlaceholderRubyProcNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.defineMethod(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.defineMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current2) {
                return new DefineMethodRubyModuleRubyStringUndefinedPlaceholderRubyProcNode((DefineMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DefineMethodUninitializedNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DefineMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DefineMethodUninitializedNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                DefineMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DefineMethodBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ModuleNodes.DefineMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DefineMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        private static abstract class DefineMethodBaseNode
        extends ModuleNodes.DefineMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DefineMethodBaseNode next0;

            DefineMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DefineMethodBaseNode(DefineMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason2) {
                String message2;
                DefineMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DefineMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new DefineMethodUninitializedNode(this);
                    ((DefineMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = DefineMethodBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value, arguments3Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new DefineMethodUninitializedNode(this), new DefineMethodPolymorphicNode(this), (DefineMethodBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DefineMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleRubyStringUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleRubyStringRubyProcUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleRubySymbolUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                                return (DefineMethodBaseNode)DefineMethodRubyModuleRubySymbolRubyProcUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments2Value)) {
                                return (DefineMethodBaseNode)DefineMethodRubyModuleRubySymbolRubyMethodUndefinedPlaceholderNode.create0(this);
                            }
                        }
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    DefineMethodBaseNode otherCast = (DefineMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (DefineMethodBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
    public static final class ConstSetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstSetNode> {
        private static ConstSetNodeFactory constSetNodeFactoryInstance;

        private ConstSetNodeFactory() {
            super(ModuleNodes.ConstSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ConstSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstSetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstSetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ConstSetNode> getInstance() {
            if (constSetNodeFactoryInstance == null) {
                constSetNodeFactoryInstance = new ConstSetNodeFactory();
            }
            return constSetNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstSetPolymorphicNode
        extends ConstSetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            ConstSetPolymorphicNode(ConstSetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value);
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstSetRubyModuleRubySymbolNode
        extends ConstSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstSetRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, Object.class}, 0, 0);

            ConstSetRubyModuleRubySymbolNode(ConstSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubySymbol");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return super.setConstant(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.setConstant(arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ConstSetNode create0(ModuleNodes.ConstSetNode current2) {
                return new ConstSetRubyModuleRubySymbolNode((ConstSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstSetRubyModuleRubyStringNode
        extends ConstSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstSetRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, Object.class}, 0, 0);

            ConstSetRubyModuleRubyStringNode(ConstSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubyString");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return super.setConstant(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.setConstant(arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ConstSetNode create0(ModuleNodes.ConstSetNode current2) {
                return new ConstSetRubyModuleRubyStringNode((ConstSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstSetUninitializedNode
        extends ConstSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstSetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstSetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstSetUninitializedNode(ConstSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                ConstSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstSetBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ConstSetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstSetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        private static abstract class ConstSetBaseNode
        extends ModuleNodes.ConstSetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstSetBaseNode next0;

            ConstSetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstSetBaseNode(ConstSetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                ConstSetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new ConstSetUninitializedNode(this);
                    ((ConstSetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ConstSetBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ConstSetUninitializedNode(this), new ConstSetPolymorphicNode(this), (ConstSetBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstSetBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ConstSetBaseNode)ConstSetRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (ConstSetBaseNode)ConstSetRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    ConstSetBaseNode otherCast = (ConstSetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (ConstSetBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
    public static final class ConstMissingNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstMissingNode> {
        private static ConstMissingNodeFactory constMissingNodeFactoryInstance;

        private ConstMissingNodeFactory() {
            super(ModuleNodes.ConstMissingNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ConstMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstMissingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstMissingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ConstMissingNode> getInstance() {
            if (constMissingNodeFactoryInstance == null) {
                constMissingNodeFactoryInstance = new ConstMissingNodeFactory();
            }
            return constMissingNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstMissingPolymorphicNode
        extends ConstMissingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConstMissingPolymorphicNode(ConstMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstMissingRubyModuleNode
        extends ConstMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstMissingRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            ConstMissingRubyModuleNode(ConstMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.methodMissing(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.methodMissing(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstMissingNode create0(ModuleNodes.ConstMissingNode current2) {
                return new ConstMissingRubyModuleNode((ConstMissingBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstMissingUninitializedNode
        extends ConstMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstMissingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstMissingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstMissingUninitializedNode(ConstMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConstMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstMissingBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstMissingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstMissingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        private static abstract class ConstMissingBaseNode
        extends ModuleNodes.ConstMissingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstMissingBaseNode next0;

            ConstMissingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstMissingBaseNode(ConstMissingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ConstMissingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConstMissingUninitializedNode(this);
                    ((ConstMissingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ConstMissingBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ConstMissingUninitializedNode(this), new ConstMissingPolymorphicNode(this), (ConstMissingBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstMissingBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    return (ConstMissingBaseNode)ConstMissingRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConstMissingBaseNode otherCast = (ConstMissingBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConstMissingBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
    public static final class ConstGetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstGetNode> {
        private static ConstGetNodeFactory constGetNodeFactoryInstance;

        private ConstGetNodeFactory() {
            super(ModuleNodes.ConstGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ConstGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstGetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstGetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstGetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ConstGetNode> getInstance() {
            if (constGetNodeFactoryInstance == null) {
                constGetNodeFactoryInstance = new ConstGetNodeFactory();
            }
            return constGetNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstGetPolymorphicNode
        extends ConstGetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConstGetPolymorphicNode(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstGetRubyModuleRubySymbolNode
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            ConstGetRubyModuleRubySymbolNode(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.getConstant(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.getConstant(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstGetNode create0(ModuleNodes.ConstGetNode current2) {
                return new ConstGetRubyModuleRubySymbolNode((ConstGetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstGetRubyModuleRubyStringNode
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            ConstGetRubyModuleRubyStringNode(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.getConstant(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.getConstant(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstGetNode create0(ModuleNodes.ConstGetNode current2) {
                return new ConstGetRubyModuleRubyStringNode((ConstGetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstGetUninitializedNode
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstGetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstGetUninitializedNode(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConstGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstGetBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstGetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstGetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        private static abstract class ConstGetBaseNode
        extends ModuleNodes.ConstGetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstGetBaseNode next0;

            ConstGetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstGetBaseNode(ConstGetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ConstGetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConstGetUninitializedNode(this);
                    ((ConstGetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ConstGetBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ConstGetUninitializedNode(this), new ConstGetPolymorphicNode(this), (ConstGetBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstGetBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ConstGetBaseNode)ConstGetRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (ConstGetBaseNode)ConstGetRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConstGetBaseNode otherCast = (ConstGetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConstGetBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
    public static final class ConstDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstDefinedNode> {
        private static ConstDefinedNodeFactory constDefinedNodeFactoryInstance;

        private ConstDefinedNodeFactory() {
            super(ModuleNodes.ConstDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ConstDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstDefinedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ConstDefinedNode> getInstance() {
            if (constDefinedNodeFactoryInstance == null) {
                constDefinedNodeFactoryInstance = new ConstDefinedNodeFactory();
            }
            return constDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstDefinedPolymorphicNode
        extends ConstDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            ConstDefinedPolymorphicNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[2].executeBoolean(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstDefinedRubyModuleRubySymbolUndefinedPlaceholderNode
        extends ConstDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstDefinedRubyModuleRubySymbolUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, UndefinedPlaceholder.class}, 0, 0);

            ConstDefinedRubyModuleRubySymbolUndefinedPlaceholderNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.isConstDefined(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.isConstDefined(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ConstDefinedNode create0(ModuleNodes.ConstDefinedNode current2) {
                return new ConstDefinedRubyModuleRubySymbolUndefinedPlaceholderNode((ConstDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstDefinedRubyModuleRubyStringBooleanNode
        extends ConstDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstDefinedRubyModuleRubyStringBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, Boolean.TYPE}, 0, 0);

            ConstDefinedRubyModuleRubyStringBooleanNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof boolean");
                }
                return super.isConstDefined(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    boolean arguments2ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments2Value);
                    return super.isConstDefined(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ConstDefinedNode create0(ModuleNodes.ConstDefinedNode current2) {
                return new ConstDefinedRubyModuleRubyStringBooleanNode((ConstDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstDefinedRubyModuleRubyStringUndefinedPlaceholderNode
        extends ConstDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstDefinedRubyModuleRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            ConstDefinedRubyModuleRubyStringUndefinedPlaceholderNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.isConstDefined(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.isConstDefined(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ConstDefinedNode create0(ModuleNodes.ConstDefinedNode current2) {
                return new ConstDefinedRubyModuleRubyStringUndefinedPlaceholderNode((ConstDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstDefinedUninitializedNode
        extends ConstDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstDefinedUninitializedNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                ConstDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstDefinedBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ConstDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstDefinedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        private static abstract class ConstDefinedBaseNode
        extends ModuleNodes.ConstDefinedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstDefinedBaseNode next0;

            ConstDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstDefinedBaseNode(ConstDefinedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                ConstDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new ConstDefinedUninitializedNode(this);
                    ((ConstDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ConstDefinedBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ConstDefinedUninitializedNode(this), new ConstDefinedPolymorphicNode(this), (ConstDefinedBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstDefinedBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (ConstDefinedBaseNode)ConstDefinedRubyModuleRubyStringUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                            return (ConstDefinedBaseNode)ConstDefinedRubyModuleRubyStringBooleanNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (ConstDefinedBaseNode)ConstDefinedRubyModuleRubySymbolUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    ConstDefinedBaseNode otherCast = (ConstDefinedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (ConstDefinedBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
    public static final class ConstantsNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstantsNode> {
        private static ConstantsNodeFactory constantsNodeFactoryInstance;

        private ConstantsNodeFactory() {
            super(ModuleNodes.ConstantsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ConstantsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstantsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstantsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstantsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ConstantsNode> getInstance() {
            if (constantsNodeFactoryInstance == null) {
                constantsNodeFactoryInstance = new ConstantsNodeFactory();
            }
            return constantsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstantsPolymorphicNode
        extends ConstantsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConstantsPolymorphicNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstantsRubyModuleBooleanNode
        extends ConstantsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstantsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            ConstantsRubyModuleBooleanNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.constants(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.constants(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstantsNode create0(ModuleNodes.ConstantsNode current2) {
                return new ConstantsRubyModuleBooleanNode((ConstantsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstantsRubyModuleUndefinedPlaceholderNode
        extends ConstantsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstantsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            ConstantsRubyModuleUndefinedPlaceholderNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.constants(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.constants(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstantsNode create0(ModuleNodes.ConstantsNode current2) {
                return new ConstantsRubyModuleUndefinedPlaceholderNode((ConstantsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstantsUninitializedNode
        extends ConstantsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstantsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstantsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstantsUninitializedNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConstantsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstantsBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstantsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstantsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        private static abstract class ConstantsBaseNode
        extends ModuleNodes.ConstantsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstantsBaseNode next0;

            ConstantsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstantsBaseNode(ConstantsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ConstantsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstantsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConstantsUninitializedNode(this);
                    ((ConstantsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ConstantsBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ConstantsUninitializedNode(this), new ConstantsPolymorphicNode(this), (ConstantsBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstantsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (ConstantsBaseNode)ConstantsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (ConstantsBaseNode)ConstantsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConstantsBaseNode otherCast = (ConstantsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConstantsBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
    public static final class ClassVariablesNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariablesNode> {
        private static ClassVariablesNodeFactory classVariablesNodeFactoryInstance;

        private ClassVariablesNodeFactory() {
            super(ModuleNodes.ClassVariablesNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassVariablesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassVariablesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassVariablesNode> getInstance() {
            if (classVariablesNodeFactoryInstance == null) {
                classVariablesNodeFactoryInstance = new ClassVariablesNodeFactory();
            }
            return classVariablesNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassVariablesPolymorphicNode
        extends ClassVariablesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClassVariablesPolymorphicNode(ClassVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariablesRubyModuleNode
        extends ClassVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariablesRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            ClassVariablesRubyModuleNode(ClassVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.getClassVariables(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.getClassVariables(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.ClassVariablesNode create0(ModuleNodes.ClassVariablesNode current2) {
                return new ClassVariablesRubyModuleNode((ClassVariablesBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassVariablesUninitializedNode
        extends ClassVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariablesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassVariablesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassVariablesUninitializedNode(ClassVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ClassVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassVariablesBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.ClassVariablesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassVariablesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        private static abstract class ClassVariablesBaseNode
        extends ModuleNodes.ClassVariablesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassVariablesBaseNode next0;

            ClassVariablesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassVariablesBaseNode(ClassVariablesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ClassVariablesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ClassVariablesUninitializedNode(this);
                    ((ClassVariablesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ClassVariablesBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ClassVariablesUninitializedNode(this), new ClassVariablesPolymorphicNode(this), (ClassVariablesBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassVariablesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (ClassVariablesBaseNode)ClassVariablesRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ClassVariablesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ClassVariablesBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
    public static final class ClassVariableGetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariableGetNode> {
        private static ClassVariableGetNodeFactory classVariableGetNodeFactoryInstance;

        private ClassVariableGetNodeFactory() {
            super(ModuleNodes.ClassVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassVariableGetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassVariableGetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassVariableGetNode> getInstance() {
            if (classVariableGetNodeFactoryInstance == null) {
                classVariableGetNodeFactoryInstance = new ClassVariableGetNodeFactory();
            }
            return classVariableGetNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassVariableGetPolymorphicNode
        extends ClassVariableGetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ClassVariableGetPolymorphicNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariableGetRubyModuleRubySymbolNode
        extends ClassVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableGetRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            ClassVariableGetRubyModuleRubySymbolNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.getClassVariable(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.getClassVariable(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableGetNode create0(ModuleNodes.ClassVariableGetNode current2) {
                return new ClassVariableGetRubyModuleRubySymbolNode((ClassVariableGetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariableGetRubyModuleRubyStringNode
        extends ClassVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableGetRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            ClassVariableGetRubyModuleRubyStringNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.getClassVariable(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.getClassVariable(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableGetNode create0(ModuleNodes.ClassVariableGetNode current2) {
                return new ClassVariableGetRubyModuleRubyStringNode((ClassVariableGetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassVariableGetUninitializedNode
        extends ClassVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableGetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassVariableGetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassVariableGetUninitializedNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ClassVariableGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassVariableGetBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableGetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassVariableGetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        private static abstract class ClassVariableGetBaseNode
        extends ModuleNodes.ClassVariableGetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassVariableGetBaseNode next0;

            ClassVariableGetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassVariableGetBaseNode(ClassVariableGetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ClassVariableGetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassVariableGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ClassVariableGetUninitializedNode(this);
                    ((ClassVariableGetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ClassVariableGetBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ClassVariableGetUninitializedNode(this), new ClassVariableGetPolymorphicNode(this), (ClassVariableGetBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassVariableGetBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ClassVariableGetBaseNode)ClassVariableGetRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (ClassVariableGetBaseNode)ClassVariableGetRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ClassVariableGetBaseNode otherCast = (ClassVariableGetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ClassVariableGetBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
    public static final class ClassVariableDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariableDefinedNode> {
        private static ClassVariableDefinedNodeFactory classVariableDefinedNodeFactoryInstance;

        private ClassVariableDefinedNodeFactory() {
            super(ModuleNodes.ClassVariableDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassVariableDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassVariableDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassVariableDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassVariableDefinedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassVariableDefinedNode> getInstance() {
            if (classVariableDefinedNodeFactoryInstance == null) {
                classVariableDefinedNodeFactoryInstance = new ClassVariableDefinedNodeFactory();
            }
            return classVariableDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassVariableDefinedPolymorphicNode
        extends ClassVariableDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ClassVariableDefinedPolymorphicNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariableDefinedRubyModuleRubySymbolNode
        extends ClassVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableDefinedRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            ClassVariableDefinedRubyModuleRubySymbolNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.isClassVariableDefined(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.isClassVariableDefined(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableDefinedNode create0(ModuleNodes.ClassVariableDefinedNode current2) {
                return new ClassVariableDefinedRubyModuleRubySymbolNode((ClassVariableDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariableDefinedRubyModuleRubyStringNode
        extends ClassVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableDefinedRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            ClassVariableDefinedRubyModuleRubyStringNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.isClassVariableDefined(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.isClassVariableDefined(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableDefinedNode create0(ModuleNodes.ClassVariableDefinedNode current2) {
                return new ClassVariableDefinedRubyModuleRubyStringNode((ClassVariableDefinedBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassVariableDefinedUninitializedNode
        extends ClassVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassVariableDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassVariableDefinedUninitializedNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ClassVariableDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassVariableDefinedBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassVariableDefinedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        private static abstract class ClassVariableDefinedBaseNode
        extends ModuleNodes.ClassVariableDefinedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassVariableDefinedBaseNode next0;

            ClassVariableDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassVariableDefinedBaseNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ClassVariableDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassVariableDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ClassVariableDefinedUninitializedNode(this);
                    ((ClassVariableDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ClassVariableDefinedBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ClassVariableDefinedUninitializedNode(this), new ClassVariableDefinedPolymorphicNode(this), (ClassVariableDefinedBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassVariableDefinedBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ClassVariableDefinedBaseNode)ClassVariableDefinedRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (ClassVariableDefinedBaseNode)ClassVariableDefinedRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ClassVariableDefinedBaseNode otherCast = (ClassVariableDefinedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ClassVariableDefinedBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
    public static final class ClassExecNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassExecNode> {
        private static ClassExecNodeFactory classExecNodeFactoryInstance;

        private ClassExecNodeFactory() {
            super(ModuleNodes.ClassExecNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassExecNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassExecUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassExecNode> getInstance() {
            if (classExecNodeFactoryInstance == null) {
                classExecNodeFactoryInstance = new ClassExecNodeFactory();
            }
            return classExecNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassExecPolymorphicNode
        extends ClassExecBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            ClassExecPolymorphicNode(ClassExecBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object executeClassEval(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated, RubyProc arguments2ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                RubyProc arguments2Value = arguments2ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassExecRubyModuleRubyProcNode
        extends ClassExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassExecRubyModuleRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class, RubyProc.class}, 0, 0);

            ClassExecRubyModuleRubyProcNode(ClassExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.classExec(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object executeClassEval(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated, RubyProc arguments2ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                RubyProc arguments2Value = arguments2ValueEvaluated;
                return super.classExec(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.classExec(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ClassExecNode create0(ModuleNodes.ClassExecNode current2) {
                return new ClassExecRubyModuleRubyProcNode((ClassExecBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassExecUninitializedNode
        extends ClassExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassExecUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassExecUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassExecUninitializedNode(ClassExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object executeClassEval(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated, RubyProc arguments2ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                RubyProc arguments2Value = arguments2ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                ClassExecBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassExecBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ClassExecNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassExecUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        private static abstract class ClassExecBaseNode
        extends ModuleNodes.ClassExecNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassExecBaseNode next0;

            ClassExecBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassExecBaseNode(ClassExecBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                ClassExecBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassExecBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new ClassExecUninitializedNode(this);
                    ((ClassExecUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ClassExecBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ClassExecUninitializedNode(this), new ClassExecPolymorphicNode(this), (ClassExecBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassExecBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    return (ClassExecBaseNode)ClassExecRubyModuleRubyProcNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    ClassExecBaseNode otherCast = (ClassExecBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (ClassExecBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
    public static final class ClassEvalNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassEvalNode> {
        private static ClassEvalNodeFactory classEvalNodeFactoryInstance;

        private ClassEvalNodeFactory() {
            super(ModuleNodes.ClassEvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassEvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassEvalNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassEvalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassEvalUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassEvalNode> getInstance() {
            if (classEvalNodeFactoryInstance == null) {
                classEvalNodeFactoryInstance = new ClassEvalNodeFactory();
            }
            return classEvalNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassEvalPolymorphicNode
        extends ClassEvalBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments4PolymorphicType;

            ClassEvalPolymorphicNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments4Value;
                Object arguments3Value;
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, arguments3Value2, arguments4Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3, arguments4Value3);
                }
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[3].executeIntegerFixnum(frameValue)) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value4);
                }
                try {
                    arguments4Value = this.arguments4PolymorphicType == UndefinedPlaceholder.class ? this.arguments[4].executeUndefinedPlaceholder(frameValue) : (this.arguments4PolymorphicType == RubyProc.class ? this.arguments[4].executeRubyProc(frameValue) : this.arguments[4].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments4PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
                this.arguments4PolymorphicType = types[4];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current2) {
                return new ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode((ClassEvalBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments4Value;
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof RubyProc");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    RubyProc arguments4ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current2) {
                return new ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode((ClassEvalBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                int arguments3Value;
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof int");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    int arguments3ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current2) {
                return new ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode((ClassEvalBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, RubyString.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                UndefinedPlaceholder arguments3Value;
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current2) {
                return new ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode((ClassEvalBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current2) {
                return new ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode((ClassEvalBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassEvalUninitializedNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassEvalUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassEvalUninitializedNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                Object arguments4Value = this.arguments[4].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                ClassEvalBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassEvalBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3], rootNode.arguments[4]}, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassEvalUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        private static abstract class ClassEvalBaseNode
        extends ModuleNodes.ClassEvalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassEvalBaseNode next0;

            ClassEvalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassEvalBaseNode(ClassEvalBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5, Object var6);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value, String reason2) {
                String message2;
                ClassEvalBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassEvalBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                if (newNode == null) {
                    newNode = new ClassEvalUninitializedNode(this);
                    ((ClassEvalUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ClassEvalBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ClassEvalUninitializedNode(this), new ClassEvalPolymorphicNode(this), (ClassEvalBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassEvalBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                                return (ClassEvalBaseNode)ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                                return (ClassEvalBaseNode)ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value)) {
                            return (ClassEvalBaseNode)ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments4Value)) {
                            return (ClassEvalBaseNode)ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                            return (ClassEvalBaseNode)ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                    this.arguments[4] = null;
                } else {
                    ClassEvalBaseNode otherCast = (ClassEvalBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                    this.arguments[4] = otherCast.arguments[4];
                }
                this.next0 = newNext == null ? null : (ClassEvalBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments4Value").append(" = ").append(arguments4Value);
                    if (arguments4Value != null) {
                        builder.append(" (").append(arguments4Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
    public static final class AttrAccessorNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrAccessorNode> {
        private static AttrAccessorNodeFactory attrAccessorNodeFactoryInstance;

        private AttrAccessorNodeFactory() {
            super(ModuleNodes.AttrAccessorNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AttrAccessorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrAccessorNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AttrAccessorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AttrAccessorUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AttrAccessorNode> getInstance() {
            if (attrAccessorNodeFactoryInstance == null) {
                attrAccessorNodeFactoryInstance = new AttrAccessorNodeFactory();
            }
            return attrAccessorNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AttrAccessorPolymorphicNode
        extends AttrAccessorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AttrAccessorPolymorphicNode(AttrAccessorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AttrAccessorRubyModuleNode
        extends AttrAccessorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrAccessorRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            AttrAccessorRubyModuleNode(AttrAccessorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.attrAccessor(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.attrAccessor(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrAccessorNode create0(ModuleNodes.AttrAccessorNode current2) {
                return new AttrAccessorRubyModuleNode((AttrAccessorBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AttrAccessorUninitializedNode
        extends AttrAccessorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrAccessorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AttrAccessorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AttrAccessorUninitializedNode(AttrAccessorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AttrAccessorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AttrAccessorBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrAccessorNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AttrAccessorUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        private static abstract class AttrAccessorBaseNode
        extends ModuleNodes.AttrAccessorNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AttrAccessorBaseNode next0;

            AttrAccessorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AttrAccessorBaseNode(AttrAccessorBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AttrAccessorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AttrAccessorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AttrAccessorUninitializedNode(this);
                    ((AttrAccessorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = AttrAccessorBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new AttrAccessorUninitializedNode(this), new AttrAccessorPolymorphicNode(this), (AttrAccessorBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AttrAccessorBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (AttrAccessorBaseNode)AttrAccessorRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AttrAccessorBaseNode otherCast = (AttrAccessorBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AttrAccessorBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
    public static final class AttrWriterNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrWriterNode> {
        private static AttrWriterNodeFactory attrWriterNodeFactoryInstance;

        private AttrWriterNodeFactory() {
            super(ModuleNodes.AttrWriterNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AttrWriterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrWriterNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AttrWriterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AttrWriterUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AttrWriterNode> getInstance() {
            if (attrWriterNodeFactoryInstance == null) {
                attrWriterNodeFactoryInstance = new AttrWriterNodeFactory();
            }
            return attrWriterNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AttrWriterPolymorphicNode
        extends AttrWriterBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AttrWriterPolymorphicNode(AttrWriterBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AttrWriterRubyModuleNode
        extends AttrWriterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrWriterRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            AttrWriterRubyModuleNode(AttrWriterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.attrWriter(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.attrWriter(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrWriterNode create0(ModuleNodes.AttrWriterNode current2) {
                return new AttrWriterRubyModuleNode((AttrWriterBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AttrWriterUninitializedNode
        extends AttrWriterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrWriterUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AttrWriterUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AttrWriterUninitializedNode(AttrWriterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AttrWriterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AttrWriterBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrWriterNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AttrWriterUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        private static abstract class AttrWriterBaseNode
        extends ModuleNodes.AttrWriterNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AttrWriterBaseNode next0;

            AttrWriterBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AttrWriterBaseNode(AttrWriterBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AttrWriterBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AttrWriterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AttrWriterUninitializedNode(this);
                    ((AttrWriterUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = AttrWriterBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new AttrWriterUninitializedNode(this), new AttrWriterPolymorphicNode(this), (AttrWriterBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AttrWriterBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (AttrWriterBaseNode)AttrWriterRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AttrWriterBaseNode otherCast = (AttrWriterBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AttrWriterBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
    public static final class AttrReaderNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrReaderNode> {
        private static AttrReaderNodeFactory attrReaderNodeFactoryInstance;

        private AttrReaderNodeFactory() {
            super(ModuleNodes.AttrReaderNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AttrReaderNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrReaderNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AttrReaderNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AttrReaderUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AttrReaderNode> getInstance() {
            if (attrReaderNodeFactoryInstance == null) {
                attrReaderNodeFactoryInstance = new AttrReaderNodeFactory();
            }
            return attrReaderNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AttrReaderPolymorphicNode
        extends AttrReaderBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AttrReaderPolymorphicNode(AttrReaderBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AttrReaderRubyModuleNode
        extends AttrReaderBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrReaderRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            AttrReaderRubyModuleNode(AttrReaderBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.attrReader(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.attrReader(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrReaderNode create0(ModuleNodes.AttrReaderNode current2) {
                return new AttrReaderRubyModuleNode((AttrReaderBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AttrReaderUninitializedNode
        extends AttrReaderBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrReaderUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AttrReaderUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AttrReaderUninitializedNode(AttrReaderBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AttrReaderBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AttrReaderBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrReaderNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AttrReaderUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        private static abstract class AttrReaderBaseNode
        extends ModuleNodes.AttrReaderNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AttrReaderBaseNode next0;

            AttrReaderBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AttrReaderBaseNode(AttrReaderBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AttrReaderBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AttrReaderBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AttrReaderUninitializedNode(this);
                    ((AttrReaderUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = AttrReaderBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new AttrReaderUninitializedNode(this), new AttrReaderPolymorphicNode(this), (AttrReaderBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AttrReaderBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (AttrReaderBaseNode)AttrReaderRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AttrReaderBaseNode otherCast = (AttrReaderBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AttrReaderBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
    public static final class AppendFeaturesNodeFactory
    extends NodeFactoryBase<ModuleNodes.AppendFeaturesNode> {
        private static AppendFeaturesNodeFactory appendFeaturesNodeFactoryInstance;

        private AppendFeaturesNodeFactory() {
            super(ModuleNodes.AppendFeaturesNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AppendFeaturesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AppendFeaturesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AppendFeaturesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AppendFeaturesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AppendFeaturesNode> getInstance() {
            if (appendFeaturesNodeFactoryInstance == null) {
                appendFeaturesNodeFactoryInstance = new AppendFeaturesNodeFactory();
            }
            return appendFeaturesNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AppendFeaturesPolymorphicNode
        extends AppendFeaturesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AppendFeaturesPolymorphicNode(AppendFeaturesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AppendFeaturesRubyModuleNode
        extends AppendFeaturesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AppendFeaturesRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            AppendFeaturesRubyModuleNode(AppendFeaturesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.appendFeatures(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.appendFeatures(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AppendFeaturesNode create0(ModuleNodes.AppendFeaturesNode current2) {
                return new AppendFeaturesRubyModuleNode((AppendFeaturesBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AppendFeaturesUninitializedNode
        extends AppendFeaturesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AppendFeaturesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AppendFeaturesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AppendFeaturesUninitializedNode(AppendFeaturesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AppendFeaturesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AppendFeaturesBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AppendFeaturesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AppendFeaturesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        private static abstract class AppendFeaturesBaseNode
        extends ModuleNodes.AppendFeaturesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AppendFeaturesBaseNode next0;

            AppendFeaturesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AppendFeaturesBaseNode(AppendFeaturesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AppendFeaturesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AppendFeaturesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AppendFeaturesUninitializedNode(this);
                    ((AppendFeaturesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = AppendFeaturesBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new AppendFeaturesUninitializedNode(this), new AppendFeaturesPolymorphicNode(this), (AppendFeaturesBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AppendFeaturesBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    return (AppendFeaturesBaseNode)AppendFeaturesRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AppendFeaturesBaseNode otherCast = (AppendFeaturesBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AppendFeaturesBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
    public static final class AncestorsNodeFactory
    extends NodeFactoryBase<ModuleNodes.AncestorsNode> {
        private static AncestorsNodeFactory ancestorsNodeFactoryInstance;

        private AncestorsNodeFactory() {
            super(ModuleNodes.AncestorsNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AncestorsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AncestorsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AncestorsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AncestorsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AncestorsNode> getInstance() {
            if (ancestorsNodeFactoryInstance == null) {
                ancestorsNodeFactoryInstance = new AncestorsNodeFactory();
            }
            return ancestorsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AncestorsPolymorphicNode
        extends AncestorsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AncestorsPolymorphicNode(AncestorsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AncestorsRubyModuleNode
        extends AncestorsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AncestorsRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            AncestorsRubyModuleNode(AncestorsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.ancestors(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.ancestors(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.AncestorsNode create0(ModuleNodes.AncestorsNode current2) {
                return new AncestorsRubyModuleNode((AncestorsBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AncestorsUninitializedNode
        extends AncestorsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AncestorsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AncestorsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AncestorsUninitializedNode(AncestorsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AncestorsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AncestorsBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.AncestorsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AncestorsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        private static abstract class AncestorsBaseNode
        extends ModuleNodes.AncestorsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AncestorsBaseNode next0;

            AncestorsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AncestorsBaseNode(AncestorsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                AncestorsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AncestorsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AncestorsUninitializedNode(this);
                    ((AncestorsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = AncestorsBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new AncestorsUninitializedNode(this), new AncestorsPolymorphicNode(this), (AncestorsBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AncestorsBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (AncestorsBaseNode)AncestorsRubyModuleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AncestorsBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AncestorsBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
    public static final class AliasMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.AliasMethodNode> {
        private static AliasMethodNodeFactory aliasMethodNodeFactoryInstance;

        private AliasMethodNodeFactory() {
            super(ModuleNodes.AliasMethodNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AliasMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AliasMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AliasMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AliasMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AliasMethodNode> getInstance() {
            if (aliasMethodNodeFactoryInstance == null) {
                aliasMethodNodeFactoryInstance = new AliasMethodNodeFactory();
            }
            return aliasMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AliasMethodPolymorphicNode
        extends AliasMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            AliasMethodPolymorphicNode(AliasMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AliasMethodRubyModuleRubySymbolNode
        extends AliasMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AliasMethodRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, RubySymbol.class}, 0, 0);

            AliasMethodRubyModuleRubySymbolNode(AliasMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments2Value;
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubySymbol");
                }
                return super.aliasMethod(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    RubySymbol arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments2Value);
                    return super.aliasMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.AliasMethodNode create0(ModuleNodes.AliasMethodNode current2) {
                return new AliasMethodRubyModuleRubySymbolNode((AliasMethodBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AliasMethodUninitializedNode
        extends AliasMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AliasMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AliasMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AliasMethodUninitializedNode(AliasMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                AliasMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AliasMethodBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.AliasMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AliasMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        private static abstract class AliasMethodBaseNode
        extends ModuleNodes.AliasMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AliasMethodBaseNode next0;

            AliasMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AliasMethodBaseNode(AliasMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                AliasMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AliasMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new AliasMethodUninitializedNode(this);
                    ((AliasMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = AliasMethodBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new AliasMethodUninitializedNode(this), new AliasMethodPolymorphicNode(this), (AliasMethodBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AliasMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments2Value)) {
                    return (AliasMethodBaseNode)AliasMethodRubyModuleRubySymbolNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    AliasMethodBaseNode otherCast = (AliasMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (AliasMethodBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<ModuleNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(ModuleNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyModuleRubyBasicObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            CompareRubyModuleRubyBasicObjectNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.compare(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.compare(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.CompareNode create0(ModuleNodes.CompareNode current2) {
                return new CompareRubyModuleRubyBasicObjectNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyModuleNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            CompareRubyModuleNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.compare(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.compare(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.CompareNode create0(ModuleNodes.CompareNode current2) {
                return new CompareRubyModuleNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends ModuleNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = CompareBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new CompareUninitializedNode(this), new ComparePolymorphicNode(this), (CompareBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyModuleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyModuleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
    public static final class IsSubclassOfNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSubclassOfNode> {
        private static IsSubclassOfNodeFactory isSubclassOfNodeFactoryInstance;

        private IsSubclassOfNodeFactory() {
            super(ModuleNodes.IsSubclassOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IsSubclassOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSubclassOfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IsSubclassOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsSubclassOfUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IsSubclassOfNode> getInstance() {
            if (isSubclassOfNodeFactoryInstance == null) {
                isSubclassOfNodeFactoryInstance = new IsSubclassOfNodeFactory();
            }
            return isSubclassOfNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsSubclassOfPolymorphicNode
        extends IsSubclassOfBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IsSubclassOfPolymorphicNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? arguments1ValueEvaluated : (this.arguments1PolymorphicType == RubyBasicObject.class ? arguments1ValueEvaluated : arguments1ValueEvaluated);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSubclassOfRubyModuleRubyBasicObjectNode
        extends IsSubclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            IsSubclassOfRubyModuleRubyBasicObjectNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.isSubclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSubclassOf(frameValue, arguments0Value, (RubyBasicObject)arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.isSubclassOf(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfNode create0(ModuleNodes.IsSubclassOfNode current2) {
                return new IsSubclassOfRubyModuleRubyBasicObjectNode((IsSubclassOfBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSubclassOfRubyModuleNode
        extends IsSubclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            IsSubclassOfRubyModuleNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.isSubclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSubclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.isSubclassOf(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfNode create0(ModuleNodes.IsSubclassOfNode current2) {
                return new IsSubclassOfRubyModuleNode((IsSubclassOfBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsSubclassOfUninitializedNode
        extends IsSubclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsSubclassOfUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsSubclassOfUninitializedNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IsSubclassOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsSubclassOfBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsSubclassOfUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        private static abstract class IsSubclassOfBaseNode
        extends ModuleNodes.IsSubclassOfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsSubclassOfBaseNode next0;

            IsSubclassOfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsSubclassOfBaseNode(IsSubclassOfBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                IsSubclassOfBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsSubclassOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IsSubclassOfUninitializedNode(this);
                    ((IsSubclassOfUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = IsSubclassOfBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new IsSubclassOfUninitializedNode(this), new IsSubclassOfPolymorphicNode(this), (IsSubclassOfBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsSubclassOfBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                        return (IsSubclassOfBaseNode)IsSubclassOfRubyModuleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (IsSubclassOfBaseNode)IsSubclassOfRubyModuleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IsSubclassOfBaseNode otherCast = (IsSubclassOfBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IsSubclassOfBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
    public static final class ContainsInstanceNodeFactory
    extends NodeFactoryBase<ModuleNodes.ContainsInstanceNode> {
        private static ContainsInstanceNodeFactory containsInstanceNodeFactoryInstance;

        private ContainsInstanceNodeFactory() {
            super(ModuleNodes.ContainsInstanceNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ContainsInstanceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ContainsInstanceNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ContainsInstanceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ContainsInstanceUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ContainsInstanceNode> getInstance() {
            if (containsInstanceNodeFactoryInstance == null) {
                containsInstanceNodeFactoryInstance = new ContainsInstanceNodeFactory();
            }
            return containsInstanceNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ContainsInstancePolymorphicNode
        extends ContainsInstanceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ContainsInstancePolymorphicNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ContainsInstanceRubyModuleObjectNode
        extends ContainsInstanceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ContainsInstanceRubyModuleObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object.class}, 0, 0);

            ContainsInstanceRubyModuleObjectNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyModule");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.containsInstance(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.containsInstance(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ContainsInstanceNode create0(ModuleNodes.ContainsInstanceNode current2) {
                return new ContainsInstanceRubyModuleObjectNode((ContainsInstanceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ContainsInstanceRubyModuleRubyBasicObjectNode
        extends ContainsInstanceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ContainsInstanceRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            ContainsInstanceRubyModuleRubyBasicObjectNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.containsInstance(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.containsInstance(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ContainsInstanceNode create0(ModuleNodes.ContainsInstanceNode current2) {
                return new ContainsInstanceRubyModuleRubyBasicObjectNode((ContainsInstanceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ContainsInstanceUninitializedNode
        extends ContainsInstanceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ContainsInstanceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ContainsInstanceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ContainsInstanceUninitializedNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ContainsInstanceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ContainsInstanceBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ContainsInstanceNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ContainsInstanceUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        private static abstract class ContainsInstanceBaseNode
        extends ModuleNodes.ContainsInstanceNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ContainsInstanceBaseNode next0;

            ContainsInstanceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ContainsInstanceBaseNode(ContainsInstanceBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ContainsInstanceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ContainsInstanceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ContainsInstanceUninitializedNode(this);
                    ((ContainsInstanceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ContainsInstanceBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ContainsInstanceUninitializedNode(this), new ContainsInstancePolymorphicNode(this), (ContainsInstanceBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ContainsInstanceBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (ContainsInstanceBaseNode)ContainsInstanceRubyModuleRubyBasicObjectNode.create0(this);
                    }
                    return (ContainsInstanceBaseNode)ContainsInstanceRubyModuleObjectNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ContainsInstanceBaseNode otherCast = (ContainsInstanceBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ContainsInstanceBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

