/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;

@CoreClass(name="MatchData")
public abstract class MatchDataNodes {

    @CoreMethod(names={"values_at"}, argumentsAsArray=true)
    public static abstract class ValuesAtNode
    extends CoreMethodNode {
        public ValuesAtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ValuesAtNode(ValuesAtNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray valuesAt(RubyMatchData matchData, Object[] args2) {
            ValuesAtNode.notDesignedForCompilation();
            int[] indicies = new int[args2.length];
            for (int n = 0; n < args2.length; ++n) {
                indicies[n] = (Integer)args2[n];
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.valuesAt(indicies));
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString toS(RubyMatchData matchData) {
            ToSNode.notDesignedForCompilation();
            ByteList bytes2 = matchData.getGlobal().getBytes().dup();
            return this.getContext().makeString(bytes2);
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToANode(ToANode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray toA(RubyMatchData matchData) {
            ToANode.notDesignedForCompilation();
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.getValues());
        }
    }

    @CoreMethod(names={"post_match"})
    public static abstract class PostMatchNode
    extends CoreMethodNode {
        public PostMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PostMatchNode(PostMatchNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString postMatch(RubyMatchData matchData) {
            return matchData.getPost();
        }
    }

    @CoreMethod(names={"pre_match"})
    public static abstract class PreMatchNode
    extends CoreMethodNode {
        public PreMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PreMatchNode(PreMatchNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString preMatch(RubyMatchData matchData) {
            return matchData.getPre();
        }
    }

    @CoreMethod(names={"end"}, required=1, lowerFixnumParameters={1})
    public static abstract class EndNode
    extends CoreMethodNode {
        private final ConditionProfile badIndexProfile = ConditionProfile.createBinaryProfile();

        public EndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EndNode(EndNode prev) {
            super(prev);
        }

        @Specialization
        public Object end(RubyMatchData matchData, int index2) {
            EndNode.notDesignedForCompilation();
            if (this.badIndexProfile.profile(index2 < 0 || index2 >= matchData.getNumberOfRegions())) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index2), this));
            }
            return matchData.end(index2);
        }
    }

    @CoreMethod(names={"captures"})
    public static abstract class CapturesNode
    extends CoreMethodNode {
        public CapturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CapturesNode(CapturesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray toA(RubyMatchData matchData) {
            CapturesNode.notDesignedForCompilation();
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.getCaptures());
        }
    }

    @CoreMethod(names={"begin"}, required=1, lowerFixnumParameters={1})
    public static abstract class BeginNode
    extends CoreMethodNode {
        private final ConditionProfile badIndexProfile = ConditionProfile.createBinaryProfile();

        public BeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BeginNode(BeginNode prev) {
            super(prev);
        }

        @Specialization
        public Object begin(RubyMatchData matchData, int index2) {
            BeginNode.notDesignedForCompilation();
            if (this.badIndexProfile.profile(index2 < 0 || index2 >= matchData.getNumberOfRegions())) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index2), this));
            }
            return matchData.begin(index2);
        }
    }

    @CoreMethod(names={"[]"}, required=1, lowerFixnumParameters={0})
    public static abstract class GetIndexNode
    extends CoreMethodNode {
        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetIndexNode(GetIndexNode prev) {
            super(prev);
        }

        @Specialization
        public Object getIndex(RubyMatchData matchData, int index2) {
            GetIndexNode.notDesignedForCompilation();
            if (index2 >= matchData.getValues().length) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return matchData.getValues()[index2];
        }
    }
}

