/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBignum;

public class FixnumOrBignumNode
extends RubyNode {
    private final BranchProfile lowerProfile = BranchProfile.create();
    private final BranchProfile integerFromBignumProfile = BranchProfile.create();
    private final BranchProfile longFromBignumProfile = BranchProfile.create();
    private final BranchProfile integerFromDoubleProfile = BranchProfile.create();
    private final BranchProfile longFromDoubleProfile = BranchProfile.create();
    private final BranchProfile bignumProfile = BranchProfile.create();
    private final BranchProfile checkLongProfile = BranchProfile.create();

    public FixnumOrBignumNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public Object fixnumOrBignum(RubyBignum value2) {
        if (value2.compare(Long.MIN_VALUE) >= 0 && value2.compare(Long.MAX_VALUE) <= 0) {
            this.lowerProfile.enter();
            long longValue = value2.longValue();
            if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                this.integerFromBignumProfile.enter();
                return (int)longValue;
            }
            this.longFromBignumProfile.enter();
            return longValue;
        }
        return value2;
    }

    public Object fixnumOrBignum(double value2) {
        if (value2 > -2.147483648E9 && value2 < 2.147483647E9) {
            this.integerFromDoubleProfile.enter();
            return (int)value2;
        }
        this.checkLongProfile.enter();
        if (value2 > -9.223372036854776E18 && value2 < 9.223372036854776E18) {
            this.longFromDoubleProfile.enter();
            return (long)value2;
        }
        this.bignumProfile.enter();
        return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), FixnumOrBignumNode.doubleToBigInteger(value2));
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger doubleToBigInteger(double value2) {
        return new BigDecimal(value2).toBigInteger();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

