/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="Fiber")
public abstract class FiberNodes {

    @CoreMethod(names={"yield"}, onSingleton=true, argumentsAsArray=true)
    public static abstract class YieldNode
    extends CoreMethodNode {
        public YieldNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public YieldNode(YieldNode prev) {
            super(prev);
        }

        @Specialization
        public Object yield(Object[] args2) {
            YieldNode.notDesignedForCompilation();
            RubyFiber yieldingFiber = this.getContext().getFiberManager().getCurrentFiber();
            RubyFiber fiberYieldedTo = yieldingFiber.lastResumedByFiber;
            fiberYieldedTo.resume(yieldingFiber, args2);
            return yieldingFiber.waitForResume();
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyFiber fiber2, RubyProc block) {
            InitializeNode.notDesignedForCompilation();
            fiber2.initialize(block);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"resume"}, argumentsAsArray=true)
    public static abstract class ResumeNode
    extends CoreMethodNode {
        public ResumeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ResumeNode(ResumeNode prev) {
            super(prev);
        }

        @Specialization
        public Object resume(RubyFiber fiberBeingResumed, Object[] args2) {
            ResumeNode.notDesignedForCompilation();
            RubyFiber sendingFiber = this.getContext().getFiberManager().getCurrentFiber();
            fiberBeingResumed.resume(sendingFiber, args2);
            return sendingFiber.waitForResume();
        }
    }
}

