/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ClassNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="Class")
public abstract class ClassNodes {

    @CoreMethod(names={"superclass"})
    public static abstract class SuperClassNode
    extends CoreMethodNode {
        public SuperClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SuperClassNode(SuperClassNode prev) {
            super(prev);
        }

        @Specialization
        public RubyClass getSuperClass(RubyClass rubyClass) {
            return rubyClass.getSuperClass();
        }
    }

    @CoreMethod(names={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class InheritedNode
    extends CoreMethodNode {
        public InheritedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InheritedNode(InheritedNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass inherited(Object subclass) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        @Node.Child
        private ModuleNodes.InitializeNode moduleInitializeNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        void moduleInitialize(VirtualFrame frame, RubyClass rubyClass, RubyProc block) {
            if (this.moduleInitializeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.moduleInitializeNode = this.insert(ModuleNodesFactory.InitializeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            this.moduleInitializeNode.executeInitialize(frame, rubyClass, block);
        }

        @Specialization
        public RubyClass initialize(RubyClass rubyClass, UndefinedPlaceholder superclass2, UndefinedPlaceholder block) {
            return this.initialize(rubyClass, this.getContext().getCoreLibrary().getObjectClass(), block);
        }

        @Specialization
        public RubyClass initialize(RubyClass rubyClass, RubyClass superclass2, UndefinedPlaceholder block) {
            rubyClass.initialize(superclass2);
            return rubyClass;
        }

        @Specialization
        public RubyClass initialize(VirtualFrame frame, RubyClass rubyClass, UndefinedPlaceholder superclass2, RubyProc block) {
            return this.initialize(frame, rubyClass, this.getContext().getCoreLibrary().getObjectClass(), block);
        }

        @Specialization
        public RubyClass initialize(VirtualFrame frame, RubyClass rubyClass, RubyClass superclass2, RubyProc block) {
            rubyClass.initialize(superclass2);
            this.moduleInitialize(frame, rubyClass, block);
            return rubyClass;
        }
    }

    @CoreMethod(names={"new"}, needsBlock=true, argumentsAsArray=true)
    public static abstract class NewNode
    extends CoreMethodNode {
        @Node.Child
        private AllocateNode allocateNode;
        @Node.Child
        private CallDispatchHeadNode initialize;
        @CompilerDirectives.CompilationFinal
        private boolean isCached = true;
        @CompilerDirectives.CompilationFinal
        private RubyClass cachedClass;

        public NewNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = ClassNodesFactory.AllocateNodeFactory.create(context, sourceSection, new RubyNode[]{null});
            this.initialize = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        public NewNode(NewNode prev) {
            super(prev);
            this.allocateNode = prev.allocateNode;
            this.initialize = prev.initialize;
        }

        @Specialization
        public RubyBasicObject newInstance(VirtualFrame frame, RubyClass rubyClass, Object[] args2, UndefinedPlaceholder block) {
            return this.doNewInstance(frame, rubyClass, args2, null);
        }

        @Specialization
        public RubyBasicObject newInstance(VirtualFrame frame, RubyClass rubyClass, Object[] args2, RubyProc block) {
            return this.doNewInstance(frame, rubyClass, args2, block);
        }

        private RubyBasicObject doNewInstance(VirtualFrame frame, RubyClass rubyClass, Object[] args2, RubyProc block) {
            RubyBasicObject instance = this.allocateNode.executeAllocate(frame, rubyClass);
            this.initialize.call(frame, instance, "initialize", block, args2);
            return instance;
        }
    }

    @CoreMethod(names={"allocate"})
    public static abstract class AllocateNode
    extends CoreMethodNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AllocateNode(AllocateNode prev) {
            super(prev);
        }

        public abstract RubyBasicObject executeAllocate(VirtualFrame var1, RubyClass var2);

        @Specialization
        public RubyBasicObject allocate(RubyClass rubyClass) {
            if (rubyClass.isSingleton()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't create instance of singleton class", this));
            }
            return rubyClass.allocate(this);
        }
    }
}

