/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.HashCastNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=HashCastNode.class)
public final class HashCastNodeFactory
extends NodeFactoryBase<HashCastNode> {
    private static HashCastNodeFactory instance;

    private HashCastNodeFactory() {
        super(HashCastNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    @Override
    public HashCastNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return HashCastNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static HashCastNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return HashCastUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<HashCastNode> getInstance() {
        if (instance == null) {
            instance = new HashCastNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class HashCastPolymorphicNode
    extends HashCastBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        HashCastPolymorphicNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.child.executeBoolean(frameValue)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(this.child.executeIntegerFixnum(frameValue)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(this.child.executeLongFixnum(frameValue)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(this.child.executeFloat(frameValue)) : (this.childPolymorphicType == RubyBignum.class ? this.child.executeBignum(frameValue) : (this.childPolymorphicType == RubyHash.class ? this.child.executeRubyHash(frameValue) : (this.childPolymorphicType == RubyNilClass.class ? this.child.executeRubyNilClass(frameValue) : (this.childPolymorphicType == RubyBasicObject.class ? this.child.executeRubyBasicObject(frameValue) : this.child.execute(frameValue))))))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastObjectRubyBasicObjectNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        HashCastObjectRubyBasicObjectNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!super.isRubyNilClass(childValue) && !super.isRubyHash(childValue)) {
                return super.cast(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyNilClass, !isRubyHash] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                if (!super.isRubyNilClass(childValue) && !super.isRubyHash(childValue)) {
                    return super.cast(frameValue, childValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastObjectRubyBasicObjectNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastRubyNilClassNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

        HashCastRubyNilClassNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyNilClass childValue;
            try {
                childValue = this.child.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyNilClass"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                RubyNilClass childValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastRubyNilClassNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastRubyHashNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

        HashCastRubyHashNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyHash value2;
            try {
                value2 = this.executeRubyHash(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyHash childValue;
            try {
                childValue = this.child.executeRubyHash(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyHash"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyHash(childValue)) {
                RubyHash childValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastRubyHashNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastRubyNilClassRubyBignumNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastRubyNilClassRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

        HashCastRubyNilClassRubyBignumNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBignum childValue;
            try {
                childValue = this.child.executeBignum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBignum"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                RubyBignum childValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastRubyNilClassRubyBignumNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastRubyNilClassDoubleNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastRubyNilClassDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        HashCastRubyNilClassDoubleNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            double childValue;
            try {
                childValue = this.child.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof double"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                double childValueCast = RubyTypesGen.RUBYTYPES.asDouble(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastRubyNilClassDoubleNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastRubyNilClassLongNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastRubyNilClassLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        HashCastRubyNilClassLongNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                long childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastRubyNilClassLongNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastRubyNilClassIntNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastRubyNilClassIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        HashCastRubyNilClassIntNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int childValue;
            try {
                childValue = this.child.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof int"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                int childValueCast = RubyTypesGen.RUBYTYPES.asInteger(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastRubyNilClassIntNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class HashCastRubyNilClassBooleanNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastRubyNilClassBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        HashCastRubyNilClassBooleanNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean childValue;
            try {
                childValue = this.child.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof boolean"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                boolean childValueCast = RubyTypesGen.RUBYTYPES.asBoolean(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(HashCastNode current2) {
            return new HashCastRubyNilClassBooleanNode((HashCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class HashCastUninitializedNode
    extends HashCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(HashCastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        HashCastUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        HashCastUninitializedNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            HashCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                HashCastBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.child}, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, childValue);
        }

        static HashCastNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new HashCastUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=HashCastNode.class)
    private static abstract class HashCastBaseNode
    extends HashCastNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected HashCastBaseNode next0;

        HashCastBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        HashCastBaseNode(HashCastBaseNode copy) {
            super(copy);
        }

        @Override
        protected RubyNode getChild() {
            return this.child;
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object childValue, String reason2) {
            String message2;
            HashCastBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            HashCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new HashCastUninitializedNode(this);
                ((HashCastUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = HashCastBaseNode.createInfo0(reason2, childValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new HashCastUninitializedNode(this), new HashCastPolymorphicNode(this), (HashCastBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final HashCastBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                return (HashCastBaseNode)HashCastRubyNilClassBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                return (HashCastBaseNode)HashCastRubyNilClassIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                return (HashCastBaseNode)HashCastRubyNilClassLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                return (HashCastBaseNode)HashCastRubyNilClassDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                return (HashCastBaseNode)HashCastRubyNilClassRubyBignumNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyHash(childValue)) {
                return (HashCastBaseNode)HashCastRubyHashNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                return (HashCastBaseNode)HashCastRubyNilClassNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue) && !super.isRubyNilClass(childValue) && !super.isRubyHash(childValue)) {
                return (HashCastBaseNode)HashCastObjectRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((HashCastBaseNode)other).child;
            this.next0 = newNext == null ? null : (HashCastBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

