/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChild(value="child", type=RubyNode.class)
public abstract class BooleanCastNode
extends RubyNode {
    public BooleanCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public BooleanCastNode(BooleanCastNode copy) {
        super(copy.getContext(), copy.getSourceSection());
    }

    @Specialization
    public boolean doNil(RubyNilClass nil) {
        return false;
    }

    @Specialization
    public boolean doBoolean(boolean value2) {
        return value2;
    }

    @Specialization
    public boolean doIntegerFixnum(int value2) {
        return true;
    }

    @Specialization
    public boolean doLongFixnum(long value2) {
        return true;
    }

    @Specialization
    public boolean doFloat(double value2) {
        return true;
    }

    @Specialization(guards={"!isRubyNilClass"})
    public boolean doBasicObject(RubyBasicObject object) {
        return true;
    }

    @Override
    public abstract boolean executeBoolean(VirtualFrame var1);

    public abstract boolean executeBoolean(VirtualFrame var1, Object var2);

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }
}

