/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Backref;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.util.KeyValuePair;

class OperandEncoderMap
extends IRVisitor {
    private final IRWriterEncoder encoder;

    public OperandEncoderMap(IRWriterEncoder encoder) {
        this.encoder = encoder;
    }

    public void encode(Operand operand) {
        this.encoder.encode(operand.getOperandType().getCoded());
        operand.visit(this);
    }

    @Override
    public void Array(Array array) {
        Operand[] elts = array.getElts();
        this.encoder.encode(elts.length);
        for (Operand elt : elts) {
            this.encode(elt);
        }
    }

    @Override
    public void AsString(AsString asstring) {
        this.encoder.encode(asstring.getSource());
    }

    @Override
    public void Backref(Backref backref) {
        this.encoder.encode(backref.type);
    }

    @Override
    public void Bignum(Bignum bignum) {
        this.encoder.encode(bignum.value.toString());
    }

    @Override
    public void Boolean(Boolean booleanliteral) {
        this.encoder.encode(booleanliteral.isTrue());
    }

    @Override
    public void ClosureLocalVariable(ClosureLocalVariable variable) {
        this.encoder.encode(variable.getName());
        this.encoder.encode(variable.getScopeDepth());
    }

    @Override
    public void CurrentScope(CurrentScope scope) {
        this.encoder.encode(scope.getScopeNestingDepth());
    }

    @Override
    public void DynamicSymbol(DynamicSymbol dsym) {
    }

    @Override
    public void Fixnum(Fixnum fixnum) {
        this.encoder.encode(fixnum.value);
    }

    @Override
    public void Float(Float flote) {
        this.encoder.encode(flote.value);
    }

    @Override
    public void GlobalVariable(GlobalVariable variable) {
        this.encoder.encode(variable.getName());
    }

    @Override
    public void Hash(Hash hash2) {
        this.encoder.encode(hash2.pairs.size());
        for (KeyValuePair<Operand, Operand> pair : hash2.pairs) {
            this.encoder.encode(pair.getKey());
            this.encoder.encode(pair.getValue());
        }
    }

    @Override
    public void IRException(IRException irexception) {
        this.encoder.encode((byte)irexception.getType().ordinal());
    }

    @Override
    public void Label(Label label2) {
        this.encoder.encode(label2.prefix);
        this.encoder.encode(label2.id);
    }

    @Override
    public void LocalVariable(LocalVariable variable) {
        this.encoder.encode(variable.getName());
        this.encoder.encode(variable.getScopeDepth());
    }

    @Override
    public void Nil(Nil nil) {
    }

    @Override
    public void NthRef(NthRef nthref) {
        this.encoder.encode(nthref.matchNumber);
    }

    @Override
    public void NullBlock(NullBlock nullblock) {
    }

    @Override
    public void ObjectClass(ObjectClass objectclass) {
    }

    @Override
    public void Regexp(Regexp regexp2) {
        this.encode(regexp2.getRegexp());
        this.encoder.encode(regexp2.options.isEncodingNone());
        this.encoder.encode(regexp2.options.toEmbeddedOptions());
    }

    @Override
    public void ScopeModule(ScopeModule scope) {
        this.encoder.encode(scope.getScopeModuleDepth());
    }

    @Override
    public void Self(Self self2) {
    }

    @Override
    public void Splat(Splat splat) {
        this.encode(splat.getArray());
    }

    @Override
    public void StandardError(StandardError standarderror) {
    }

    @Override
    public void StringLiteral(StringLiteral stringliteral) {
        this.encoder.encode(stringliteral.string);
    }

    @Override
    public void SValue(SValue svalue) {
        this.encode(svalue.getArray());
    }

    @Override
    public void Symbol(Symbol symbol) {
        this.encoder.encode(symbol.getName());
    }

    @Override
    public void TemporaryBooleanVariable(TemporaryBooleanVariable variable) {
        this.encoder.encode((byte)variable.getType().ordinal());
        this.encoder.encode(variable.getOffset());
    }

    @Override
    public void TemporaryFixnumVariable(TemporaryFixnumVariable variable) {
        this.encoder.encode((byte)variable.getType().ordinal());
        this.encoder.encode(variable.getOffset());
    }

    @Override
    public void TemporaryFloatVariable(TemporaryFloatVariable variable) {
        this.encoder.encode((byte)variable.getType().ordinal());
        this.encoder.encode(variable.getOffset());
    }

    @Override
    public void TemporaryLocalVariable(TemporaryLocalVariable variable) {
        this.encoder.encode((byte)variable.getType().ordinal());
        if (variable.getType() == TemporaryVariableType.CLOSURE) {
            this.encoder.encode(((TemporaryClosureVariable)variable).getClosureId());
        }
        this.encoder.encode(variable.getOffset());
    }

    @Override
    public void TemporaryVariable(TemporaryVariable variable) {
        this.encoder.encode((byte)variable.getType().ordinal());
        this.encoder.encode(((TemporaryLocalVariable)variable).getOffset());
    }

    @Override
    public void UnboxedBoolean(UnboxedBoolean booleanliteral) {
        this.encoder.encode(booleanliteral.isTrue());
    }

    @Override
    public void UnboxedFixnum(UnboxedFixnum fixnum) {
        this.encoder.encode(fixnum.value);
    }

    @Override
    public void UnboxedFloat(UnboxedFloat flote) {
        this.encoder.encode(flote.value);
    }

    @Override
    public void UndefinedValue(UndefinedValue undefinedvalue) {
    }

    @Override
    public void UnexecutableNil(UnexecutableNil unexecutablenil) {
    }

    @Override
    public void WrappedIRClosure(WrappedIRClosure scope) {
        this.encoder.encode(scope.getSelf());
        this.encoder.encode(scope.getClosure());
    }
}

