/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jruby.ir.IRScope;
import org.jruby.ir.passes.CFGBuilder;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class DominatorTreeBuilder
extends CompilerPass {
    private static int NULL = -1;
    private static final Logger LOG = LoggerFactory.getLogger("DominatorTreeBuilder");
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(CFGBuilder.class);

    @Override
    public String getLabel() {
        return "Build Dominator Tree";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        CFG cfg = (CFG)data2[0];
        try {
            this.buildDominatorTree(cfg, cfg.postOrderList(), cfg.getMaxNodeID());
        }
        catch (Exception e) {
            LOG.debug("Caught exception building dom tree for {}", scope.cfg());
        }
        return null;
    }

    @Override
    public boolean invalidate(IRScope scope) {
        return false;
    }

    public void buildDominatorTree(CFG cfg, LinkedList<BasicBlock> postOrderList, int maxNodeId) {
        int rootPoNumber;
        int[] bbToPoNumbers = new int[maxNodeId + 1];
        BasicBlock[] poNumbersToBB = new BasicBlock[maxNodeId + 1];
        int n = 0;
        ListIterator<Object> it = postOrderList.listIterator();
        while (it.hasNext()) {
            BasicBlock b2 = (BasicBlock)it.next();
            bbToPoNumbers[b2.getID()] = n;
            poNumbersToBB[n] = b2;
            ++n;
        }
        int[] idoms = new int[maxNodeId + 1];
        BasicBlock root = cfg.getEntryBB();
        idoms[rootPoNumber] = rootPoNumber = bbToPoNumbers[root.getID()];
        boolean changed = true;
        while (changed) {
            changed = false;
            it = postOrderList.listIterator(cfg.size());
            while (it.hasPrevious()) {
                BasicBlock b3 = (BasicBlock)it.previous();
                if (b3 == root) continue;
                int bPoNumber = bbToPoNumbers[b3.getID()];
                int oldBIdom = idoms[bPoNumber];
                int newBIdom = NULL;
                for (BasicBlock src : cfg.getIncomingSources(b3)) {
                    int srcPoNumber = bbToPoNumbers[src.getID()];
                    if (idoms[srcPoNumber] == NULL) continue;
                    newBIdom = srcPoNumber;
                    break;
                }
                assert (newBIdom != NULL);
                int processedPred = newBIdom;
                for (BasicBlock src : cfg.getIncomingSources(b3)) {
                    int srcPoNumber = bbToPoNumbers[src.getID()];
                    int srcIdom = idoms[srcPoNumber];
                    if (srcIdom == NULL || srcPoNumber == processedPred) continue;
                    newBIdom = this.intersectDomSets(idoms, srcPoNumber, newBIdom);
                }
                if (oldBIdom == newBIdom) continue;
                changed = true;
                idoms[bPoNumber] = newBIdom;
            }
        }
        HashMap<BasicBlock, BasicBlock> idomMap = new HashMap<BasicBlock, BasicBlock>();
        for (int i2 = 0; i2 < maxNodeId; ++i2) {
            idomMap.put(poNumbersToBB[i2], poNumbersToBB[idoms[i2]]);
        }
    }

    private int intersectDomSets(int[] idomMap, int nb1, int nb2) {
        while (nb1 != nb2) {
            while (nb1 < nb2) {
                nb1 = idomMap[nb1];
            }
            while (nb2 < nb1) {
                nb2 = idomMap[nb2];
            }
        }
        return nb1;
    }
}

