/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;

public class ArgsNode
extends Node {
    private final ListNode pre;
    private final int preCount;
    private final ListNode optArgs;
    protected final ArgumentNode restArgNode;
    protected final int restArg;
    private final BlockArgNode blockArgNode;
    protected Arity arity;
    private final int requiredArgsCount;
    protected final boolean hasOptArgs;
    protected final boolean hasMasgnArgs;
    protected final boolean hasKwargs;
    protected int maxArgsCount;
    protected final boolean isSimple;
    private final ListNode post;
    private final int postCount;
    private final int postIndex;
    private final ListNode keywords;
    private final KeywordRestArgNode keyRest;

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest2, ListNode post, BlockArgNode blockArgNode) {
        this(position, pre, optionalArguments, rest2, post, null, null, blockArgNode);
    }

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest2, ListNode post, ListNode keywords, KeywordRestArgNode keyRest, BlockArgNode blockArgNode) {
        super(position);
        this.pre = pre;
        this.preCount = pre == null ? 0 : pre.size();
        this.post = post;
        this.postCount = post == null ? 0 : post.size();
        int optArgCount = optionalArguments == null ? 0 : optionalArguments.size();
        this.postIndex = this.getPostCount(this.preCount, optArgCount, rest2);
        this.optArgs = optionalArguments;
        this.restArg = rest2 == null ? -1 : rest2.getIndex();
        this.restArgNode = rest2;
        this.blockArgNode = blockArgNode;
        this.keywords = keywords;
        this.keyRest = keyRest;
        this.requiredArgsCount = this.preCount + this.postCount;
        this.hasOptArgs = this.getOptArgs() != null;
        this.hasMasgnArgs = this.hasMasgnArgs();
        this.hasKwargs = keywords != null || keyRest != null;
        this.maxArgsCount = this.getRestArg() >= 0 ? -1 : this.getRequiredArgsCount() + this.getOptionalArgsCount();
        this.arity = this.calculateArity();
        this.isSimple = !this.hasMasgnArgs && !this.hasOptArgs && this.restArg < 0 && this.postCount <= 0 && !this.hasKwargs;
    }

    private int getPostCount(int preCount, int optArgCount, RestArgNode rest2) {
        if (rest2 != null) {
            return rest2.getIndex() + 1;
        }
        return preCount + optArgCount;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    protected Arity calculateArity() {
        if (this.getOptArgs() != null || this.getRestArg() >= 0) {
            return Arity.required(this.getRequiredArgsCount());
        }
        return Arity.createArity(this.getRequiredArgsCount());
    }

    public boolean hasKwargs() {
        return this.hasKwargs;
    }

    protected boolean hasMasgnArgs() {
        if (this.preCount > 0) {
            for (Node node : this.pre.childNodes()) {
                if (!(node instanceof AssignableNode)) continue;
                return true;
            }
        }
        if (this.postCount > 0) {
            for (Node node : this.post.childNodes()) {
                if (!(node instanceof AssignableNode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListNode getPre() {
        return this.pre;
    }

    public Arity getArity() {
        return this.arity;
    }

    public int getRequiredArgsCount() {
        return this.requiredArgsCount;
    }

    public int getOptionalArgsCount() {
        return this.optArgs == null ? 0 : this.optArgs.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    public int getMaxArgumentsCount() {
        return this.maxArgsCount;
    }

    public ListNode getOptArgs() {
        return this.optArgs;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public ArgumentNode getRestArgNode() {
        return this.restArgNode;
    }

    public BlockArgNode getBlock() {
        return this.blockArgNode;
    }

    public int getPostCount() {
        return this.postCount;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public int getPreCount() {
        return this.preCount;
    }

    public ListNode getKeywords() {
        return this.keywords;
    }

    public KeywordRestArgNode getKeyRest() {
        return this.keyRest;
    }

    public void checkArgCount(Ruby runtime, int argsLength) {
        Arity.checkArgumentCount(runtime, argsLength, this.requiredArgsCount, this.maxArgsCount, this.hasKwargs);
    }

    public void checkArgCount(Ruby runtime, String name2, int argsLength) {
        Arity.checkArgumentCount(runtime, name2, argsLength, this.requiredArgsCount, this.maxArgsCount, this.hasKwargs);
    }

    @Override
    public List<Node> childNodes() {
        if (this.post != null) {
            if (this.keywords != null) {
                if (this.keyRest != null) {
                    return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.keywords, this.keyRest, this.blockArgNode);
                }
                return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.keywords, this.blockArgNode);
            }
            return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.blockArgNode);
        }
        if (this.keywords != null) {
            if (this.keyRest != null) {
                return Node.createList(this.pre, this.optArgs, this.restArgNode, this.keywords, this.keyRest, this.blockArgNode);
            }
            return Node.createList(this.pre, this.optArgs, this.restArgNode, this.keywords, this.blockArgNode);
        }
        return Node.createList(this.pre, this.optArgs, this.restArgNode, this.blockArgNode);
    }
}

