/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.object.DebugCounter;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.utilities.NeverValidAssumption;
import com.oracle.truffle.object.Debug;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.PropertyImpl;
import com.oracle.truffle.object.PropertyMap;
import com.oracle.truffle.object.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class ShapeImpl
extends Shape {
    private final int id;
    protected final LayoutImpl layout;
    protected final ObjectType objectType;
    protected final ShapeImpl parent;
    protected final PropertyMap propertyMap;
    private final Object extraData;
    private final Object sharedData;
    private final ShapeImpl root;
    protected final int objectArraySize;
    protected final int objectArrayCapacity;
    protected final int objectFieldSize;
    protected final int primitiveFieldSize;
    protected final int primitiveArraySize;
    protected final int primitiveArrayCapacity;
    protected final boolean hasPrimitiveArray;
    protected final int depth;
    protected final int propertyCount;
    protected Property[] propertyArray;
    protected final Assumption validAssumption;
    @CompilerDirectives.CompilationFinal
    protected volatile Assumption leafAssumption;
    private HashMap<Transition, ShapeImpl> transitionMap;
    private final Transition transitionFromParent;
    public static final Shape.Pred<Property> ALL = new Shape.Pred<Property>(){

        @Override
        public boolean test(Property t) {
            return true;
        }
    };
    private static final DebugCounter shapeCount = DebugCounter.create("Shapes allocated total");
    private static final DebugCounter shapeCloneCount = DebugCounter.create("Shapes allocated cloned");
    private static final DebugCounter shapeCacheHitCount = DebugCounter.create("Shape cache hits");
    private static final DebugCounter shapeCacheMissCount = DebugCounter.create("Shape cache misses");
    protected static final DebugCounter propertyListAllocCount = DebugCounter.create("Property lists allocated");
    protected static final DebugCounter propertyListShareCount = DebugCounter.create("Property lists shared");

    private ShapeImpl(Layout layout2, ShapeImpl parent, ObjectType objectType, Object sharedData, PropertyMap propertyMap, Transition transitionFromParent, int objectArraySize, int objectFieldSize, int primitiveFieldSize, int primitiveArraySize, boolean hasPrimitiveArray, int id2) {
        this.layout = (LayoutImpl)layout2;
        this.objectType = Objects.requireNonNull(objectType);
        this.propertyMap = Objects.requireNonNull(propertyMap);
        this.root = parent != null ? parent.getRoot() : this;
        this.parent = parent;
        this.transitionFromParent = transitionFromParent;
        this.objectArraySize = objectArraySize;
        this.objectArrayCapacity = ShapeImpl.capacityFromSize(objectArraySize);
        this.objectFieldSize = objectFieldSize;
        this.primitiveFieldSize = primitiveFieldSize;
        this.primitiveArraySize = primitiveArraySize;
        this.primitiveArrayCapacity = ShapeImpl.capacityFromSize(primitiveArraySize);
        this.hasPrimitiveArray = hasPrimitiveArray;
        if (parent != null) {
            this.propertyCount = ShapeImpl.makePropertyCount(parent, propertyMap);
            this.propertyArray = ShapeImpl.makePropertiesList(parent, propertyMap);
            this.depth = parent.depth + 1;
        } else {
            this.propertyCount = 0;
            this.propertyArray = null;
            this.depth = 0;
        }
        this.validAssumption = ShapeImpl.createValidAssumption();
        this.id = id2;
        shapeCount.inc();
        this.sharedData = sharedData;
        this.extraData = objectType.createShapeData(this);
        ShapeImpl.debugRegisterShape(this);
    }

    protected ShapeImpl(Layout layout2, ShapeImpl parent, ObjectType operations, Object sharedData, PropertyMap propertyMap, Transition transition, Shape.Allocator allocator, int id2) {
        this(layout2, parent, operations, sharedData, propertyMap, transition, ((BaseAllocator)allocator).objectArraySize, ((BaseAllocator)allocator).objectFieldSize, ((BaseAllocator)allocator).primitiveFieldSize, ((BaseAllocator)allocator).primitiveArraySize, ((BaseAllocator)allocator).hasPrimitiveArray, id2);
    }

    protected abstract ShapeImpl createShape(Layout var1, Object var2, ShapeImpl var3, ObjectType var4, PropertyMap var5, Transition var6, Shape.Allocator var7, int var8);

    protected ShapeImpl(Layout layout2, ObjectType operations, Object sharedData, int id2) {
        this(layout2, null, operations, sharedData, PropertyMap.empty(), null, layout2.createAllocator(), id2);
    }

    private static int makePropertyCount(ShapeImpl parent, PropertyMap propertyMap) {
        return parent.propertyCount + (propertyMap.size() > parent.propertyMap.size() && !propertyMap.getLastProperty().isHidden() && !propertyMap.getLastProperty().isShadow() ? 1 : 0);
    }

    private static Property[] makePropertiesList(ShapeImpl parent, PropertyMap propertyMap) {
        Property[] properties = parent.propertyArray;
        if (properties != null && propertyMap.size() != parent.propertyMap.size()) {
            Property lastProperty = propertyMap.getLastProperty();
            if (lastProperty != null && !lastProperty.isHidden()) {
                propertyListAllocCount.inc();
                if (!lastProperty.isShadow()) {
                    properties = Arrays.copyOf(properties, properties.length + 1);
                    properties[properties.length - 1] = lastProperty;
                } else {
                    properties = Arrays.copyOf(properties, properties.length);
                    int i2 = 0;
                    while (i2 < properties.length) {
                        if (properties[i2].isSame(lastProperty)) {
                            properties[i2] = lastProperty;
                        }
                        ++i2;
                    }
                }
            } else {
                propertyListShareCount.inc();
            }
        }
        return properties;
    }

    @Override
    public final Property getLastProperty() {
        return this.propertyMap.getLastProperty();
    }

    @Override
    public final int getId() {
        return this.id;
    }

    private static int capacityFromSize(int size2) {
        if (size2 == 0) {
            return 0;
        }
        if (size2 < 4) {
            return 4;
        }
        if (size2 < 32) {
            return (size2 + 7) / 8 * 8;
        }
        return (size2 + 15) / 16 * 16;
    }

    @Override
    public final int getObjectArraySize() {
        return this.objectArraySize;
    }

    @Override
    public final int getObjectFieldSize() {
        return this.objectFieldSize;
    }

    @Override
    public final int getPrimitiveFieldSize() {
        return this.primitiveFieldSize;
    }

    @Override
    public final int getObjectArrayCapacity() {
        return this.objectArrayCapacity;
    }

    @Override
    public final int getPrimitiveArrayCapacity() {
        return this.primitiveArrayCapacity;
    }

    @Override
    public final int getPrimitiveArraySize() {
        return this.primitiveArraySize;
    }

    @Override
    public final boolean hasPrimitiveArray() {
        return this.hasPrimitiveArray;
    }

    public final ShapeImpl getShapeFromProperty(Object propertyName) {
        ShapeImpl current2 = this;
        while (current2 != this.getRoot()) {
            if (current2.getTransitionFromParent() instanceof Transition.AddPropertyTransition && ((Transition.AddPropertyTransition)current2.getTransitionFromParent()).getProperty().getKey().equals(propertyName)) {
                return current2;
            }
            current2 = current2.getParent();
        }
        return null;
    }

    public final ShapeImpl getShapeFromProperty(Property prop) {
        ShapeImpl current2 = this;
        while (current2 != this.getRoot()) {
            if (current2.getTransitionFromParent() instanceof Transition.AddPropertyTransition && ((Transition.AddPropertyTransition)current2.getTransitionFromParent()).getProperty().equals(prop)) {
                return current2;
            }
            current2 = current2.parent;
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final Property getProperty(Object key2) {
        PropertyMap current2 = this.propertyMap;
        while (current2.getLastProperty() != null) {
            if (current2.getLastProperty().getKey().equals(key2)) {
                return current2.getLastProperty();
            }
            current2 = current2.getParentMap();
        }
        return null;
    }

    protected final void addDirectTransition(Transition transition, ShapeImpl next2) {
        assert (next2.getParent() == this && transition.isDirect());
        this.addTransitionInternal(transition, next2);
    }

    public final void addIndirectTransition(Transition transition, ShapeImpl next2) {
        assert (next2.getParent() != this && !transition.isDirect());
        this.addTransitionInternal(transition, next2);
    }

    private void addTransitionInternal(Transition transition, ShapeImpl next2) {
        this.getTransitionMapForWrite().put(transition, next2);
    }

    public final Map<Transition, ShapeImpl> getTransitionMapForRead() {
        return this.transitionMap != null ? this.transitionMap : Collections.emptyMap();
    }

    private Map<Transition, ShapeImpl> getTransitionMapForWrite() {
        if (this.transitionMap != null) {
            return this.transitionMap;
        }
        this.invalidateLeafAssumption();
        this.transitionMap = new HashMap<Transition, ShapeImpl>();
        return this.transitionMap;
    }

    public final PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    private ShapeImpl queryTransition(Transition transition) {
        ShapeImpl cachedShape = this.getTransitionMapForRead().get(transition);
        if (cachedShape != null) {
            shapeCacheHitCount.inc();
            return (ShapeImpl)this.layout.getStrategy().returnCached(cachedShape);
        }
        shapeCacheMissCount.inc();
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ShapeImpl addProperty(Property property) {
        assert (this.isValid());
        ShapeImpl nextShape = this.addPropertyInternal(property);
        this.objectType.onPropertyAdded(property, this, nextShape);
        return nextShape;
    }

    private ShapeImpl addPropertyInternal(Property prop) {
        CompilerAsserts.neverPartOfCompilation();
        assert (prop.isShadow() || !this.hasProperty(prop.getKey())) : "duplicate property";
        assert (!this.getPropertyListInternal(false).contains(prop));
        Transition.AddPropertyTransition addTransition = new Transition.AddPropertyTransition(prop);
        ShapeImpl cachedShape = this.queryTransition(addTransition);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl oldShape = (ShapeImpl)this.layout.getStrategy().ensureSpace(this, prop.getLocation());
        ShapeImpl newShape = ShapeImpl.makeShapeWithAddedProperty(oldShape, addTransition);
        oldShape.addDirectTransition(addTransition, newShape);
        return newShape;
    }

    protected ShapeImpl cloneRoot(ShapeImpl from, Object newSharedData) {
        return this.createShape(from.layout, newSharedData, null, from.objectType, from.propertyMap, null, from.allocator(), from.id);
    }

    protected final ShapeImpl cloneOnto(ShapeImpl newParent) {
        ShapeImpl from = this;
        ShapeImpl newShape = this.createShape(newParent.layout, newParent.sharedData, newParent, from.objectType, from.propertyMap, from.transitionFromParent, from.allocator(), newParent.id);
        shapeCloneCount.inc();
        newParent.addDirectTransition(from.transitionFromParent, newShape);
        return newShape;
    }

    public final Transition getTransitionFromParent() {
        return this.transitionFromParent;
    }

    private static ShapeImpl makeShapeWithAddedProperty(ShapeImpl parent, Transition.AddPropertyTransition addTransition) {
        Property addend = addTransition.getProperty();
        BaseAllocator allocator = parent.allocator().addLocation(addend.getLocation());
        PropertyMap newPropertyMap = parent.propertyMap.putCopy(addend);
        ShapeImpl newShape = parent.createShape(parent.layout, parent.sharedData, parent, parent.objectType, newPropertyMap, addTransition, allocator, parent.id);
        assert (((LocationImpl)addend.getLocation()).primitiveArrayCount() == 0 || newShape.hasPrimitiveArray);
        assert (newShape.depth == allocator.depth);
        return newShape;
    }

    private static ShapeImpl makeShapeWithPrimitiveExtensionArray(ShapeImpl parent, Transition transition) {
        assert (parent.getLayout().hasPrimitiveExtensionArray());
        assert (!parent.hasPrimitiveArray());
        BaseAllocator allocator = parent.allocator().addLocation(parent.getLayout().getPrimitiveArrayLocation());
        ShapeImpl newShape = parent.createShape(parent.layout, parent.sharedData, parent, parent.objectType, parent.propertyMap, transition, allocator, parent.id);
        assert (newShape.hasPrimitiveArray());
        assert (newShape.depth == allocator.depth);
        return newShape;
    }

    private ShapeImpl addPrimitiveExtensionArray() {
        assert (this.layout.hasPrimitiveExtensionArray() && !this.hasPrimitiveArray());
        Transition.ReservePrimitiveArrayTransition transition = new Transition.ReservePrimitiveArrayTransition();
        ShapeImpl cachedShape = this.queryTransition(transition);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl oldShape = (ShapeImpl)this.layout.getStrategy().ensureSpace(this, this.layout.getPrimitiveArrayLocation());
        ShapeImpl newShape = ShapeImpl.makeShapeWithPrimitiveExtensionArray(oldShape, transition);
        oldShape.addDirectTransition(transition, newShape);
        return newShape;
    }

    @Override
    public boolean isRelated(Shape other) {
        if (this == other) {
            return true;
        }
        return this.getRoot() == this.getRoot();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final List<Property> getPropertyList(Shape.Pred<Property> filter) {
        LinkedList<Property> props = new LinkedList<Property>();
        block0: for (Property currentProperty : this.propertyMap.reverseOrderValues()) {
            if (currentProperty.isHidden() || !filter.test(currentProperty)) continue;
            if (currentProperty.getLocation() instanceof Locations.DeclaredLocation) {
                Iterator iter = props.iterator();
                while (iter.hasNext()) {
                    Property other = (Property)iter.next();
                    if (!other.isShadow() || !other.getKey().equals(currentProperty.getKey())) continue;
                    iter.remove();
                    props.addFirst(other);
                    continue block0;
                }
            }
            props.addFirst(currentProperty);
        }
        return props;
    }

    @Override
    public final List<Property> getPropertyList() {
        return this.getPropertyList(ALL);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final List<Property> getPropertyListInternal(boolean ascending) {
        LinkedList<Property> props = new LinkedList<Property>();
        for (Property current2 : this.propertyMap.reverseOrderValues()) {
            if (ascending) {
                props.addFirst(current2);
                continue;
            }
            props.add(current2);
        }
        return props;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final List<Object> getKeyList(Shape.Pred<Property> filter) {
        LinkedList<Object> keys2 = new LinkedList<Object>();
        for (Property currentProperty : this.propertyMap.reverseOrderValues()) {
            if (currentProperty.isHidden() || !filter.test(currentProperty) || currentProperty.isShadow()) continue;
            keys2.addFirst(currentProperty.getKey());
        }
        return keys2;
    }

    @Override
    public final List<Object> getKeyList() {
        return this.getKeyList(ALL);
    }

    @Override
    public Iterable<Object> getKeys() {
        return this.getKeyList();
    }

    @Override
    public final boolean isValid() {
        return this.getValidAssumption().isValid();
    }

    @Override
    public final Assumption getValidAssumption() {
        return this.validAssumption;
    }

    private static Assumption createValidAssumption() {
        return Truffle.getRuntime().createAssumption("valid shape");
    }

    public final void invalidateValidAssumption() {
        this.getValidAssumption().invalidate();
    }

    @Override
    public final boolean isLeaf() {
        return this.leafAssumption == null || this.leafAssumption.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Assumption getLeafAssumption() {
        if (this.leafAssumption == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object object = this.getMutex();
            synchronized (object) {
                if (this.leafAssumption == null) {
                    this.leafAssumption = this.isLeafHelper() ? ShapeImpl.createLeafAssumption() : NeverValidAssumption.INSTANCE;
                }
            }
        }
        return this.leafAssumption;
    }

    private boolean isLeafHelper() {
        return this.getTransitionMapForRead().isEmpty();
    }

    private static Assumption createLeafAssumption() {
        return Truffle.getRuntime().createAssumption("leaf shape");
    }

    private void invalidateLeafAssumption() {
        Assumption assumption = this.leafAssumption;
        if (assumption != null) {
            assumption.invalidate();
        } else {
            this.leafAssumption = NeverValidAssumption.INSTANCE;
        }
    }

    public String toString() {
        return this.toStringLimit(Integer.MAX_VALUE);
    }

    @CompilerDirectives.TruffleBoundary
    public String toStringLimit(int limit2) {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(Integer.toHexString(this.hashCode()));
        if (!this.isValid()) {
            sb.append('!');
        }
        sb.append("{");
        Iterator<Property> iterator = this.propertyMap.reverseOrderValues().iterator();
        while (iterator.hasNext()) {
            Property p2 = iterator.next();
            sb.append(p2);
            if (iterator.hasNext()) {
                sb.append(", ");
            }
            if (sb.length() >= limit2) {
                sb.append("...");
                break;
            }
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final ShapeImpl getParent() {
        return this.parent;
    }

    public final int getDepth() {
        return this.depth;
    }

    @Override
    public final boolean hasProperty(Object name2) {
        return this.getProperty(name2) != null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final ShapeImpl removeProperty(Property prop) {
        Transition.RemovePropertyTransition transition = new Transition.RemovePropertyTransition(prop);
        ShapeImpl cachedShape = this.queryTransition(transition);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl shape = this.getShapeFromProperty(prop);
        if (shape != null) {
            ArrayList<Transition> transitionList = new ArrayList<Transition>();
            ShapeImpl current2 = this;
            while (current2 != shape) {
                transitionList.add(current2.getTransitionFromParent());
                current2 = current2.parent;
            }
            ShapeImpl newShape = shape.parent;
            ListIterator iterator = transitionList.listIterator(transitionList.size());
            while (iterator.hasPrevious()) {
                Transition previous = (Transition)iterator.previous();
                newShape = newShape.applyTransition(previous, true);
            }
            this.getTransitionMapForWrite().put(transition, newShape);
            return newShape;
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final ShapeImpl append(Property oldProperty) {
        return this.addProperty(oldProperty.relocate(this.allocator().moveLocation(oldProperty.getLocation())));
    }

    public final ShapeImpl applyTransition(Transition transition, boolean append2) {
        if (transition instanceof Transition.AddPropertyTransition) {
            return append2 ? this.append(((Transition.AddPropertyTransition)transition).getProperty()) : this.addProperty(((Transition.AddPropertyTransition)transition).getProperty());
        }
        if (transition instanceof Transition.ObjectTypeTransition) {
            return this.changeType(((Transition.ObjectTypeTransition)transition).getObjectType());
        }
        if (transition instanceof Transition.ReservePrimitiveArrayTransition) {
            return this.reservePrimitiveExtensionArray();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final BaseAllocator allocator() {
        return this.layout.getStrategy().createAllocator(this);
    }

    @Override
    public final ShapeImpl replaceProperty(Property oldProperty, Property newProperty) {
        Transition.ReplacePropertyTransition replacePropertyTransition = new Transition.ReplacePropertyTransition(oldProperty, newProperty);
        ShapeImpl cachedShape = this.queryTransition(replacePropertyTransition);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl top = this;
        ArrayList<Transition> transitionList = new ArrayList<Transition>();
        boolean found = false;
        while (top != this.getRoot() && !found) {
            Transition transition = top.getTransitionFromParent();
            transitionList.add(transition);
            if (transition instanceof Transition.AddPropertyTransition && ((Transition.AddPropertyTransition)transition).getProperty().getKey().equals(newProperty.getKey())) {
                found = true;
            }
            top = top.parent;
        }
        ShapeImpl newShape = top;
        ListIterator iterator = transitionList.listIterator(transitionList.size());
        while (iterator.hasPrevious()) {
            Transition transition = (Transition)iterator.previous();
            newShape = transition instanceof Transition.AddPropertyTransition && ((Transition.AddPropertyTransition)transition).getProperty().getKey().equals(newProperty.getKey()) ? newShape.addProperty(newProperty) : newShape.applyTransition(transition, false);
        }
        this.addIndirectTransition(replacePropertyTransition, newShape);
        return newShape;
    }

    public static ShapeImpl findCommonAncestor(ShapeImpl left2, ShapeImpl right) {
        if (!left2.isRelated(right)) {
            throw new IllegalArgumentException("shapes must have the same root");
        }
        if (left2 == right) {
            return left2;
        }
        int leftLength = left2.depth;
        int rightLength = right.depth;
        ShapeImpl leftPtr = left2;
        ShapeImpl rightPtr = right;
        while (leftLength > rightLength) {
            leftPtr = leftPtr.parent;
            --leftLength;
        }
        while (rightLength > leftLength) {
            rightPtr = rightPtr.parent;
            --rightLength;
        }
        while (leftPtr != rightPtr) {
            leftPtr = leftPtr.parent;
            rightPtr = rightPtr.parent;
        }
        return leftPtr;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final ShapeImpl copyOverPropertiesInternal(Shape destination) {
        assert (((ShapeImpl)destination).getDepth() == 0);
        List<Property> properties = this.getPropertyListInternal(true);
        ShapeImpl newShape = ((ShapeImpl)destination).addPropertiesInternal(properties);
        return newShape;
    }

    private ShapeImpl addPropertiesInternal(List<Property> properties) {
        ShapeImpl newShape = this;
        for (Property p2 : properties) {
            newShape = newShape.addPropertyInternal(p2);
        }
        return newShape;
    }

    @Override
    public final int getPropertyCount() {
        return this.propertyCount;
    }

    public static List<Property> diff(Shape oldShape, Shape newShape) {
        List<Property> oldList = oldShape.getPropertyListInternal(false);
        List<Property> newList = newShape.getPropertyListInternal(false);
        ArrayList<Property> diff = new ArrayList<Property>(oldList);
        diff.addAll(newList);
        ArrayList<Property> intersection = new ArrayList<Property>(oldList);
        intersection.retainAll(newList);
        diff.removeAll(intersection);
        return diff;
    }

    @Override
    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public ShapeImpl getRoot() {
        return this.root;
    }

    @Override
    public final boolean check(DynamicObject subject) {
        return subject.getShape() == this;
    }

    @Override
    public final LayoutImpl getLayout() {
        return this.layout;
    }

    @Override
    public final Object getData() {
        return this.extraData;
    }

    @Override
    public final Object getSharedData() {
        return this.sharedData;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean hasTransitionWithKey(Object key2) {
        for (Transition transition : this.getTransitionMapForRead().keySet()) {
            if (!(transition instanceof Transition.PropertyTransition) || !((Transition.PropertyTransition)transition).getProperty().getKey().equals(key2)) continue;
            return true;
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final ShapeImpl createSeparateShape(Object newSharedData) {
        if (this.parent == null) {
            return this.cloneRoot(this, newSharedData);
        }
        return this.cloneOnto(this.parent.createSeparateShape(newSharedData));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final ShapeImpl changeType(ObjectType newOps) {
        Transition.ObjectTypeTransition transition = new Transition.ObjectTypeTransition(newOps);
        ShapeImpl cachedShape = this.queryTransition(transition);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl newShape = this.createShape(this.layout, this.sharedData, this, newOps, this.propertyMap, transition, this.allocator(), this.id);
        this.addDirectTransition(transition, newShape);
        return newShape;
    }

    @Override
    public final ShapeImpl reservePrimitiveExtensionArray() {
        if (this.layout.hasPrimitiveExtensionArray() && !this.hasPrimitiveArray()) {
            return this.addPrimitiveExtensionArray();
        }
        return this;
    }

    @Override
    public final Iterable<Property> getProperties() {
        if (this.getPropertyCount() != 0 && this.propertyArray == null) {
            CompilerDirectives.transferToInterpreter();
            this.propertyArray = this.createPropertiesArray();
        }
        return new Iterable<Property>(){

            @Override
            public Iterator<Property> iterator() {
                return new Iterator<Property>(){
                    private int cursor;

                    @Override
                    public boolean hasNext() {
                        return this.cursor < ShapeImpl.this.getPropertyCount();
                    }

                    @Override
                    public Property next() {
                        if (this.hasNext()) {
                            return (this).ShapeImpl.this.propertyArray[this.cursor++];
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private Property[] createPropertiesArray() {
        propertyListAllocCount.inc();
        Property[] propertiesArray = new Property[this.getPropertyCount()];
        List<Property> ownProperties = this.getPropertyList(ALL);
        assert (ownProperties.size() == this.getPropertyCount());
        int i2 = 0;
        while (i2 < this.getPropertyCount()) {
            propertiesArray[i2] = ownProperties.get(i2);
            ++i2;
        }
        return propertiesArray;
    }

    @Override
    public final DynamicObject newInstance() {
        return this.layout.newInstance(this);
    }

    @Override
    public final DynamicObjectFactory createFactory() {
        List<Property> properties = this.getPropertyListInternal(true);
        Iterator<Property> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            assert (property.getLocation() != this.layout.getPrimitiveArrayLocation());
            if (!(property.getLocation() instanceof Locations.ValueLocation)) continue;
            iterator.remove();
        }
        return new DynamicObjectFactory(properties){
            @CompilerDirectives.CompilationFinal
            private final PropertyImpl[] instanceFields;
            {
                this.instanceFields = list2.toArray(new PropertyImpl[list2.size()]);
            }

            @Override
            @ExplodeLoop
            public DynamicObject newInstance(Object ... initialValues) {
                DynamicObject store = ShapeImpl.this.newInstance();
                int i2 = 0;
                while (i2 < this.instanceFields.length) {
                    this.instanceFields[i2].setInternal(store, initialValues[i2]);
                    ++i2;
                }
                return store;
            }

            @Override
            public Shape getShape() {
                return ShapeImpl.this;
            }
        };
    }

    @Override
    public Object getMutex() {
        return this.getRoot();
    }

    @Override
    public Shape tryMerge(Shape other) {
        return null;
    }

    private static void debugRegisterShape(ShapeImpl newShape) {
        if (ObjectStorageOptions.DumpShapes) {
            Debug.registerShape(newShape);
        }
    }

    public static abstract class BaseAllocator
    extends Shape.Allocator {
        protected final LayoutImpl layout;
        protected int objectArraySize;
        protected int objectFieldSize;
        protected int primitiveFieldSize;
        protected int primitiveArraySize;
        protected boolean hasPrimitiveArray;
        protected int depth;

        protected BaseAllocator(LayoutImpl layout2) {
            this.layout = layout2;
        }

        protected BaseAllocator(ShapeImpl shape) {
            this(shape.getLayout());
            this.objectArraySize = shape.objectArraySize;
            this.objectFieldSize = shape.objectFieldSize;
            this.primitiveFieldSize = shape.primitiveFieldSize;
            this.primitiveArraySize = shape.primitiveArraySize;
            this.hasPrimitiveArray = shape.hasPrimitiveArray;
            this.depth = shape.depth;
        }

        protected abstract Location moveLocation(Location var1);

        protected abstract Location newObjectLocation(boolean var1, boolean var2);

        protected abstract Location newTypedObjectLocation(boolean var1, Class<?> var2, boolean var3);

        protected abstract Location newIntLocation(boolean var1);

        protected abstract Location newDoubleLocation(boolean var1);

        protected abstract Location newLongLocation(boolean var1);

        protected abstract Location newBooleanLocation(boolean var1);

        @Override
        public final Location constantLocation(Object value2) {
            return new Locations.ConstantLocation(value2);
        }

        @Override
        protected Location locationForValue(Object value2, boolean useFinal, boolean nonNull) {
            if (value2 instanceof Integer) {
                return this.newIntLocation(useFinal);
            }
            if (value2 instanceof Double) {
                return this.newDoubleLocation(useFinal);
            }
            if (value2 instanceof Long) {
                return this.newLongLocation(useFinal);
            }
            if (value2 instanceof Boolean) {
                return this.newBooleanLocation(useFinal);
            }
            if (ObjectStorageOptions.TypedObjectLocations && value2 != null) {
                return this.newTypedObjectLocation(useFinal, value2.getClass(), nonNull);
            }
            return this.newObjectLocation(useFinal, nonNull && value2 != null);
        }

        protected abstract Location locationForValueUpcast(Object var1, Location var2);

        @Override
        protected Location locationForType(Class<?> type2, boolean useFinal, boolean nonNull) {
            if (type2 == Integer.TYPE) {
                return this.newIntLocation(useFinal);
            }
            if (type2 == Double.TYPE) {
                return this.newDoubleLocation(useFinal);
            }
            if (type2 == Long.TYPE) {
                return this.newLongLocation(useFinal);
            }
            if (type2 == Boolean.TYPE) {
                return this.newBooleanLocation(useFinal);
            }
            if (ObjectStorageOptions.TypedObjectLocations && type2 != null && type2 != Object.class) {
                assert (!type2.isPrimitive()) : "unsupported primitive type";
                return this.newTypedObjectLocation(useFinal, type2, nonNull);
            }
            return this.newObjectLocation(useFinal, nonNull);
        }

        protected Location newDualLocation(Class<?> type2) {
            return new Locations.DualLocation((LocationImpl.InternalLongLocation)((Object)this.newLongLocation(false)), (ObjectLocation)((Object)this.newObjectLocation(false, false)), this.layout, type2);
        }

        protected Locations.DualLocation newDualLocationForValue(Object value2) {
            Class<Object> initialType = null;
            initialType = value2 instanceof Integer ? Integer.TYPE : (value2 instanceof Double ? Double.TYPE : (value2 instanceof Boolean ? Boolean.TYPE : Object.class));
            return new Locations.DualLocation((LocationImpl.InternalLongLocation)((Object)this.newLongLocation(false)), (ObjectLocation)((Object)this.newObjectLocation(false, false)), this.layout, initialType);
        }

        protected Location newDeclaredDualLocation(Object value2) {
            return new Locations.DeclaredDualLocation((LocationImpl.InternalLongLocation)((Object)this.newLongLocation(false)), (ObjectLocation)((Object)this.newObjectLocation(false, false)), value2, this.layout);
        }

        protected <T extends Location> T advance(T location0) {
            if (location0 instanceof LocationImpl) {
                LocationImpl location = (LocationImpl)location0;
                this.objectArraySize += location.objectArrayCount();
                this.primitiveArraySize += location.primitiveArrayCount();
                this.primitiveFieldSize += location.primitiveFieldCount();
                if (this.layout.hasPrimitiveExtensionArray()) {
                    this.hasPrimitiveArray |= location == this.layout.getPrimitiveArrayLocation() || location.primitiveArrayCount() != 0;
                    this.objectFieldSize = location == this.layout.getPrimitiveArrayLocation() ? this.objectFieldSize : Math.max(this.objectFieldSize, this.layout.objectFieldIndex(location) + location.objectFieldCount());
                } else {
                    assert (!this.hasPrimitiveArray && location.primitiveArrayCount() == 0);
                    this.objectFieldSize += location.objectFieldCount();
                }
            }
            ++this.depth;
            return location0;
        }

        @Override
        public BaseAllocator addLocation(Location location) {
            this.advance(location);
            return this;
        }
    }
}

