/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.ValueProfile;
import java.util.Objects;

public class PrimitiveValueProfile
extends ValueProfile {
    private static final Object UNINITIALIZED = new Object();
    private static final Object GENERIC = new Object();
    @CompilerDirectives.CompilationFinal
    private Object cachedValue = UNINITIALIZED;

    PrimitiveValueProfile() {
    }

    public Object profile(Object value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Byte && value2 instanceof Byte && ((Byte)this.cachedValue).byteValue() == ((Byte)value2).byteValue()) {
                return this.cachedValue;
            }
            if (this.cachedValue instanceof Short && value2 instanceof Short && ((Short)this.cachedValue).shortValue() == ((Short)value2).shortValue()) {
                return this.cachedValue;
            }
            if (this.cachedValue instanceof Integer && value2 instanceof Integer && ((Integer)this.cachedValue).intValue() == ((Integer)value2).intValue()) {
                return this.cachedValue;
            }
            if (this.cachedValue instanceof Long && value2 instanceof Long && ((Long)this.cachedValue).longValue() == ((Long)value2).longValue()) {
                return this.cachedValue;
            }
            if (this.cachedValue instanceof Float && value2 instanceof Float && PrimitiveValueProfile.exactCompare(((Float)this.cachedValue).floatValue(), ((Float)value2).floatValue())) {
                return this.cachedValue;
            }
            if (this.cachedValue instanceof Double && value2 instanceof Double && PrimitiveValueProfile.exactCompare((Double)this.cachedValue, (Double)value2)) {
                return this.cachedValue;
            }
            if (this.cachedValue instanceof Boolean && value2 instanceof Boolean && ((Boolean)this.cachedValue).booleanValue() == ((Boolean)value2).booleanValue()) {
                return this.cachedValue;
            }
            if (this.cachedValue instanceof Character && value2 instanceof Character && ((Character)this.cachedValue).charValue() == ((Character)value2).charValue()) {
                return this.cachedValue;
            }
            if (this.cachedValue == value2) {
                return this.cachedValue;
            }
            this.cacheMiss(value2);
        }
        return value2;
    }

    public byte profile(byte value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Byte && (Byte)this.cachedValue == value2) {
                return (Byte)this.cachedValue;
            }
            this.cacheMiss(value2);
        }
        return value2;
    }

    public short profile(short value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Short && (Short)this.cachedValue == value2) {
                return (Short)this.cachedValue;
            }
            this.cacheMiss(value2);
        }
        return value2;
    }

    public int profile(int value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Integer && (Integer)this.cachedValue == value2) {
                return (Integer)this.cachedValue;
            }
            this.cacheMiss(value2);
        }
        return value2;
    }

    public long profile(long value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Long && (Long)this.cachedValue == value2) {
                return (Long)this.cachedValue;
            }
            this.cacheMiss(value2);
        }
        return value2;
    }

    public float profile(float value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Float && PrimitiveValueProfile.exactCompare(((Float)this.cachedValue).floatValue(), value2)) {
                return ((Float)this.cachedValue).floatValue();
            }
            this.cacheMiss(Float.valueOf(value2));
        }
        return value2;
    }

    public double profile(double value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Double && PrimitiveValueProfile.exactCompare((Double)this.cachedValue, value2)) {
                return (Double)this.cachedValue;
            }
            this.cacheMiss(value2);
        }
        return value2;
    }

    public boolean profile(boolean value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Boolean && (Boolean)this.cachedValue == value2) {
                return (Boolean)this.cachedValue;
            }
            this.cacheMiss(value2);
        }
        return value2;
    }

    public char profile(char value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue instanceof Character && ((Character)this.cachedValue).charValue() == value2) {
                return ((Character)this.cachedValue).charValue();
            }
            this.cacheMiss(Character.valueOf(value2));
        }
        return value2;
    }

    public boolean isGeneric() {
        return this.getCachedValue() == GENERIC;
    }

    public boolean isUninitialized() {
        return this.getCachedValue() == UNINITIALIZED;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public String toString() {
        return String.format("%s(%s)@%x", this.getClass().getSimpleName(), this.formatValue(), this.hashCode());
    }

    private void cacheMiss(Object value2) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.cachedValue = this.cachedValue == UNINITIALIZED ? value2 : GENERIC;
    }

    public static boolean exactCompare(float a, float b2) {
        return Float.floatToRawIntBits(a) == Float.floatToRawIntBits(b2);
    }

    public static boolean exactCompare(double a, double b2) {
        return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b2);
    }

    private String formatValue() {
        if (this.cachedValue == null) {
            return "null";
        }
        if (this.cachedValue == UNINITIALIZED) {
            return "uninitialized";
        }
        if (this.cachedValue == GENERIC) {
            return "generic";
        }
        if (this.cachedValue instanceof Byte || this.cachedValue instanceof Short || this.cachedValue instanceof Integer || this.cachedValue instanceof Long || this.cachedValue instanceof Float || this.cachedValue instanceof Double || this.cachedValue instanceof Boolean || this.cachedValue instanceof Character) {
            return String.format("%s=%s", this.cachedValue.getClass().getSimpleName(), this.cachedValue);
        }
        return String.format("%s@%x", this.cachedValue.getClass().getSimpleName(), Objects.hash(this.cachedValue));
    }
}

