/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONHelper {
    private static StringBuilder AstJsonDumpBuilder = new StringBuilder();

    public static void dumpNewChild(Node parentNode, Node childNode) {
        if (AstJsonDumpBuilder != null) {
            AstJsonDumpBuilder.append("{ \"action\": \"insertNode\", \"parentId\": \"" + JSONHelper.getID(parentNode) + "\", \"newId\": \"" + JSONHelper.getID(childNode) + "\" },\n");
        }
    }

    public static void dumpReplaceChild(Node oldNode, Node newNode, CharSequence reason2) {
        if (AstJsonDumpBuilder != null) {
            AstJsonDumpBuilder.append("{ \"action\": \"replaceNode\", \"oldId\": \"" + JSONHelper.getID(oldNode) + "\", \"newId\": \"" + JSONHelper.getID(newNode) + "\", \"reason\": " + JSONHelper.quote(reason2) + " },\n");
        }
    }

    public static void dumpNewNode(Node newNode) {
        if (AstJsonDumpBuilder != null) {
            AstJsonDumpBuilder.append("{ \"action\": \"createNode\", \"newId\": \"" + JSONHelper.getID(newNode) + "\", \"type\": \"" + JSONHelper.getType(newNode) + "\", \"description\": \"" + newNode.getDescription() + "\", \"language\": \"" + newNode.getLanguage() + "\"" + JSONHelper.getSourceSectionInfo(newNode) + " },\n");
        }
    }

    private static String getSourceSectionInfo(Node newNode) {
        SourceSection sourceSection = newNode.getSourceSection();
        if (sourceSection != null) {
            return ", \"identifier\": \"" + sourceSection.getIdentifier() + "\" ";
        }
        return "";
    }

    public static String getResult() {
        return AstJsonDumpBuilder.toString();
    }

    private static String getID(Node newChild) {
        return String.valueOf(newChild.hashCode());
    }

    private static String getType(Node node) {
        return node.getClass().getSimpleName();
    }

    private static String quote(CharSequence value2) {
        StringBuilder builder = new StringBuilder(value2.length() + 2);
        builder.append('\"');
        int i2 = 0;
        while (i2 < value2.length()) {
            char c = value2.charAt(i2);
            switch (c) {
                case '\"': {
                    builder.append("\\\"");
                    break;
                }
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                case '\b': {
                    builder.append("\\b");
                    break;
                }
                case '\f': {
                    builder.append("\\f");
                    break;
                }
                case '\n': {
                    builder.append("\\n");
                    break;
                }
                case '\r': {
                    builder.append("\\r");
                    break;
                }
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                default: {
                    if (c < ' ') {
                        builder.append("\\u00");
                        builder.append(Character.forDigit(c >> 4 & 0xF, 16));
                        builder.append(Character.forDigit(c & 0xF, 16));
                        break;
                    }
                    builder.append(c);
                }
            }
            ++i2;
        }
        builder.append('\"');
        return builder.toString();
    }

    public static void restart() {
        AstJsonDumpBuilder = new StringBuilder();
    }

    public static JSONObjectBuilder object() {
        return new JSONObjectBuilder();
    }

    public static JSONArrayBuilder array() {
        return new JSONArrayBuilder();
    }

    public static final class JSONArrayBuilder
    extends JSONStringBuilder {
        private final List<Object> contents = new ArrayList<Object>();

        private JSONArrayBuilder() {
        }

        public JSONArrayBuilder add(String value2) {
            this.contents.add(value2);
            return this;
        }

        public JSONArrayBuilder add(Number value2) {
            this.contents.add(value2);
            return this;
        }

        public JSONArrayBuilder add(Boolean value2) {
            this.contents.add(value2);
            return this;
        }

        public JSONArrayBuilder add(JSONStringBuilder value2) {
            this.contents.add(value2);
            return this;
        }

        @Override
        protected void appendTo(StringBuilder sb) {
            sb.append("[");
            boolean comma = false;
            for (Object value2 : this.contents) {
                if (comma) {
                    sb.append(", ");
                }
                JSONArrayBuilder.appendValue(sb, value2);
                comma = true;
            }
            sb.append("]");
        }
    }

    public static final class JSONObjectBuilder
    extends JSONStringBuilder {
        private final Map<String, Object> contents = new LinkedHashMap<String, Object>();

        private JSONObjectBuilder() {
        }

        public JSONObjectBuilder add(String key2, String value2) {
            this.contents.put(key2, value2);
            return this;
        }

        public JSONObjectBuilder add(String key2, Number value2) {
            this.contents.put(key2, value2);
            return this;
        }

        public JSONObjectBuilder add(String key2, Boolean value2) {
            this.contents.put(key2, value2);
            return this;
        }

        public JSONObjectBuilder add(String key2, JSONStringBuilder value2) {
            this.contents.put(key2, value2);
            return this;
        }

        @Override
        protected void appendTo(StringBuilder sb) {
            sb.append("{");
            boolean comma = false;
            for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
                if (comma) {
                    sb.append(", ");
                }
                sb.append(JSONHelper.quote(entry.getKey()));
                sb.append(": ");
                JSONObjectBuilder.appendValue(sb, entry.getValue());
                comma = true;
            }
            sb.append("}");
        }
    }

    public static abstract class JSONStringBuilder {
        public final String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        protected abstract void appendTo(StringBuilder var1);

        protected static void appendValue(StringBuilder sb, Object value2) {
            if (value2 instanceof JSONStringBuilder) {
                ((JSONStringBuilder)value2).appendTo(sb);
            } else if (value2 instanceof Integer || value2 instanceof Boolean || value2 == null) {
                sb.append(value2);
            } else {
                sb.append(JSONHelper.quote(String.valueOf(value2)));
            }
        }
    }
}

