/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl.internal;

import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class NodeFactoryBase<T>
implements NodeFactory<T> {
    private final Class<T> nodeClass;
    private final Class<?>[][] nodeSignatures;
    private final Class<? extends Node>[] executionSignatures;

    public NodeFactoryBase(Class<T> nodeClass, Class<?>[] executionSignatures, Class<?>[][] nodeSignatures) {
        this.nodeClass = nodeClass;
        this.nodeSignatures = nodeSignatures;
        this.executionSignatures = executionSignatures;
    }

    @Override
    public abstract T createNode(Object ... var1);

    @Override
    public final Class<T> getNodeClass() {
        return this.nodeClass;
    }

    @Override
    public final List<List<Class<?>>> getNodeSignatures() {
        ArrayList signatures = new ArrayList();
        int i2 = 0;
        while (i2 < this.nodeSignatures.length) {
            signatures.add(Arrays.asList(this.nodeSignatures[i2]));
            ++i2;
        }
        return signatures;
    }

    @Override
    public final List<Class<? extends Node>> getExecutionSignature() {
        return Arrays.asList(this.executionSignatures);
    }
}

