/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.jruby.util.URLUtil;

public class CompoundJarURLStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL = "compoundjar";
    private static final CompoundJarURLStreamHandler instance = new CompoundJarURLStreamHandler();

    public static URL createUrl(URL base, List<String> path2) throws MalformedURLException {
        return CompoundJarURLStreamHandler.createUrl(base, path2.toArray(new String[0]));
    }

    public static URL createUrl(URL base, String ... path2) throws MalformedURLException {
        StringBuilder pathBuilder = new StringBuilder();
        if (base.getProtocol().equals("jar")) {
            pathBuilder.append(URLUtil.getPath(base));
        } else {
            pathBuilder.append(base.toExternalForm());
        }
        for (String entry : path2) {
            pathBuilder.append("!");
            if (!entry.startsWith("/")) {
                pathBuilder.append("/");
            }
            pathBuilder.append(entry);
        }
        return new URL(PROTOCOL, null, -1, pathBuilder.toString(), instance);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new CompoundJarURLConnection(url);
    }

    static class CompoundJarURLConnection
    extends URLConnection {
        private final URL baseJarUrl;
        private final String[] path;
        private static final Map<String, Map<String, byte[]>> cache = new ConcurrentHashMap<String, Map<String, byte[]>>(16, 0.75f, 4);

        CompoundJarURLConnection(URL url) throws MalformedURLException {
            super(url);
            String spec = URLUtil.getPath(url);
            this.path = spec.split("\\!\\/");
            this.baseJarUrl = new URL(this.path[0]);
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        private InputStream openEntryWithCache(String[] path2, InputStream currentStream, int currentDepth) throws IOException {
            byte[] bytes2;
            String localPath = path2[currentDepth];
            if (currentDepth == 1 && path2[0].indexOf(33) == -1 && path2[0].startsWith("file:")) {
                JarFile jarFile = new JarFile(path2[0].substring(5));
                JarEntry entry = jarFile.getJarEntry(localPath);
                if (entry != null) {
                    return this.returnOrRecurse(path2, jarFile.getInputStream(entry), currentDepth);
                }
                return null;
            }
            StringBuilder pathToHereBuffer = new StringBuilder();
            for (int i2 = 0; i2 < currentDepth; ++i2) {
                if (i2 > 0) {
                    pathToHereBuffer.append("!/");
                }
                pathToHereBuffer.append(path2[i2]);
            }
            String pathToHere = pathToHereBuffer.toString();
            Map<String, byte[]> contents = cache.get(pathToHere);
            if (contents == null) {
                contents = new ConcurrentHashMap<String, byte[]>(16, 0.75f, 2);
                cache.put(pathToHere, contents);
                this.cacheJarFrom(currentStream, contents);
            }
            if ((bytes2 = contents.get(localPath)) != null) {
                return this.returnOrRecurse(path2, new ByteArrayInputStream(bytes2), currentDepth);
            }
            return null;
        }

        private void cacheJarFrom(InputStream currentStream, Map<String, byte[]> contents) throws IOException {
            JarInputStream currentJar = new JarInputStream(currentStream);
            JarEntry entry = currentJar.getNextJarEntry();
            while (entry != null) {
                int size2;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes2 = new byte[1024];
                while ((size2 = currentJar.read(bytes2, 0, 1024)) != -1) {
                    baos.write(bytes2, 0, size2);
                }
                bytes2 = baos.toByteArray();
                contents.put(entry.getName(), bytes2);
                entry = currentJar.getNextJarEntry();
            }
        }

        private InputStream returnOrRecurse(String[] path2, InputStream nextStream, int currentDepth) throws IOException {
            if (currentDepth + 1 < path2.length) {
                return this.openEntryWithCache(path2, nextStream, currentDepth + 1);
            }
            return nextStream;
        }

        private static void close(Closeable resource2) {
            if (resource2 != null) {
                try {
                    resource2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream result2;
            InputStream baseInputStream = this.baseJarUrl.openStream();
            if (this.path.length > 1) {
                try {
                    result2 = this.openEntryWithCache(this.path, baseInputStream, 1);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                finally {
                    CompoundJarURLConnection.close(baseInputStream);
                }
            } else {
                result2 = baseInputStream;
            }
            if (result2 == null) {
                throw new FileNotFoundException(this.url.toExternalForm());
            }
            return result2;
        }
    }
}

