/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.util.DefinedMessage;

public class ConstNode
extends Node
implements INameNode {
    private String name;
    private ConstantCache cache;

    public ConstNode(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CONSTNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitConstNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
        this.cache = null;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject value2 = this.getValue(context);
        return value2 != null ? value2 : context.getCurrentScope().getStaticScope().getModule().callMethod(context, "const_missing", (IRubyObject)runtime.fastNewSymbol(this.name));
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return context.getCurrentStaticScope().isConstantDefined(this.name) ? runtime.getDefinedMessage(DefinedMessage.CONSTANT) : null;
    }

    public IRubyObject getValue(ThreadContext context) {
        ConstantCache cache = this.cache;
        return ConstantCache.isCached(cache) ? cache.value : this.reCache(context, this.name);
    }

    public IRubyObject reCache(ThreadContext context, String name2) {
        Invalidator invalidator = context.runtime.getConstantInvalidator(name2);
        Object newGeneration = invalidator.getData();
        IRubyObject value2 = context.getCurrentStaticScope().getConstant(name2);
        this.name = name2;
        this.cache = value2 != null ? new ConstantCache(value2, newGeneration, invalidator) : null;
        return value2;
    }
}

