/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.jar.JarEntry;
import jnr.posix.POSIX;
import org.jruby.util.JarCache;
import org.jruby.util.JarResource;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

class JarFileResource
extends JarResource {
    private final JarCache.JarIndex index;
    private final JarEntry entry;

    JarFileResource(String jarPath, boolean rootSlashPrefix, JarCache.JarIndex index2, JarEntry entry) {
        super(jarPath, rootSlashPrefix);
        this.index = index2;
        this.entry = entry;
    }

    @Override
    public String entryName() {
        return this.entry.getName();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public long length() {
        return this.entry.getSize();
    }

    @Override
    public long lastModified() {
        return this.entry.getTime();
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public InputStream openInputStream() {
        return this.index.getInputStream(this.entry);
    }

    @Override
    public ChannelDescriptor openDescriptor(ModeFlags flags, POSIX posix, int perm) throws ResourceException {
        return new ChannelDescriptor((Channel)Channels.newChannel(this.openInputStream()), flags);
    }
}

