/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNameError;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NoMethodError"}, parent="NameError")
public class RubyNoMethodError
extends RubyNameError {
    private IRubyObject args;
    private static final ObjectAllocator NOMETHODERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNoMethodError(runtime, klass);
        }
    };

    public static RubyClass createNoMethodErrorClass(Ruby runtime, RubyClass nameErrorClass) {
        RubyClass noMethodErrorClass = runtime.defineClass("NoMethodError", nameErrorClass, NOMETHODERROR_ALLOCATOR);
        noMethodErrorClass.defineAnnotatedMethods(RubyNoMethodError.class);
        return noMethodErrorClass;
    }

    protected RubyNoMethodError(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass, exceptionClass.getName());
        this.args = runtime.getNil();
    }

    public RubyNoMethodError(Ruby runtime, RubyClass exceptionClass, String message2, String name2, IRubyObject args2) {
        super(runtime, exceptionClass, message2, name2);
        this.args = args2;
    }

    @Override
    @JRubyMethod(optional=3)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        if (args2.length > 2) {
            this.args = args2[args2.length - 1];
            IRubyObject[] tmpArgs = new IRubyObject[args2.length - 1];
            System.arraycopy(args2, 0, tmpArgs, 0, tmpArgs.length);
            args2 = tmpArgs;
        } else {
            this.args = this.getRuntime().getNil();
        }
        super.initialize(args2, block);
        return this;
    }

    @JRubyMethod(name={"args"})
    public IRubyObject args() {
        return this.args;
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
        super.copySpecialInstanceVariables(clone);
        RubyNoMethodError exception2 = (RubyNoMethodError)clone;
        exception2.args = this.args;
    }
}

