/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import jnr.ffi.util.AnnotationNameComparator;

public final class Annotations {
    public static final Collection<Annotation> EMPTY_ANNOTATIONS = Collections.emptyList();

    private Annotations() {
    }

    public static Collection<Annotation> sortedAnnotationCollection(Annotation[] annotations2) {
        if (annotations2.length > 1) {
            return Annotations.sortedAnnotationCollection(Arrays.asList(annotations2));
        }
        if (annotations2.length > 0) {
            return Collections.singletonList(annotations2[0]);
        }
        return Collections.emptyList();
    }

    public static Collection<Annotation> sortedAnnotationCollection(Collection<Annotation> annotations2) {
        if (annotations2.size() < 2 || annotations2 instanceof SortedSet && ((SortedSet)annotations2).comparator() instanceof AnnotationNameComparator) {
            return annotations2;
        }
        TreeSet<Annotation> sorted = new TreeSet<Annotation>(AnnotationNameComparator.getInstance());
        sorted.addAll(annotations2);
        return Collections.unmodifiableSortedSet(sorted);
    }

    public static final Collection<Annotation> mergeAnnotations(Collection<Annotation> a, Collection<Annotation> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return EMPTY_ANNOTATIONS;
        }
        if (!a.isEmpty() && b.isEmpty()) {
            return a;
        }
        if (a.isEmpty() && !b.isEmpty()) {
            return b;
        }
        ArrayList<Annotation> all = new ArrayList<Annotation>(a);
        all.addAll(b);
        return Annotations.sortedAnnotationCollection(all);
    }

    public static final Collection<Annotation> mergeAnnotations(Collection<Annotation> ... collections) {
        int totalLength = 0;
        for (Collection<Annotation> c : collections) {
            totalLength += c.size();
        }
        ArrayList<Annotation> all = new ArrayList<Annotation>(totalLength);
        for (Collection<Annotation> c : collections) {
            all.addAll(c);
        }
        return Annotations.sortedAnnotationCollection(all);
    }
}

