/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyRegexp;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Reference;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Backref
extends Reference {
    public final char type;

    public Backref(char t) {
        super("$" + t);
        this.type = t;
    }

    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        IRubyObject backref = currDynScope.getBackRef(context.runtime);
        switch (this.type) {
            case '&': {
                return RubyRegexp.last_match(backref);
            }
            case '`': {
                return RubyRegexp.match_pre(backref);
            }
            case '\'': {
                return RubyRegexp.match_post(backref);
            }
            case '+': {
                return RubyRegexp.match_last(backref);
            }
        }
        assert (false) : "backref with invalid type";
        return null;
    }

    public void visit(IRVisitor visitor) {
        visitor.Backref(this);
    }

    public String toString() {
        return "$'" + this.type + "'";
    }
}

