/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.DHValidationParms;

public class DHDomainParameters
extends ASN1Encodable {
    private DERInteger p;
    private DERInteger g;
    private DERInteger q;
    private DERInteger j;
    private DHValidationParms validationParms;

    public static DHDomainParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DHDomainParameters.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DHDomainParameters getInstance(Object object) {
        if (object == null || object instanceof DHDomainParameters) {
            return (DHDomainParameters)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DHDomainParameters((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid DHDomainParameters: " + object.getClass().getName());
    }

    public DHDomainParameters(DERInteger dERInteger, DERInteger dERInteger2, DERInteger dERInteger3, DERInteger dERInteger4, DHValidationParms dHValidationParms) {
        if (dERInteger == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (dERInteger2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (dERInteger3 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.p = dERInteger;
        this.g = dERInteger2;
        this.q = dERInteger3;
        this.j = dERInteger4;
        this.validationParms = dHValidationParms;
    }

    private DHDomainParameters(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 3 || aSN1Sequence.size() > 5) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.p = DERInteger.getInstance(enumeration.nextElement());
        this.g = DERInteger.getInstance(enumeration.nextElement());
        this.q = DERInteger.getInstance(enumeration.nextElement());
        DEREncodable dEREncodable = DHDomainParameters.getNext(enumeration);
        if (dEREncodable != null && dEREncodable instanceof DERInteger) {
            this.j = DERInteger.getInstance(dEREncodable);
            dEREncodable = DHDomainParameters.getNext(enumeration);
        }
        if (dEREncodable != null) {
            this.validationParms = DHValidationParms.getInstance(dEREncodable.getDERObject());
        }
    }

    private static DEREncodable getNext(Enumeration enumeration) {
        return enumeration.hasMoreElements() ? (DEREncodable)enumeration.nextElement() : null;
    }

    public DERInteger getP() {
        return this.p;
    }

    public DERInteger getG() {
        return this.g;
    }

    public DERInteger getQ() {
        return this.q;
    }

    public DERInteger getJ() {
        return this.j;
    }

    public DHValidationParms getValidationParms() {
        return this.validationParms;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.g);
        aSN1EncodableVector.add(this.q);
        if (this.j != null) {
            aSN1EncodableVector.add(this.j);
        }
        if (this.validationParms != null) {
            aSN1EncodableVector.add(this.validationParms);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

