/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.unsafe.UnsafeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaCallable
extends JavaAccessibleObject
implements ParameterTypes {
    protected final Class<?>[] parameterTypes;

    public JavaCallable(Ruby runtime, RubyClass rubyClass, Class<?>[] parameterTypes) {
        super(runtime, rubyClass);
        this.parameterTypes = parameterTypes;
    }

    public static void registerRubyMethods(Ruby runtime, RubyClass result2) {
        result2.defineAnnotatedMethods(JavaCallable.class);
    }

    public abstract int getArity();

    public abstract int getModifiers();

    @Override
    public abstract Class<?>[] getParameterTypes();

    @Override
    public abstract Class<?>[] getExceptionTypes();

    public abstract Type[] getGenericExceptionTypes();

    public abstract Type[] getGenericParameterTypes();

    public abstract Annotation[][] getParameterAnnotations();

    @Override
    public abstract boolean isVarArgs();

    public abstract String toGenericString();

    protected abstract String nameOnInspection();

    @JRubyMethod
    public final RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getArity());
    }

    @JRubyMethod
    public final RubyArray argument_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getParameterTypes());
    }

    @JRubyMethod
    public IRubyObject parameter_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getParameterTypes());
    }

    @JRubyMethod
    public IRubyObject exception_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getExceptionTypes());
    }

    @JRubyMethod
    public IRubyObject generic_parameter_types() {
        return Java.getInstance(this.getRuntime(), this.getGenericParameterTypes());
    }

    @JRubyMethod
    public IRubyObject generic_exception_types() {
        return Java.getInstance(this.getRuntime(), this.getGenericExceptionTypes());
    }

    @JRubyMethod
    public IRubyObject parameter_annotations() {
        return Java.getInstance(this.getRuntime(), this.getParameterAnnotations());
    }

    @JRubyMethod(name={"varargs?"})
    public RubyBoolean varargs_p() {
        return this.getRuntime().newBoolean(this.isVarArgs());
    }

    @JRubyMethod
    public RubyString to_generic_string() {
        return this.getRuntime().newString(this.toGenericString());
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.nameOnInspection());
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            result2.append(parameterTypes[i2].getName());
            if (i2 >= parameterTypes.length - 1) continue;
            result2.append(',');
        }
        result2.append(")>");
        return this.getRuntime().newString(result2.toString());
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isPublic(this.getModifiers()));
    }

    protected void checkArity(int length2) {
        if (length2 != this.getArity()) {
            throw this.getRuntime().newArgumentError(length2, this.getArity());
        }
    }

    protected static String dumpArgTypes(Object[] arguments) {
        StringBuilder str = new StringBuilder("[");
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (i2 > 0) {
                str.append(",");
            }
            if (arguments[i2] == null) {
                str.append("null");
                continue;
            }
            str.append(arguments[i2].getClass().getName());
        }
        str.append("]");
        return str.toString();
    }

    protected IRubyObject handleThrowable(Throwable t, Member target) {
        UnsafeFactory.getUnsafe().throwException(t);
        return this.getRuntime().getNil();
    }

    protected IRubyObject handleInvocationTargetEx(InvocationTargetException ite, Member target) {
        UnsafeFactory.getUnsafe().throwException(ite.getTargetException());
        return this.getRuntime().getNil();
    }
}

