/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class JumpInstr
extends Instr {
    public final Label target;

    public JumpInstr(Label target) {
        super(Operation.JUMP);
        this.target = target;
    }

    public Operand[] getOperands() {
        return EMPTY_OPERANDS;
    }

    public String toString() {
        return super.toString() + " " + this.target;
    }

    public Label getJumpTarget() {
        return this.target;
    }

    public Instr cloneForInlinedScope(InlinerInfo ii) {
        return new JumpInstr(ii.getRenamedLabel(this.target));
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new JumpInstr(this.target);
    }

    public void visit(IRVisitor visitor) {
        visitor.JumpInstr(this);
    }
}

